/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.autodetecting;

import com.intellij.facet.Facet;
import com.intellij.facet.impl.autodetecting.model.DetectedFacetInfo;
import com.intellij.facet.impl.autodetecting.model.FacetInfo2;
import com.intellij.facet.impl.autodetecting.model.FacetInfoBackedByFacet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.util.SmartList;
import com.intellij.util.fileIndex.FileIndexEntry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FacetDetectionIndexEntry
extends FileIndexEntry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.autodetecting.FacetDetectionIndexEntry");
    private SmartList<FacetPointer> myFacets;
    private SmartList<Integer> myDetectedFacetIds;

    public FacetDetectionIndexEntry(long timestamp) {
        super(timestamp);
    }

    public FacetDetectionIndexEntry(DataInputStream stream, FacetPointersManager facetPointersManager) throws IOException {
        super(stream);
        int size = stream.readInt();
        if (size > 0) {
            while (size-- > 0) {
                String id = stream.readUTF();
                if (id.startsWith("/")) {
                    if (this.myDetectedFacetIds == null) {
                        this.myDetectedFacetIds = new SmartList();
                    }
                    this.myDetectedFacetIds.add((Object)Integer.parseInt(id.substring(1)));
                    continue;
                }
                if (this.myFacets == null) {
                    this.myFacets = new SmartList();
                }
                this.myFacets.add((Object)facetPointersManager.create(id));
            }
        }
    }

    @Nullable
    public SmartList<FacetPointer> getFacets() {
        return this.myFacets;
    }

    @Nullable
    public SmartList<Integer> getDetectedFacetIds() {
        return this.myDetectedFacetIds;
    }

    @Override
    public void write(DataOutputStream stream) throws IOException {
        super.write(stream);
        int number = (this.myFacets != null ? this.myFacets.size() : 0) + (this.myDetectedFacetIds != null ? this.myDetectedFacetIds.size() : 0);
        stream.writeInt(number);
        if (this.myFacets != null) {
            for (FacetPointer facetPointer : this.myFacets) {
                stream.writeUTF(facetPointer.getId());
            }
        }
        if (this.myDetectedFacetIds != null) {
            for (Integer id : this.myDetectedFacetIds) {
                stream.writeUTF("/" + id);
            }
        }
    }

    @Nullable
    public Collection<Integer> update(FacetPointersManager facetPointersManager, @Nullable List<FacetInfo2<Module>> detectedFacets) {
        if (detectedFacets == null || detectedFacets.isEmpty()) {
            SmartList<Integer> old = this.myDetectedFacetIds;
            this.myFacets = null;
            this.myDetectedFacetIds = null;
            return old;
        }
        if (this.myFacets == null) {
            this.myFacets = new SmartList();
        } else {
            this.myFacets.clear();
        }
        if (this.myDetectedFacetIds == null) {
            this.myDetectedFacetIds = new SmartList();
        }
        HashSet<Integer> toRemove = new HashSet<Integer>((Collection<Integer>)this.myDetectedFacetIds);
        for (FacetInfo2<Module> info : detectedFacets) {
            if (info instanceof FacetInfoBackedByFacet) {
                FacetPointer pointer = facetPointersManager.create(((FacetInfoBackedByFacet)info).getFacet());
                LOG.assertTrue(pointer.getModuleName().length() > 0);
                this.myFacets.add((Object)pointer);
                continue;
            }
            Integer id = ((DetectedFacetInfo)info).getId();
            boolean removed = toRemove.remove(id);
            if (removed) continue;
            this.myDetectedFacetIds.add((Object)id);
        }
        this.myDetectedFacetIds.removeAll(toRemove);
        return toRemove;
    }

    public void remove(FacetPointer facetPointer) {
        if (this.myFacets != null) {
            this.myFacets.remove((Object)facetPointer);
        }
    }

    public void remove(Integer id) {
        if (this.myDetectedFacetIds != null) {
            this.myDetectedFacetIds.remove((Object)id);
        }
    }

    public void add(FacetPointer<Facet> pointer) {
        if (this.myFacets == null) {
            this.myFacets = new SmartList();
        }
        LOG.assertTrue(pointer.getModuleName().length() > 0);
        this.myFacets.add(pointer);
    }
}

