/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetUtil {
    private FacetUtil() {
    }

    public static void deleteFacet(final Facet facet) {
        new WriteAction(){

            protected void run(Result result) {
                if (!FacetUtil.isRegistered(facet)) {
                    return;
                }
                ModifiableFacetModel model = FacetManager.getInstance((Module)facet.getModule()).createModifiableModel();
                model.removeFacet(facet);
                model.commit();
            }
        }.execute();
    }

    public static boolean isRegistered(Facet facet) {
        return Arrays.asList(FacetManager.getInstance((Module)facet.getModule()).getAllFacets()).contains(facet);
    }

    public static void loadFacetConfiguration(@NotNull FacetConfiguration configuration, @Nullable Element config) throws InvalidDataException {
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/FacetUtil.loadFacetConfiguration must not be null");
        }
        if (config != null) {
            if (configuration instanceof PersistentStateComponent) {
                TypeVariable variable = PersistentStateComponent.class.getTypeParameters()[0];
                Class stateClass = ReflectionUtil.getRawType((Type)ReflectionUtil.resolveVariableInHierarchy(variable, configuration.getClass()));
                ((PersistentStateComponent)configuration).loadState(XmlSerializer.deserialize((Element)config, (Class)stateClass));
            } else {
                configuration.readExternal(config);
            }
        }
    }

    public static Element saveFacetConfiguration(FacetConfiguration configuration) throws WriteExternalException {
        if (configuration instanceof PersistentStateComponent) {
            Object state = ((PersistentStateComponent)configuration).getState();
            return XmlSerializer.serialize((Object)state, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        }
        Element config = new Element("configuration");
        configuration.writeExternal(config);
        return config;
    }
}

