/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class PsiFileBase
extends PsiFileImpl {
    @NotNull
    private final Language myLanguage;
    @NotNull
    private final ParserDefinition myParserDefinition;

    protected PsiFileBase(FileViewProvider viewProvider, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/extapi/psi/PsiFileBase.<init> must not be null");
        }
        super(viewProvider);
        this.myLanguage = this.findLanguage(language);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.myLanguage);
        if (parserDefinition == null) {
            throw new RuntimeException("PsiFileBase: language.getParserDefinition() returned null.");
        }
        this.myParserDefinition = parserDefinition;
        IFileElementType nodeType = parserDefinition.getFileNodeType();
        assert (nodeType.getLanguage() == this.myLanguage);
        this.init((IElementType)nodeType, (IElementType)nodeType);
    }

    private Language findLanguage(Language baseLanguage) {
        FileViewProvider viewProvider = this.getViewProvider();
        Set languages = viewProvider.getLanguages();
        for (Language actualLanguage : languages) {
            if (!actualLanguage.isKindOf(baseLanguage)) continue;
            return actualLanguage;
        }
        throw new AssertionError((Object)("Language " + baseLanguage + " doesn't participate in view provider " + viewProvider + ": " + new ArrayList(languages)));
    }

    @Override
    @NotNull
    public final Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/PsiFileBase.getLanguage must not return null");
        }
        return language;
    }

    @Override
    protected final FileElement createFileElement(CharSequence docText) {
        return super.createFileElement(docText);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/extapi/psi/PsiFileBase.accept must not be null");
        }
        visitor.visitFile((PsiFile)this);
    }

    @NotNull
    public ParserDefinition getParserDefinition() {
        ParserDefinition parserDefinition = this.myParserDefinition;
        if (parserDefinition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/extapi/psi/PsiFileBase.getParserDefinition must not return null");
        }
        return parserDefinition;
    }
}

