/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class ColoredOutputTypeRegistry {
    private final Map<String, Key> myRegisteredKeys = new HashMap<String, Key>();
    private final TextAttributesKey[] myAnsiColorKeys = new TextAttributesKey[]{ConsoleHighlighter.OUT, ConsoleHighlighter.RED, ConsoleHighlighter.GREEN, ConsoleHighlighter.YELLOW, ConsoleHighlighter.BLUE, ConsoleHighlighter.MAGENTA, ConsoleHighlighter.CYAN};

    public static ColoredOutputTypeRegistry getInstance() {
        return (ColoredOutputTypeRegistry)ServiceManager.getService(ColoredOutputTypeRegistry.class);
    }

    public Key getOutputKey(@NonNls String attribute) {
        String[] strings;
        Key key = this.myRegisteredKeys.get(attribute);
        if (key != null) {
            return key;
        }
        String completeAttribute = attribute;
        if (attribute.startsWith("\u001b[")) {
            attribute = attribute.substring(2);
        } else if (attribute.startsWith("[")) {
            attribute = attribute.substring(1);
        }
        if (attribute.endsWith("m")) {
            attribute = attribute.substring(0, attribute.length() - 1);
        }
        if (attribute.equals("0")) {
            return ProcessOutputTypes.STDOUT;
        }
        TextAttributes attrs = new TextAttributes();
        for (String string : strings = attribute.split(";")) {
            int value;
            try {
                value = Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (value == 4) {
                attrs.setEffectType(EffectType.LINE_UNDERSCORE);
                continue;
            }
            if (value == 1) {
                attrs.setFontType(1);
                continue;
            }
            if (value >= 30 && value <= 36) {
                attrs.setForegroundColor(EditorColorsManager.getInstance().getGlobalScheme().getAttributes(this.myAnsiColorKeys[value - 30]).getForegroundColor());
                continue;
            }
            if (value == 37) {
                attrs.setForegroundColor(Color.WHITE);
                continue;
            }
            if (value == 90) {
                attrs.setForegroundColor(EditorColorsManager.getInstance().getGlobalScheme().getAttributes(ConsoleHighlighter.GRAY).getForegroundColor());
                continue;
            }
            if (value < 91 || value >= 96) continue;
            attrs.setForegroundColor(EditorColorsManager.getInstance().getGlobalScheme().getAttributes(this.myAnsiColorKeys[value - 90]).getForegroundColor());
        }
        if (attrs.getEffectType() == EffectType.LINE_UNDERSCORE) {
            attrs.setEffectColor(attrs.getForegroundColor());
        }
        Key newKey = new Key(completeAttribute);
        ConsoleViewContentType contentType = new ConsoleViewContentType(completeAttribute, attrs);
        ConsoleViewContentType.registerNewConsoleViewType((Key)newKey, (ConsoleViewContentType)contentType);
        this.myRegisteredKeys.put(completeAttribute, newKey);
        return newKey;
    }
}

