/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.junit2.SegmentedInputStream;
import java.io.IOException;
import java.io.Reader;

public class SegmentedInputStreamReader
extends Reader {
    private final SegmentedInputStream myStream;

    public SegmentedInputStreamReader(SegmentedInputStream stream) {
        this.myStream = stream;
    }

    @Override
    public void close() throws IOException {
        this.myStream.close();
    }

    @Override
    public boolean ready() throws IOException {
        return this.myStream.available() > 0;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int aChar = this.myStream.read();
            if (aChar == -1) {
                return i == 0 ? -1 : i;
            }
            cbuf[off + i] = (char)aChar;
        }
        return len;
    }
}

