/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.LogConsoleManager;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.SwingUtilities;

public class LogFilesManager
implements Disposable {
    private static final int UPDATE_INTERVAL = 500;
    private final Map<LogFileOptions, Set<String>> myLogFileManagerMap = new LinkedHashMap<LogFileOptions, Set<String>>();
    private final Map<LogFileOptions, RunConfigurationBase> myLogFileToConfiguration = new HashMap<LogFileOptions, RunConfigurationBase>();
    private final Runnable myUpdateRequest;
    private final LogConsoleManager myManager;
    private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.OWN_THREAD, (Disposable)this);
    private boolean myDisposed;

    public LogFilesManager(final Project project, LogConsoleManager manager, Disposable parentDisposable) {
        this.myManager = manager;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myUpdateRequest = new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed() || LogFilesManager.this.myDisposed) {
                    return;
                }
                LogFilesManager.this.myUpdateAlarm.cancelAllRequests();
                for (final LogFileOptions logFile : LogFilesManager.this.myLogFileManagerMap.keySet()) {
                    final Set oldFiles = (Set)LogFilesManager.this.myLogFileManagerMap.get(logFile);
                    Set newFiles = logFile.getPaths();
                    LogFilesManager.this.myLogFileManagerMap.put(logFile, newFiles);
                    THashSet obsoleteFiles = new THashSet((Collection)oldFiles);
                    obsoleteFiles.removeAll(newFiles);
                    SwingUtilities.invokeLater(new Runnable((Set)obsoleteFiles){
                        final /* synthetic */ Set val$obsoleteFiles;
                        {
                            this.val$obsoleteFiles = set2;
                        }

                        @Override
                        public void run() {
                            if (project.isDisposed() || LogFilesManager.this.myDisposed) {
                                return;
                            }
                            LogFilesManager.this.addConfigurationConsoles(logFile, (Condition<String>)((Condition)new Condition<String>(){

                                public boolean value(String file) {
                                    return !oldFiles.contains(file);
                                }
                            }));
                            for (String each : this.val$obsoleteFiles) {
                                LogFilesManager.this.myManager.removeLogConsole(each);
                            }
                            LogFilesManager.this.myUpdateAlarm.addRequest(LogFilesManager.this.myUpdateRequest, 500);
                        }
                    });
                }
            }
        };
    }

    public void registerFileMatcher(RunConfigurationBase runConfiguration) {
        ArrayList logFiles = runConfiguration.getAllLogFiles();
        for (LogFileOptions logFile : logFiles) {
            if (!logFile.isEnabled()) continue;
            this.myLogFileManagerMap.put(logFile, logFile.getPaths());
            this.myLogFileToConfiguration.put(logFile, runConfiguration);
        }
        Alarm updateAlarm = this.myUpdateAlarm;
        if (updateAlarm != null) {
            updateAlarm.addRequest(this.myUpdateRequest, 500);
        }
    }

    public void dispose() {
        this.myDisposed = true;
        if (this.myUpdateAlarm != null) {
            this.myUpdateAlarm.cancelAllRequests();
        }
    }

    public void initLogConsoles(RunConfigurationBase base, ProcessHandler startedProcess) {
        ArrayList logFiles = base.getAllLogFiles();
        for (LogFileOptions logFile : logFiles) {
            if (!logFile.isEnabled()) continue;
            this.addConfigurationConsoles(logFile, (Condition<String>)Condition.TRUE);
        }
        base.createAdditionalTabComponents((AdditionalTabComponentManager)this.myManager, startedProcess);
    }

    private void addConfigurationConsoles(LogFileOptions logFile, Condition<String> shouldInclude) {
        Set paths = logFile.getPaths();
        if (!paths.isEmpty()) {
            TreeMap<String, String> title2Path = new TreeMap<String, String>();
            if (paths.size() == 1) {
                String path = (String)paths.iterator().next();
                if (shouldInclude.value((Object)path)) {
                    title2Path.put(logFile.getName(), path);
                }
            } else {
                for (String path : paths) {
                    if (!shouldInclude.value((Object)path)) continue;
                    String title = new File(path).getName();
                    if (title2Path.containsKey(title)) {
                        title = path;
                    }
                    title2Path.put(title, path);
                }
            }
            for (String title : title2Path.keySet()) {
                String path = (String)title2Path.get(title);
                this.myManager.addLogConsole(title, path, logFile.isSkipContent() ? new File(path).length() : 0L);
            }
        }
    }
}

