/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.OutOfMemoryDialog;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.ErrorLogger;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;

public class DefaultIdeaErrorLogger
implements ErrorLogger {
    private static boolean ourOomOccured = false;
    @NonNls
    private static final String FATAL_ERROR_NOTIFICATION_PROPERTY = "idea.fatal.error.notification";
    @NonNls
    private static final String DISABLED_VALUE = "disabled";
    @NonNls
    private static final String ENABLED_VALUE = "enabled";
    @NonNls
    private static final String PARAM_PERMGEN = "PermGen";

    public boolean canHandle(IdeaLoggingEvent event) {
        boolean notificationEnabled = !DISABLED_VALUE.equals(System.getProperty(FATAL_ERROR_NOTIFICATION_PROPERTY, ENABLED_VALUE));
        return notificationEnabled || !(IdeErrorsDialog.getSubmitter(event.getThrowable()) instanceof ITNReporter) || ApplicationManagerEx.getApplicationEx().isInternal() || event.getThrowable() instanceof OutOfMemoryError;
    }

    public void handle(IdeaLoggingEvent event) {
        try {
            if (event.getThrowable() instanceof OutOfMemoryError) {
                this.processOOMError(event);
            } else if (!ourOomOccured) {
                MessagePool.getInstance().addIdeFatalMessage(event);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processOOMError(final IdeaLoggingEvent event) throws InterruptedException, InvocationTargetException {
        ourOomOccured = true;
        event.getThrowable().printStackTrace();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                String message = event.getThrowable().getMessage();
                OutOfMemoryDialog.MemoryKind k = message != null && message.indexOf(DefaultIdeaErrorLogger.PARAM_PERMGEN) >= 0 ? OutOfMemoryDialog.MemoryKind.PERM_GEN : OutOfMemoryDialog.MemoryKind.HEAP;
                new OutOfMemoryDialog(k).show();
            }
        });
    }
}

