/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;

public class ArgumentValueDescriptorImpl
extends ValueDescriptorImpl {
    private final int myIndex;
    private final Value myValue;
    private String myName;
    private boolean myParameterNameCalcutated;

    public ArgumentValueDescriptorImpl(Project project, int index, Value value) {
        super(project);
        this.myIndex = index;
        this.myValue = value;
        this.myName = "arg" + String.valueOf(index);
        this.setLvalue(true);
    }

    @Override
    public boolean isPrimitive() {
        return this.myValue instanceof PrimitiveValue;
    }

    @Override
    public Value calcValue(final EvaluationContextImpl evaluationContext) throws EvaluateException {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiMethod method;
                SourcePosition position = ContextUtil.getSourcePosition((StackFrameContext)evaluationContext);
                if (position != null && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)position.getElementAt(), PsiMethod.class)) != null) {
                    PsiParameterList params = method.getParameterList();
                    if (ArgumentValueDescriptorImpl.this.myIndex < params.getParametersCount()) {
                        PsiParameter param = params.getParameters()[ArgumentValueDescriptorImpl.this.myIndex];
                        ArgumentValueDescriptorImpl.this.myName = param.getName();
                        ArgumentValueDescriptorImpl.this.myParameterNameCalcutated = true;
                    }
                }
            }
        });
        return this.myValue;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String calcValueName() {
        return this.getName();
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        if (!this.myParameterNameCalcutated) {
            return null;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        try {
            return elementFactory.createExpressionFromText(this.getName(), PositionUtil.getContextElement((StackFrameContext)context));
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.local.variable.name", (Object[])new Object[]{this.getName()}), (Throwable)e);
        }
    }
}

