/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.StringBuilderSpinAllocator;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public class HotSwapProgressImpl
extends HotSwapProgress {
    TIntObjectHashMap<List<String>> myMessages = new TIntObjectHashMap();
    private final ProgressIndicator myProgressIndicator;
    private final ProgressWindow myProgressWindow;
    private String myTitle = DebuggerBundle.message((String)"progress.hot.swap.title", (Object[])new Object[0]);

    public HotSwapProgressImpl(Project project) {
        super(project);
        this.myProgressWindow = new BackgroundableProcessIndicator(this.getProject(), this.myTitle, new PerformInBackgroundOption(){

            public boolean shouldStartInBackground() {
                return DebuggerSettings.getInstance().HOTSWAP_IN_BACKGROUND;
            }

            public void processSentToBackground() {
            }
        }, null, null, true){

            @Override
            public void cancel() {
                HotSwapProgressImpl.this.cancel();
                super.cancel();
            }
        };
        this.myProgressIndicator = this.myProgressWindow;
    }

    @Override
    public void finished() {
        super.finished();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List errors = HotSwapProgressImpl.this.getMessages(4);
                List warnings = HotSwapProgressImpl.this.getMessages(5);
                if (errors.size() > 0) {
                    ToolWindowManager.getInstance((Project)HotSwapProgressImpl.this.getProject()).notifyByBalloon(ToolWindowId.DEBUG, MessageType.ERROR, HotSwapProgressImpl.buildMessage(errors), null, null);
                    WindowManager.getInstance().getStatusBar(HotSwapProgressImpl.this.getProject()).setInfo(DebuggerBundle.message((String)"status.hot.swap.completed.with.errors", (Object[])new Object[0]));
                } else if (warnings.size() > 0) {
                    ToolWindowManager.getInstance((Project)HotSwapProgressImpl.this.getProject()).notifyByBalloon(ToolWindowId.DEBUG, MessageType.WARNING, HotSwapProgressImpl.buildMessage(warnings), Messages.getWarningIcon(), null);
                    WindowManager.getInstance().getStatusBar(HotSwapProgressImpl.this.getProject()).setInfo(DebuggerBundle.message((String)"status.hot.swap.completed.with.warnings", (Object[])new Object[0]));
                } else if (HotSwapProgressImpl.this.myMessages.size() > 0) {
                    StringBuilder msg = StringBuilderSpinAllocator.alloc();
                    try {
                        for (int category : HotSwapProgressImpl.this.myMessages.keys()) {
                            if (msg.length() > 0) {
                                msg.append(" \n");
                            }
                            List categoryMessages = HotSwapProgressImpl.this.getMessages(category);
                            Iterator it = categoryMessages.iterator();
                            while (it.hasNext()) {
                                msg.append((String)it.next());
                                if (!it.hasNext()) continue;
                                msg.append(" \n");
                            }
                        }
                        String message = msg.toString();
                        ToolWindowManager.getInstance((Project)HotSwapProgressImpl.this.getProject()).notifyByBalloon(ToolWindowId.DEBUG, MessageType.INFO, message, null, null);
                        WindowManager.getInstance().getStatusBar(HotSwapProgressImpl.this.getProject()).setInfo(message);
                    }
                    finally {
                        StringBuilderSpinAllocator.dispose((StringBuilder)msg);
                    }
                }
            }
        });
    }

    private List<String> getMessages(int category) {
        List messages = (List)this.myMessages.get(category);
        return messages == null ? Collections.emptyList() : messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String buildMessage(List<String> messages) {
        StringBuilder msg = StringBuilderSpinAllocator.alloc();
        try {
            Iterator<String> it = messages.iterator();
            while (it.hasNext()) {
                msg.append(it.next());
                if (!it.hasNext()) continue;
                msg.append(" \n");
            }
            String string = msg.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(DebuggerSession session, int type, String text) {
        ArrayList<String> messages = (ArrayList<String>)this.myMessages.get(type);
        if (messages == null) {
            messages = new ArrayList<String>();
            this.myMessages.put(type, messages);
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append(session.getSessionName()).append(": ").append(text).append(";");
            messages.add(builder.toString());
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @Override
    public void setText(final String text) {
        DebuggerInvocationUtil.invokeLater(this.getProject(), new Runnable(){

            @Override
            public void run() {
                HotSwapProgressImpl.this.myProgressIndicator.setText(text);
            }
        }, this.myProgressIndicator.getModalityState());
    }

    @Override
    public void setTitle(final String text) {
        DebuggerInvocationUtil.invokeLater(this.getProject(), new Runnable(){

            @Override
            public void run() {
                HotSwapProgressImpl.this.myProgressWindow.setTitle(text);
            }
        }, this.myProgressWindow.getModalityState());
    }

    @Override
    public void setFraction(final double v) {
        DebuggerInvocationUtil.invokeLater(this.getProject(), new Runnable(){

            @Override
            public void run() {
                HotSwapProgressImpl.this.myProgressIndicator.setFraction(v);
            }
        }, this.myProgressIndicator.getModalityState());
    }

    @Override
    public boolean isCancelled() {
        return this.myProgressIndicator.isCanceled();
    }

    public ProgressIndicator getProgressIndicator() {
        return this.myProgressIndicator;
    }

    @Override
    public void setDebuggerSession(DebuggerSession session) {
        this.myTitle = DebuggerBundle.message((String)"progress.hot.swap.title", (Object[])new Object[0]) + " : " + session.getSessionName();
        this.myProgressWindow.setTitle(this.myTitle);
    }
}

