/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.settings.CompoundRendererConfigurable;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.RendererConfiguration;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.containers.InternalIterator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UserRenderersConfigurable
implements SearchableConfigurable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.settings.UserRenderersConfigurable");
    private static final Icon ADD_ICON = IconLoader.getIcon((String)"/general/add.png");
    private static final Icon REMOVE_ICON = IconLoader.getIcon((String)"/general/remove.png");
    private static final Icon COPY_ICON = IconLoader.getIcon((String)"/general/copy.png");
    private static final Icon UP_ICON = IconLoader.getIcon((String)"/actions/previousOccurence.png");
    private static final Icon DOWN_ICON = IconLoader.getIcon((String)"/actions/nextOccurence.png");
    private JTextField myNameField;
    private ElementsChooser<NodeRenderer> myRendererChooser;
    private NodeRenderer myCurrentRenderer = null;
    private final CompoundRendererConfigurable myRendererDataConfigurable;

    public UserRenderersConfigurable(Project project) {
        this.myRendererDataConfigurable = new CompoundRendererConfigurable(project);
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"user.renderers.configurable.display.name", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "reference.idesettings.debugger.typerenderers";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        JPanel panel = new JPanel(new BorderLayout(4, 0));
        JComponent renderersList = this.createRenderersList();
        JComponent toolbar = this.createToolbar();
        JComponent rendererDataPanel = this.myRendererDataConfigurable.createComponent();
        JPanel left = new JPanel(new BorderLayout());
        left.add((Component)toolbar, "North");
        left.add((Component)renderersList, "Center");
        this.myNameField = new JTextField();
        JPanel nameFieldPanel = new JPanel(new BorderLayout());
        nameFieldPanel.add((Component)new JLabel(DebuggerBundle.message((String)"label.user.renderers.configurable.renderer.name", (Object[])new Object[0])), "West");
        nameFieldPanel.add((Component)this.myNameField, "Center");
        JPanel center = new JPanel(new BorderLayout(0, 4));
        center.add((Component)nameFieldPanel, "North");
        center.add((Component)rendererDataPanel, "Center");
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (UserRenderersConfigurable.this.myCurrentRenderer != null) {
                    UserRenderersConfigurable.this.myCurrentRenderer.setName(UserRenderersConfigurable.this.myNameField.getText());
                    UserRenderersConfigurable.this.myRendererChooser.refresh(UserRenderersConfigurable.this.myCurrentRenderer);
                }
            }
        });
        panel.add((Component)left, "West");
        panel.add((Component)center, "Center");
        return panel;
    }

    private JComponent createRenderersList() {
        this.myRendererChooser = new ElementsChooser(true);
        this.myRendererChooser.addElementsMarkListener(new ElementsChooser.ElementsMarkListener<NodeRenderer>(){

            @Override
            public void elementMarkChanged(NodeRenderer element, boolean isMarked) {
                element.setEnabled(isMarked);
            }
        });
        this.myRendererChooser.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                List selectedElements = UserRenderersConfigurable.this.myRendererChooser.getSelectedElements();
                if (selectedElements.size() != 1) {
                    UserRenderersConfigurable.this.setCurrentRenderer(null);
                } else {
                    UserRenderersConfigurable.this.setCurrentRenderer((NodeRenderer)selectedElements.get(0));
                }
            }
        });
        return this.myRendererChooser;
    }

    private void setCurrentRenderer(NodeRenderer renderer) {
        if (this.myCurrentRenderer == renderer) {
            return;
        }
        try {
            if (this.myRendererDataConfigurable.isModified()) {
                this.myRendererDataConfigurable.apply();
            }
        }
        catch (ConfigurationException e) {
            LOG.error((Throwable)e);
        }
        this.myCurrentRenderer = renderer;
        if (renderer != null) {
            this.myNameField.setEnabled(true);
            this.myNameField.setText(renderer.getName());
        } else {
            this.myNameField.setEnabled(false);
            this.myNameField.setText("");
        }
        this.myRendererDataConfigurable.setRenderer(renderer);
    }

    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new AddAction());
        group.add((AnAction)new RemoveAction());
        group.add((AnAction)new CopyAction());
        group.add((AnAction)new MoveAction(true));
        group.add((AnAction)new MoveAction(false));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        return toolbar.getComponent();
    }

    public void apply() throws ConfigurationException {
        this.myRendererDataConfigurable.apply();
        this.flushTo(NodeRendererSettings.getInstance().getCustomRenderers());
    }

    private void flushTo(RendererConfiguration rendererConfiguration) {
        rendererConfiguration.removeAllRenderers();
        int count = this.myRendererChooser.getElementCount();
        for (int idx = 0; idx < count; ++idx) {
            rendererConfiguration.addRenderer(this.myRendererChooser.getElementAt(idx));
        }
    }

    public boolean isModified() {
        if (this.myRendererDataConfigurable.isModified()) {
            return true;
        }
        NodeRendererSettings settings = NodeRendererSettings.getInstance();
        RendererConfiguration rendererConfiguration = settings.getCustomRenderers();
        if (this.myRendererChooser.getElementCount() != rendererConfiguration.getRendererCount()) {
            return true;
        }
        RendererConfiguration uiConfiguration = new RendererConfiguration(settings);
        this.flushTo(uiConfiguration);
        return !uiConfiguration.equals(rendererConfiguration);
    }

    public void reset() {
        this.myRendererChooser.removeAllElements();
        RendererConfiguration rendererConfiguration = NodeRendererSettings.getInstance().getCustomRenderers();
        final ArrayList elementsToSelect = new ArrayList(1);
        rendererConfiguration.iterateRenderers(new InternalIterator<NodeRenderer>(){

            public boolean visit(NodeRenderer renderer) {
                NodeRenderer clonedRenderer = (NodeRenderer)renderer.clone();
                UserRenderersConfigurable.this.myRendererChooser.addElement(clonedRenderer, clonedRenderer.isEnabled());
                if (elementsToSelect.size() == 0) {
                    elementsToSelect.add(clonedRenderer);
                }
                return true;
            }
        });
        if (elementsToSelect.size() > 0) {
            this.myRendererChooser.selectElements(elementsToSelect);
        }
        this.myRendererDataConfigurable.reset();
    }

    public void disposeUIResources() {
        this.myRendererChooser.removeAllElements();
        this.myRendererDataConfigurable.disposeUIResources();
    }

    private class MoveAction
    extends AnAction {
        private final boolean myMoveUp;

        public MoveAction(boolean up) {
            super(up ? DebuggerBundle.message((String)"button.move.up", (Object[])new Object[0]) : DebuggerBundle.message((String)"button.move.down", (Object[])new Object[0]), up ? DebuggerBundle.message((String)"user.renderers.configurable.button.description.move.up", (Object[])new Object[0]) : DebuggerBundle.message((String)"user.renderers.configurable.button.description.move.down", (Object[])new Object[0]), up ? UP_ICON : DOWN_ICON);
            this.myMoveUp = up;
        }

        public void actionPerformed(AnActionEvent e) {
            int selectedRow = UserRenderersConfigurable.this.myRendererChooser.getSelectedElementRow();
            if (selectedRow < 0) {
                return;
            }
            int newRow = selectedRow + (this.myMoveUp ? -1 : 1);
            if (newRow < 0) {
                newRow = UserRenderersConfigurable.this.myRendererChooser.getElementCount() - 1;
            } else if (newRow >= UserRenderersConfigurable.this.myRendererChooser.getElementCount()) {
                newRow = 0;
            }
            UserRenderersConfigurable.this.myRendererChooser.moveElement(UserRenderersConfigurable.this.myRendererChooser.getElementAt(selectedRow), newRow);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(UserRenderersConfigurable.this.myRendererChooser.getSelectedElement() != null);
        }
    }

    private class CopyAction
    extends AnAction {
        public CopyAction() {
            super(DebuggerBundle.message((String)"button.copy", (Object[])new Object[0]), DebuggerBundle.message((String)"user.renderers.configurable.button.description.copy", (Object[])new Object[0]), COPY_ICON);
        }

        public void actionPerformed(AnActionEvent e) {
            NodeRenderer selectedElement = (NodeRenderer)UserRenderersConfigurable.this.myRendererChooser.getSelectedElement();
            if (selectedElement != null) {
                NodeRenderer cloned = (NodeRenderer)selectedElement.clone();
                UserRenderersConfigurable.this.myRendererChooser.addElement(cloned, true);
            }
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(UserRenderersConfigurable.this.myRendererChooser.getSelectedElement() != null);
        }
    }

    private class RemoveAction
    extends AnAction {
        public RemoveAction() {
            super(DebuggerBundle.message((String)"button.remove", (Object[])new Object[0]), DebuggerBundle.message((String)"user.renderers.configurable.button.description.remove", (Object[])new Object[0]), REMOVE_ICON);
        }

        public void actionPerformed(AnActionEvent e) {
            for (NodeRenderer selectedElement : UserRenderersConfigurable.this.myRendererChooser.getSelectedElements()) {
                UserRenderersConfigurable.this.myRendererChooser.removeElement(selectedElement);
            }
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(UserRenderersConfigurable.this.myRendererChooser.getSelectedElement() != null);
        }
    }

    private class AddAction
    extends AnAction {
        public AddAction() {
            super(DebuggerBundle.message((String)"button.add", (Object[])new Object[0]), DebuggerBundle.message((String)"user.renderers.configurable.button.description.add", (Object[])new Object[0]), ADD_ICON);
        }

        public void actionPerformed(AnActionEvent e) {
            NodeRenderer renderer = (NodeRenderer)NodeRendererSettings.getInstance().createRenderer("CompoundNodeRenderer");
            renderer.setEnabled(true);
            UserRenderersConfigurable.this.myRendererChooser.addElement(renderer, renderer.isEnabled());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UserRenderersConfigurable.this.myNameField.requestFocus();
                }
            });
        }
    }
}

