/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.impl.EventQueueClosedException;
import com.intellij.openapi.diagnostic.Logger;
import java.util.LinkedList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class EventQueue<E> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.EventQueue");
    private final LinkedList[] myEvents;
    private final ReentrantLock myLock = new ReentrantLock();
    private final Condition myEventsAvailable = this.myLock.newCondition();
    private volatile E myCurrentEvent;
    private volatile boolean myIsClosed = false;

    public EventQueue(int countPriorities) {
        this.myEvents = new LinkedList[countPriorities];
        for (int i = 0; i < this.myEvents.length; ++i) {
            this.myEvents[i] = new LinkedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushBack(@NotNull E event, int priority) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/impl/EventQueue.pushBack must not be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("pushBack event " + event);
        }
        this.myLock.lock();
        try {
            this.getEventsList(priority).addFirst(event);
            this.myEventsAvailable.signalAll();
        }
        finally {
            this.myLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(@NotNull E event, int priority) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/impl/EventQueue.put must not be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("put event " + event);
        }
        this.myLock.lock();
        try {
            this.getEventsList(priority).offer(event);
            this.myEventsAvailable.signalAll();
        }
        finally {
            this.myLock.unlock();
        }
    }

    private LinkedList<E> getEventsList(int priority) {
        return this.myEvents[priority];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.myLock.lock();
        try {
            this.myIsClosed = true;
            this.myEventsAvailable.signalAll();
        }
        finally {
            this.myLock.unlock();
        }
    }

    private E getEvent() throws EventQueueClosedException {
        this.myLock.lock();
        try {
            while (true) {
                if (this.myIsClosed) {
                    throw new EventQueueClosedException();
                }
                for (int i = 0; i < this.myEvents.length; ++i) {
                    E event = this.getEventsList(i).poll();
                    if (event == null) continue;
                    E e = event;
                    return e;
                }
                this.myEventsAvailable.awaitUninterruptibly();
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    public E get() throws EventQueueClosedException {
        this.myCurrentEvent = this.getEvent();
        return this.myCurrentEvent;
    }

    public boolean isClosed() {
        return this.myIsClosed;
    }

    public E getCurrentEvent() {
        return this.myCurrentEvent;
    }
}

