/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.CompletionEditor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.classFilter.ClassFilter;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public abstract class DebuggerUtilsEx
extends DebuggerUtils {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerUtilsEx");
    private static final int MAX_LABEL_SIZE = 255;
    private static Set<String> myCharOrIntegers;

    public static List<CodeFragmentFactory> getCodeFragmentFactories(PsiElement context) {
        DefaultCodeFragmentFactory defaultFactry = DefaultCodeFragmentFactory.getInstance();
        CodeFragmentFactory[] providers = (CodeFragmentFactory[])ApplicationManager.getApplication().getExtensions(CodeFragmentFactory.EXTENSION_POINT_NAME);
        ArrayList<CodeFragmentFactory> suitableFactories = new ArrayList<CodeFragmentFactory>(providers.length);
        if (providers.length > 0) {
            for (CodeFragmentFactory factory : providers) {
                if (factory == defaultFactry || !factory.isContextAccepted(context)) continue;
                suitableFactories.add(factory);
            }
        }
        suitableFactories.add(defaultFactry);
        return suitableFactories;
    }

    public static PsiMethod findPsiMethod(PsiFile file, int offset) {
        PsiElement element = null;
        while (offset >= 0 && (element = file.findElementAt(offset)) == null) {
            --offset;
        }
        while (element != null) {
            if (element instanceof PsiClass) {
                return null;
            }
            if (element instanceof PsiMethod) {
                return (PsiMethod)element;
            }
            element = element.getParent();
        }
        return null;
    }

    public static boolean isAssignableFrom(String baseQualifiedName, ReferenceType checkedType) {
        return DebuggerUtilsEx.getSuperClass(baseQualifiedName, checkedType) != null;
    }

    public static ReferenceType getSuperClass(String baseQualifiedName, ReferenceType checkedType) {
        if (baseQualifiedName.equals(checkedType.name())) {
            return checkedType;
        }
        if (checkedType instanceof ClassType) {
            ReferenceType superClass;
            ClassType classType = (ClassType)checkedType;
            ClassType superClassType = classType.superclass();
            if (superClassType != null && (superClass = DebuggerUtilsEx.getSuperClass(baseQualifiedName, superClassType)) != null) {
                return superClass;
            }
            List<InterfaceType> ifaces = classType.allInterfaces();
            for (InterfaceType iface : ifaces) {
                ReferenceType superClass2 = DebuggerUtilsEx.getSuperClass(baseQualifiedName, iface);
                if (superClass2 == null) continue;
                return superClass2;
            }
        }
        if (checkedType instanceof InterfaceType) {
            List<InterfaceType> list = ((InterfaceType)checkedType).superinterfaces();
            for (InterfaceType superInterface : list) {
                ReferenceType superClass = DebuggerUtilsEx.getSuperClass(baseQualifiedName, superInterface);
                if (superClass == null) continue;
                return superClass;
            }
        }
        return null;
    }

    public static boolean valuesEqual(Value val1, Value val2) {
        if (val1 == null) {
            return val2 == null;
        }
        if (val2 == null) {
            return false;
        }
        if (val1 instanceof StringReference && val2 instanceof StringReference) {
            return ((StringReference)val1).value().equals(((StringReference)val2).value());
        }
        return val1.equals(val2);
    }

    public static String getValueOrErrorAsString(EvaluationContext evaluationContext, Value value) {
        try {
            return DebuggerUtilsEx.getValueAsString((EvaluationContext)evaluationContext, (Value)value);
        }
        catch (EvaluateException e) {
            return e.getMessage();
        }
    }

    public static boolean isCharOrInteger(Value value) {
        return value instanceof CharValue || DebuggerUtilsEx.isInteger((Value)value);
    }

    public static boolean isCharOrIntegerArray(Value value) {
        if (value == null) {
            return false;
        }
        if (myCharOrIntegers == null) {
            myCharOrIntegers = new HashSet<String>();
            myCharOrIntegers.add("C");
            myCharOrIntegers.add("B");
            myCharOrIntegers.add("S");
            myCharOrIntegers.add("I");
            myCharOrIntegers.add("J");
        }
        String signature = value.type().signature();
        int i = 0;
        while (signature.charAt(i) == '[') {
            ++i;
        }
        if (i == 0) {
            return false;
        }
        signature = signature.substring(i, signature.length());
        return myCharOrIntegers.contains(signature);
    }

    public static ClassFilter create(Element element) throws InvalidDataException {
        ClassFilter filter = new ClassFilter();
        filter.readExternal(element);
        return filter;
    }

    private static boolean isFiltered(ClassFilter classFilter, String qName) {
        if (!classFilter.isEnabled()) {
            return false;
        }
        try {
            if (classFilter.matches(qName)) {
                return true;
            }
        }
        catch (PatternSyntaxException e) {
            LOG.debug((Throwable)e);
        }
        return false;
    }

    public static boolean isFiltered(String qName, ClassFilter[] classFilters) {
        return DebuggerUtilsEx.isFiltered(qName, Arrays.asList(classFilters));
    }

    public static boolean isFiltered(String qName, List<ClassFilter> classFilters) {
        if (qName.indexOf(91) != -1) {
            return false;
        }
        for (ClassFilter filter : classFilters) {
            if (!DebuggerUtilsEx.isFiltered(filter, qName)) continue;
            return true;
        }
        return false;
    }

    public static ClassFilter[] readFilters(List children) throws InvalidDataException {
        if (children == null || children.size() == 0) {
            return ClassFilter.EMPTY_ARRAY;
        }
        ArrayList<ClassFilter> classFiltersList = new ArrayList<ClassFilter>(children.size());
        Iterator i = children.iterator();
        while (i.hasNext()) {
            ClassFilter classFilter = new ClassFilter();
            classFilter.readExternal((Element)i.next());
            classFiltersList.add(classFilter);
        }
        return classFiltersList.toArray(new ClassFilter[classFiltersList.size()]);
    }

    public static void writeFilters(Element parentNode, @NonNls String tagName, ClassFilter[] filters) throws WriteExternalException {
        for (ClassFilter filter : filters) {
            Element element = new Element(tagName);
            parentNode.addContent(element);
            filter.writeExternal(element);
        }
    }

    public static boolean filterEquals(ClassFilter[] filters1, ClassFilter[] filters2) {
        if (filters1.length != filters2.length) {
            return false;
        }
        HashSet<ClassFilter> f1 = new HashSet<ClassFilter>(Math.max((int)((float)filters1.length / 0.75f) + 1, 16));
        HashSet<ClassFilter> f2 = new HashSet<ClassFilter>(Math.max((int)((float)filters2.length / 0.75f) + 1, 16));
        for (ClassFilter filter : filters1) {
            f1.add(filter);
        }
        for (ClassFilter aFilters2 : filters2) {
            f2.add(aFilters2);
        }
        return ((Object)f2).equals(f1);
    }

    private static boolean elementListsEqual(List<Element> l1, List<Element> l2) {
        if (l1 == null) {
            return l2 == null;
        }
        if (l2 == null) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator<Element> i1 = l1.iterator();
        Iterator<Element> i2 = l2.iterator();
        while (i2.hasNext()) {
            Element elem2;
            Element elem1 = i1.next();
            if (DebuggerUtilsEx.elementsEqual(elem1, elem2 = i2.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean attributeListsEqual(List<Attribute> l1, List<Attribute> l2) {
        if (l1 == null) {
            return l2 == null;
        }
        if (l2 == null) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator<Attribute> i1 = l1.iterator();
        Iterator<Attribute> i2 = l2.iterator();
        while (i2.hasNext()) {
            Attribute attr1 = i1.next();
            Attribute attr2 = i2.next();
            if (Comparing.equal((String)attr1.getName(), (String)attr2.getName()) && Comparing.equal((String)attr1.getValue(), (String)attr2.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean elementsEqual(Element e1, Element e2) {
        if (e1 == null) {
            return e2 == null;
        }
        return Comparing.equal((String)e1.getName(), (String)e2.getName()) && DebuggerUtilsEx.elementListsEqual(e1.getChildren(), e2.getChildren()) && DebuggerUtilsEx.attributeListsEqual(e1.getAttributes(), e2.getAttributes());
    }

    public static boolean externalizableEqual(JDOMExternalizable e1, JDOMExternalizable e2) {
        Element root1 = new Element("root");
        Element root2 = new Element("root");
        try {
            e1.writeExternal(root1);
        }
        catch (WriteExternalException e) {
            LOG.debug((Throwable)e);
        }
        try {
            e2.writeExternal(root2);
        }
        catch (WriteExternalException e) {
            LOG.debug((Throwable)e);
        }
        return DebuggerUtilsEx.elementsEqual(root1, root2);
    }

    public static List<Pair<Breakpoint, Event>> getEventDescriptors(SuspendContextImpl suspendContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (suspendContext == null || suspendContext.getEventSet() == null) {
            return Collections.emptyList();
        }
        ArrayList<Pair<Breakpoint, Event>> eventDescriptors = new ArrayList<Pair<Breakpoint, Event>>();
        RequestManagerImpl requestManager = suspendContext.getDebugProcess().getRequestsManager();
        for (Event event : suspendContext.getEventSet()) {
            Requestor requestor = requestManager.findRequestor(event.request());
            if (!(requestor instanceof Breakpoint)) continue;
            eventDescriptors.add((Pair<Breakpoint, Event>)new Pair((Object)((Breakpoint)requestor), (Object)event));
        }
        return eventDescriptors;
    }

    private static PsiElement findExpression(PsiElement element) {
        if (!(element instanceof PsiIdentifier) && !(element instanceof PsiKeyword)) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiVariable) {
            return element;
        }
        if (parent instanceof PsiReferenceExpression) {
            if (parent.getParent() instanceof PsiCallExpression) {
                return parent.getParent();
            }
            return parent;
        }
        if (parent instanceof PsiThisExpression) {
            return parent;
        }
        return null;
    }

    public static TextWithImports getEditorText(Editor editor) {
        if (editor == null) {
            return null;
        }
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        String defaultExpression = editor.getSelectionModel().getSelectedText();
        if (defaultExpression == null) {
            PsiElement element;
            PsiElement elementAtCursor;
            int offset = editor.getCaretModel().getOffset();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (psiFile != null && (elementAtCursor = psiFile.findElementAt(offset)) != null && (element = DebuggerUtilsEx.findExpression(elementAtCursor)) != null) {
                PsiEnumConstant enumConstant;
                PsiClass enumClass;
                PsiElement resolved;
                PsiReferenceExpression reference;
                if (element instanceof PsiReferenceExpression && (reference = (PsiReferenceExpression)element).getQualifier() == null && (resolved = reference.resolve()) instanceof PsiEnumConstant && (enumClass = (enumConstant = (PsiEnumConstant)resolved).getContainingClass()) != null) {
                    defaultExpression = enumClass.getName() + "." + enumConstant.getName();
                }
                if (defaultExpression == null) {
                    defaultExpression = element.getText();
                }
            }
        }
        if (defaultExpression != null) {
            return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, defaultExpression);
        }
        return null;
    }

    public abstract DebuggerTreeNode getSelectedNode(DataContext var1);

    public abstract EvaluatorBuilder getEvaluatorBuilder();

    public abstract CompletionEditor createEditor(Project var1, PsiElement var2, @NonNls String var3);

    public static String methodName(Method m) {
        return DebuggerUtilsEx.methodName(DebuggerUtilsEx.signatureToName(m.declaringType().signature()), m.name(), m.signature());
    }

    public static String methodName(final String className, final String methodName, String signature) {
        try {
            return new SigReader(signature){

                @Override
                String getMethodName() {
                    return methodName;
                }

                @Override
                String getClassName() {
                    return className;
                }
            }.getSignature();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Internal error : unknown signature" + signature);
            }
            return className + "." + methodName;
        }
    }

    public static String signatureToName(String s) {
        return new SigReader(s).getSignature();
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, double value) {
        if (PsiType.DOUBLE.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        if (PsiType.FLOAT.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((float)value);
        }
        return DebuggerUtilsEx.createValue(vm, expectedType, (long)value);
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, long value) {
        if (PsiType.LONG.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        if (PsiType.INT.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((int)value);
        }
        if (PsiType.SHORT.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((short)value);
        }
        if (PsiType.BYTE.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((byte)value);
        }
        if (PsiType.CHAR.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((char)value);
        }
        if (PsiType.DOUBLE.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((double)value);
        }
        if (PsiType.FLOAT.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((float)value);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, boolean value) {
        if (PsiType.BOOLEAN.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, char value) {
        if (PsiType.CHAR.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        if (PsiType.LONG.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((long)value);
        }
        if (PsiType.INT.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((int)value);
        }
        if (PsiType.SHORT.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((short)value);
        }
        if (PsiType.BYTE.getPresentableText().equals(expectedType)) {
            return vm.mirrorOf((byte)value);
        }
        return null;
    }

    public static String truncateString(String str) {
        if (str.length() > 255) {
            return str.substring(0, 255) + "...";
        }
        return str;
    }

    public static String getThreadStatusText(int statusId) {
        switch (statusId) {
            case 3: {
                return DebuggerBundle.message((String)"status.thread.monitor", (Object[])new Object[0]);
            }
            case 5: {
                return DebuggerBundle.message((String)"status.thread.not.started", (Object[])new Object[0]);
            }
            case 1: {
                return DebuggerBundle.message((String)"status.thread.running", (Object[])new Object[0]);
            }
            case 2: {
                return DebuggerBundle.message((String)"status.thread.sleeping", (Object[])new Object[0]);
            }
            case -1: {
                return DebuggerBundle.message((String)"status.thread.unknown", (Object[])new Object[0]);
            }
            case 4: {
                return DebuggerBundle.message((String)"status.thread.wait", (Object[])new Object[0]);
            }
            case 0: {
                return DebuggerBundle.message((String)"status.thread.zombie", (Object[])new Object[0]);
            }
        }
        return DebuggerBundle.message((String)"status.thread.undefined", (Object[])new Object[0]);
    }

    public static void findAllSupertypes(Type type, Collection<ReferenceType> typeNames) {
        if (type instanceof ClassType) {
            ClassType classType = (ClassType)type;
            ClassType superclassType = classType.superclass();
            if (superclassType != null) {
                typeNames.add(superclassType);
                DebuggerUtilsEx.findAllSupertypes(superclassType, typeNames);
            }
            List<InterfaceType> ifaces = classType.allInterfaces();
            for (InterfaceType iface : ifaces) {
                typeNames.add(iface);
                DebuggerUtilsEx.findAllSupertypes(iface, typeNames);
            }
        }
        if (type instanceof InterfaceType) {
            List<InterfaceType> ifaces = ((InterfaceType)type).superinterfaces();
            for (InterfaceType iface : ifaces) {
                typeNames.add(iface);
                DebuggerUtilsEx.findAllSupertypes(iface, typeNames);
            }
        }
    }

    public static String getQualifiedClassName(final String jdiName, final Project project) {
        String name = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                int separator;
                String name = jdiName;
                int startFrom = 0;
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                while ((separator = name.indexOf(36, startFrom)) >= 0) {
                    String qualifiedName = name.substring(0, separator);
                    PsiClass psiClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(qualifiedName, GlobalSearchScope.allScope((Project)project));
                    if (psiClass != null) {
                        int tail;
                        for (tail = separator + 1; tail < name.length() && Character.isDigit(name.charAt(tail)); ++tail) {
                        }
                        name = qualifiedName + "." + name.substring(tail);
                    }
                    startFrom = separator + 1;
                }
                return name;
            }
        });
        if (jdiName.equals(name)) {
            return jdiName.replace('$', '.');
        }
        return name;
    }

    private static class SigReader {
        final String buffer;
        int pos = 0;

        SigReader(String s) {
            this.buffer = s;
        }

        int get() {
            return this.buffer.charAt(this.pos++);
        }

        int peek() {
            return this.buffer.charAt(this.pos);
        }

        boolean eof() {
            return this.buffer.length() <= this.pos;
        }

        @NonNls
        String getSignature() {
            if (this.eof()) {
                return "";
            }
            switch (this.get()) {
                case 90: {
                    return "boolean";
                }
                case 66: {
                    return "byte";
                }
                case 67: {
                    return "char";
                }
                case 83: {
                    return "short";
                }
                case 73: {
                    return "int";
                }
                case 74: {
                    return "long";
                }
                case 70: {
                    return "float";
                }
                case 68: {
                    return "double";
                }
                case 86: {
                    return "void";
                }
                case 76: {
                    int start = this.pos;
                    this.pos = this.buffer.indexOf(59, start) + 1;
                    LOG.assertTrue(this.pos > 0);
                    return this.buffer.substring(start, this.pos - 1).replace('/', '.');
                }
                case 91: {
                    return this.getSignature() + "[]";
                }
                case 40: {
                    StringBuffer result = new StringBuffer("(");
                    String separator = "";
                    while (this.peek() != 41) {
                        result.append(separator);
                        result.append(this.getSignature());
                        separator = ", ";
                    }
                    this.get();
                    result.append(")");
                    return this.getSignature() + " " + this.getClassName() + "." + this.getMethodName() + " " + result;
                }
            }
            return null;
        }

        String getMethodName() {
            return "";
        }

        String getClassName() {
            return "";
        }
    }
}

