/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ThisEvaluator
implements Evaluator {
    private final int myIterations;

    public ThisEvaluator() {
        this.myIterations = 0;
    }

    public ThisEvaluator(int iterations) {
        this.myIterations = iterations;
    }

    @Override
    public Modifier getModifier() {
        return null;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Value objRef = context.getThisObject();
        if (this.myIterations > 0) {
            ObjectReference thisRef = (ObjectReference)objRef;
            for (int idx = 0; idx < this.myIterations && thisRef != null; ++idx) {
                thisRef = ThisEvaluator.getOuterObject(thisRef);
            }
            objRef = thisRef;
        }
        if (objRef == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.this.not.avalilable", (Object[])new Object[0]));
        }
        return objRef;
    }

    @Nullable
    private static ObjectReference getOuterObject(ObjectReference objRef) {
        if (objRef == null) {
            return null;
        }
        List<Field> list = objRef.referenceType().fields();
        for (Field field : list) {
            ObjectReference rv;
            String name = field.name();
            if (name == null || !name.startsWith("this$") || (rv = (ObjectReference)objRef.getValue(field)) == null) continue;
            return rv;
        }
        return null;
    }
}

