/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import com.sun.jdi.Location;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ContextUtil {
    public static final Key<Boolean> IS_JSP_IMPLICIT = new Key("JspImplicit");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.PositionUtil");

    @Nullable
    public static SourcePosition getSourcePosition(StackFrameContext context) {
        DebugProcessImpl debugProcess = (DebugProcessImpl)context.getDebugProcess();
        if (debugProcess == null) {
            return null;
        }
        StackFrameProxy frameProxy = context.getFrameProxy();
        if (frameProxy == null) {
            return null;
        }
        Location location = null;
        try {
            location = frameProxy.location();
        }
        catch (Throwable th) {
            LOG.debug(th);
        }
        CompoundPositionManager positionManager = debugProcess.getPositionManager();
        if (positionManager == null) {
            return null;
        }
        try {
            return positionManager.getSourcePosition(location);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    @Nullable
    public static PsiElement getContextElement(StackFrameContext context) {
        return ContextUtil.getContextElement(context, ContextUtil.getSourcePosition(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected static PsiElement getContextElement(StackFrameContext context, SourcePosition position) {
        PsiElement psiElement;
        PsiElement element;
        if (LOG.isDebugEnabled()) {
            SourcePosition sourcePosition = ContextUtil.getSourcePosition(context);
            LOG.assertTrue(Comparing.equal((Object)sourcePosition, (Object)position));
        }
        if ((element = ContextUtil.getContextElement(position)) == null) {
            return null;
        }
        StackFrameProxyImpl frameProxy = (StackFrameProxyImpl)context.getFrameProxy();
        if (frameProxy == null) {
            return element;
        }
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        try {
            PsiStatement[] statements;
            List<LocalVariableProxyImpl> list = frameProxy.visibleVariables();
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)element.getProject()).getResolveHelper();
            buf.append('{');
            for (LocalVariableProxyImpl localVariable : list) {
                String varName = localVariable.name();
                if (resolveHelper.resolveReferencedVariable(varName, element) != null) continue;
                buf.append(localVariable.getVariable().typeName()).append(" ").append(varName).append(";");
            }
            buf.append('}');
            if (buf.length() <= 2) {
                PsiElement i$ = element;
                return i$;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory();
            PsiCodeBlock codeBlockFromText = elementFactory.createCodeBlockFromText(buf.toString(), element);
            for (PsiStatement statement : statements = codeBlockFromText.getStatements()) {
                PsiElement[] declaredElements;
                if (!(statement instanceof PsiDeclarationStatement)) continue;
                PsiDeclarationStatement declStatement = (PsiDeclarationStatement)statement;
                for (PsiElement declaredElement : declaredElements = declStatement.getDeclaredElements()) {
                    declaredElement.putUserData(IS_JSP_IMPLICIT, (Object)Boolean.TRUE);
                }
            }
            PsiCodeBlock psiCodeBlock = codeBlockFromText;
            return psiCodeBlock;
        }
        catch (IncorrectOperationException e) {
            psiElement = element;
            return psiElement;
        }
        catch (EvaluateException e) {
            psiElement = element;
            return psiElement;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
        }
    }

    @Nullable
    public static PsiElement getContextElement(SourcePosition position) {
        if (position == null) {
            return null;
        }
        return ContextUtil.getContextElementInText(position.getFile(), position.getLine());
    }

    @Nullable
    private static PsiElement getContextElementInText(PsiFile psiFile, int lineNumber) {
        PsiElement element;
        if (lineNumber < 0) {
            return psiFile;
        }
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        if (document == null) {
            return null;
        }
        if (lineNumber >= document.getLineCount()) {
            return psiFile;
        }
        int startOffset = document.getLineStartOffset(lineNumber);
        if (startOffset == -1) {
            return null;
        }
        PsiFile rootElement = JspPsiUtil.isInJspFile((PsiElement)psiFile) ? JspPsiUtil.getJspFile((PsiElement)psiFile).getJavaClass() : psiFile;
        while (true) {
            char c;
            CharSequence charsSequence = document.getCharsSequence();
            while (startOffset < charsSequence.length() && ((c = charsSequence.charAt(startOffset)) == ' ' || c == '\t')) {
                ++startOffset;
            }
            element = rootElement.findElementAt(startOffset);
            if (!(element instanceof PsiComment)) break;
            startOffset = element.getTextRange().getEndOffset() + 1;
        }
        if (element != null && element.getParent() instanceof PsiForStatement) {
            return ((PsiForStatement)element.getParent()).getInitialization();
        }
        return element;
    }

    public static boolean isJspImplicit(PsiElement element) {
        return Boolean.TRUE.equals(element.getUserData(IS_JSP_IMPLICIT));
    }
}

