/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.PlaceInDocument;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.Nullable;

public class ToggleMethodBreakpointAction
extends AnAction {
    public void update(AnActionEvent event) {
        boolean toEnable;
        boolean bl = toEnable = ToggleMethodBreakpointAction.getPlace(event) != null;
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            event.getPresentation().setVisible(toEnable);
        } else {
            event.getPresentation().setEnabled(toEnable);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        DebuggerManagerEx debugManager = DebuggerManagerEx.getInstanceEx(project);
        if (debugManager == null) {
            return;
        }
        BreakpointManager manager = debugManager.getBreakpointManager();
        PlaceInDocument place = ToggleMethodBreakpointAction.getPlace(e);
        if (place != null) {
            MethodBreakpoint breakpoint = manager.findBreakpoint(place.getDocument(), place.getOffset(), MethodBreakpoint.CATEGORY);
            if (breakpoint == null) {
                int methodLine = place.getDocument().getLineNumber(place.getOffset());
                MethodBreakpoint methodBreakpoint = manager.addMethodBreakpoint(place.getDocument(), methodLine);
                if (methodBreakpoint != null) {
                    RequestManagerImpl.createRequests(methodBreakpoint);
                }
            } else {
                manager.removeBreakpoint(breakpoint);
            }
        }
    }

    @Nullable
    private static PlaceInDocument getPlace(AnActionEvent event) {
        Project project = (Project)event.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return null;
        }
        PsiElement method = null;
        Document document = null;
        if ("ProjectViewPopup".equals(event.getPlace()) || "StructureViewPopup".equals(event.getPlace()) || "FavoritesPopup".equals(event.getPlace())) {
            PsiElement psiElement = (PsiElement)event.getData(LangDataKeys.PSI_ELEMENT);
            if (psiElement instanceof PsiMethod) {
                method = psiElement;
                document = PsiDocumentManager.getInstance((Project)project).getDocument(method.getContainingFile());
            }
        } else {
            Editor editor = (Editor)event.getData(PlatformDataKeys.EDITOR);
            if (editor == null) {
                editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            }
            if (editor != null) {
                document = editor.getDocument();
                PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                if (file != null) {
                    FileType fileType;
                    FileTypeManager fileTypeManager = FileTypeManager.getInstance();
                    VirtualFile virtualFile = file.getVirtualFile();
                    FileType fileType2 = fileType = virtualFile != null ? fileTypeManager.getFileTypeByFile(virtualFile) : null;
                    if (StdFileTypes.JAVA == fileType || StdFileTypes.CLASS == fileType) {
                        method = ToggleMethodBreakpointAction.findMethod(project, editor);
                    }
                }
            }
        }
        if (method != null) {
            final PsiElement method1 = method;
            final Document document1 = document;
            return new PlaceInDocument(){

                @Override
                public Document getDocument() {
                    return document1;
                }

                @Override
                public int getOffset() {
                    return method1.getTextOffset();
                }
            };
        }
        return null;
    }

    @Nullable
    private static PsiMethod findMethod(Project project, Editor editor) {
        if (editor == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return null;
        }
        int offset = CharArrayUtil.shiftForward((CharSequence)editor.getDocument().getCharsSequence(), (int)editor.getCaretModel().getOffset(), (String)" \t");
        return DebuggerUtilsEx.findPsiMethod(psiFile, offset);
    }
}

