/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class PsiMethodListPopupStep
implements ListPopupStep {
    private final List<PsiMethod> myMethods;
    private final OnChooseRunnable myStepRunnable;

    public PsiMethodListPopupStep(List<PsiMethod> methods, OnChooseRunnable stepRunnable) {
        this.myMethods = methods;
        this.myStepRunnable = stepRunnable;
    }

    @NotNull
    public List getValues() {
        List<PsiMethod> list = this.myMethods;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/actions/PsiMethodListPopupStep.getValues must not return null");
        }
        return list;
    }

    public boolean isSelectable(Object value) {
        return true;
    }

    public Icon getIconFor(Object aValue) {
        if (aValue instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)aValue;
            return method.getIcon(0);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getTextFor(Object value) {
        String string;
        if (value instanceof PsiMethod) {
            string = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)value), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2, (int)999);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/debugger/actions/PsiMethodListPopupStep.getTextFor must not return null");
            return string;
        }
        string = value.toString();
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/debugger/actions/PsiMethodListPopupStep.getTextFor must not return null");
    }

    public ListSeparator getSeparatorAbove(Object value) {
        return null;
    }

    public int getDefaultOptionIndex() {
        return 0;
    }

    public String getTitle() {
        return DebuggerBundle.message((String)"title.smart.step.popup", (Object[])new Object[0]);
    }

    public PopupStep onChosen(Object selectedValue, boolean finalChoice) {
        if (finalChoice) {
            this.myStepRunnable.execute((PsiMethod)selectedValue);
        }
        return FINAL_CHOICE;
    }

    public Runnable getFinalRunnable() {
        return null;
    }

    public boolean hasSubstep(Object selectedValue) {
        return false;
    }

    public void canceled() {
    }

    public boolean isMnemonicsNavigationEnabled() {
        return false;
    }

    public MnemonicNavigationFilter getMnemonicNavigationFilter() {
        return null;
    }

    public boolean isSpeedSearchEnabled() {
        return false;
    }

    public SpeedSearchFilter getSpeedSearchFilter() {
        return null;
    }

    public boolean isAutoSelectionEnabled() {
        return false;
    }

    public static interface OnChooseRunnable {
        public void execute(PsiMethod var1);
    }
}

