/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cyclicDependencies;

import com.intellij.cyclicDependencies.ShortestPathUtil;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CyclicGraphUtil {
    private CyclicGraphUtil() {
    }

    public static <Node> Set<List<Node>> getNodeCycles(final Graph<Node> graph, final Node node) {
        HashSet<List<Node>> result = new HashSet<List<Node>>();
        Graph graphWithoutNode = new Graph<Node>(){

            public Collection<Node> getNodes() {
                Collection nodes = graph.getNodes();
                nodes.remove(node);
                return nodes;
            }

            public Iterator<Node> getIn(Node n) {
                HashSet nodes = new HashSet();
                Iterator in = graph.getIn(n);
                while (in.hasNext()) {
                    nodes.add(in.next());
                }
                nodes.remove(node);
                return nodes.iterator();
            }

            public Iterator<Node> getOut(Node n) {
                HashSet nodes = new HashSet();
                Iterator out = graph.getOut(n);
                while (out.hasNext()) {
                    nodes.add(out.next());
                }
                nodes.remove(node);
                return nodes.iterator();
            }
        };
        HashSet inNodes = new HashSet();
        Iterator in = graph.getIn(node);
        while (in.hasNext()) {
            inNodes.add(in.next());
        }
        HashSet outNodes = new HashSet();
        Iterator out = graph.getOut(node);
        while (out.hasNext()) {
            outNodes.add(out.next());
        }
        HashSet retainNodes = new HashSet(inNodes);
        retainNodes.retainAll(outNodes);
        for (Object node1 : retainNodes) {
            ArrayList<Object> oneNodeCycle = new ArrayList<Object>();
            oneNodeCycle.add(node1);
            oneNodeCycle.add(node);
            result.add(oneNodeCycle);
        }
        inNodes.removeAll(retainNodes);
        outNodes.removeAll(retainNodes);
        ShortestPathUtil algorithm = new ShortestPathUtil(graphWithoutNode);
        for (Object fromNode : outNodes) {
            for (Object toNode : inNodes) {
                List shortestPath = algorithm.getShortestPath(toNode, fromNode);
                if (shortestPath == null) continue;
                ArrayList<Node> path = new ArrayList<Node>();
                path.addAll(shortestPath);
                path.add(node);
                result.add(path);
            }
        }
        return result;
    }
}

