/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.ConversionResultImpl;
import com.intellij.conversion.impl.ConversionRunner;
import com.intellij.conversion.impl.ProjectConversionUtil;
import com.intellij.conversion.impl.ui.ConvertProjectDialog;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Document;
import org.jetbrains.annotations.NotNull;

public class ConversionServiceImpl
extends ConversionService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.conversion.impl.ConversionServiceImpl");

    @Override
    @NotNull
    public ConversionResult convertSilently(@NotNull String projectPath) {
        if (projectPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/conversion/impl/ConversionServiceImpl.convertSilently must not be null");
        }
        ConversionResult conversionResult = this.convertSilently(projectPath, new ConversionListener(){

            @Override
            public void conversionNeeded() {
            }

            @Override
            public void successfullyConverted(File backupDir) {
            }

            @Override
            public void error(String message) {
            }

            @Override
            public void cannotWriteToFiles(List<File> readonlyFiles) {
            }
        });
        if (conversionResult == null) {
            throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionServiceImpl.convertSilently must not return null");
        }
        return conversionResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public ConversionResult convertSilently(@NotNull String projectPath, @NotNull ConversionListener listener) {
        ConversionResultImpl conversionResultImpl;
        block17: {
            HashSet<File> affectedFiles;
            List<ConversionRunner> runners;
            ConversionContextImpl context;
            block16: {
                block15: {
                    if (projectPath == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/conversion/impl/ConversionServiceImpl.convertSilently must not be null");
                    }
                    if (listener == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/conversion/impl/ConversionServiceImpl.convertSilently must not be null");
                    }
                    if (ConversionServiceImpl.isConversionNeeded(projectPath)) break block15;
                    conversionResultImpl = ConversionResultImpl.CONVERSION_NOT_NEEDED;
                    if (conversionResultImpl == null) throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionServiceImpl.convertSilently must not return null");
                    return conversionResultImpl;
                }
                listener.conversionNeeded();
                context = new ConversionContextImpl(projectPath);
                runners = ConversionServiceImpl.getConversionRunners(context);
                affectedFiles = new HashSet<File>();
                for (ConversionRunner runner : runners) {
                    affectedFiles.addAll(runner.getAffectedFiles());
                }
                List<File> readOnlyFiles = ConversionRunner.getReadOnlyFiles(affectedFiles);
                if (readOnlyFiles.isEmpty()) break block16;
                listener.cannotWriteToFiles(readOnlyFiles);
                conversionResultImpl = ConversionResultImpl.ERROR_OCCURRED;
                if (conversionResultImpl == null) throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionServiceImpl.convertSilently must not return null");
                return conversionResultImpl;
            }
            try {
                File backupDir = ProjectConversionUtil.backupFiles(affectedFiles, context.getProjectBaseDir());
                for (ConversionRunner runner : runners) {
                    if (!runner.isConversionNeeded()) continue;
                    runner.preProcess();
                    runner.process();
                    runner.postProcess();
                }
                context.saveFiles(affectedFiles);
                listener.successfullyConverted(backupDir);
                ConversionServiceImpl.saveConversionResult(context);
                conversionResultImpl = new ConversionResultImpl(runners);
                if (conversionResultImpl == null) throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionServiceImpl.convertSilently must not return null");
            }
            catch (CannotConvertException e) {
                listener.error(e.getMessage());
                break block17;
            }
            catch (IOException e) {
                listener.error(e.getMessage());
            }
            return conversionResultImpl;
        }
        if ((conversionResultImpl = ConversionResultImpl.ERROR_OCCURRED) != null) return conversionResultImpl;
        throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionServiceImpl.convertSilently must not return null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public ConversionResult convert(@NotNull String projectPath) {
        ConversionResultImpl conversionResultImpl;
        block12: {
            block11: {
                if (projectPath == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/conversion/impl/ConversionServiceImpl.convert must not be null");
                }
                try {
                    if (ConversionServiceImpl.isConversionNeeded(projectPath)) break block11;
                    conversionResultImpl = ConversionResultImpl.CONVERSION_NOT_NEEDED;
                    if (conversionResultImpl == null) throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionServiceImpl.convert must not return null");
                }
                catch (CannotConvertException e) {
                    LOG.info((Throwable)e);
                    Messages.showErrorDialog((String)IdeBundle.message((String)"error.cannot.convert.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.cannot.convert.project", (Object[])new Object[0]));
                    conversionResultImpl = ConversionResultImpl.ERROR_OCCURRED;
                    if (conversionResultImpl != null) return conversionResultImpl;
                    throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionServiceImpl.convert must not return null");
                }
                return conversionResultImpl;
            }
            ConversionContextImpl context = new ConversionContextImpl(projectPath);
            List<ConversionRunner> converters = ConversionServiceImpl.getConversionRunners(context);
            ConvertProjectDialog dialog = new ConvertProjectDialog(context, converters);
            dialog.show();
            if (!dialog.isConverted()) break block12;
            ConversionServiceImpl.saveConversionResult(context);
            conversionResultImpl = new ConversionResultImpl(converters);
            if (conversionResultImpl == null) throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionServiceImpl.convert must not return null");
            return conversionResultImpl;
        }
        conversionResultImpl = ConversionResultImpl.CONVERSION_CANCELED;
        if (conversionResultImpl == null) throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionServiceImpl.convert must not return null");
        return conversionResultImpl;
    }

    private static List<ConversionRunner> getConversionRunners(ConversionContextImpl context) throws CannotConvertException {
        List<ConversionRunner> converters = ConversionServiceImpl.getSortedConverters(context);
        Iterator<ConversionRunner> iterator = converters.iterator();
        HashSet<String> convertersToRunIds = new HashSet<String>();
        while (iterator.hasNext()) {
            ConversionRunner runner = iterator.next();
            boolean conversionNeeded = runner.isConversionNeeded();
            if (!conversionNeeded) {
                for (String id : runner.getProvider().getPrecedingConverterIds()) {
                    if (!convertersToRunIds.contains(id)) continue;
                    conversionNeeded = true;
                    break;
                }
            }
            if (conversionNeeded) {
                convertersToRunIds.add(runner.getProvider().getId());
                continue;
            }
            iterator.remove();
        }
        return converters;
    }

    public static boolean isConversionNeeded(String projectPath) throws CannotConvertException {
        ConversionContextImpl context = new ConversionContextImpl(projectPath);
        List<ConversionRunner> runners = ConversionServiceImpl.getSortedConverters(context);
        if (runners.isEmpty()) {
            return false;
        }
        for (ConversionRunner runner : runners) {
            if (!runner.isConversionNeeded()) continue;
            return true;
        }
        ConversionServiceImpl.saveConversionResult(context);
        return false;
    }

    private static List<ConversionRunner> getSortedConverters(ConversionContextImpl context) throws CannotConvertException {
        Set<String> performedConversionIds;
        CachedConversionResult conversionResult = ConversionServiceImpl.loadCachedConversionResult(context.getProjectFile());
        Map<String, Long> oldMap = conversionResult.myProjectFilesTimestamps;
        Map<String, Long> newMap = ConversionServiceImpl.getProjectFilesMap(context);
        boolean changed = false;
        LOG.debug("Checking project files");
        for (Map.Entry<String, Long> entry : newMap.entrySet()) {
            String path = entry.getKey();
            Long oldValue = oldMap.get(path);
            if (oldValue == null) {
                LOG.debug(" new file: " + path);
                changed = true;
                continue;
            }
            if (entry.getValue().equals(oldValue)) continue;
            LOG.debug(" changed file: " + path);
            changed = true;
        }
        if (changed) {
            performedConversionIds = Collections.emptySet();
            LOG.debug("Project files were modified.");
        } else {
            performedConversionIds = conversionResult.myAppliedConverters;
            LOG.debug("Project files are up to date. Applied converters: " + performedConversionIds);
        }
        return ConversionServiceImpl.createConversionRunners(context, performedConversionIds);
    }

    private static Map<String, Long> getProjectFilesMap(ConversionContextImpl context) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (File file : context.getAllProjectFiles()) {
            if (!file.exists()) continue;
            map.put(file.getAbsolutePath(), file.lastModified());
        }
        return map;
    }

    private static List<ConversionRunner> createConversionRunners(ConversionContextImpl context, Set<String> performedConversionIds) {
        ConverterProvider[] providers;
        ArrayList<ConversionRunner> runners = new ArrayList<ConversionRunner>();
        for (ConverterProvider provider : providers = (ConverterProvider[])ConverterProvider.EP_NAME.getExtensions()) {
            if (performedConversionIds.contains(provider.getId())) continue;
            runners.add(new ConversionRunner(provider, context));
        }
        CachingSemiGraph graph = CachingSemiGraph.create((GraphGenerator.SemiGraph)new ConverterProvidersGraph(providers));
        DFSTBuilder builder = new DFSTBuilder((Graph)GraphGenerator.create((GraphGenerator.SemiGraph)graph));
        if (!builder.isAcyclic()) {
            Pair pair = builder.getCircularDependency();
            LOG.error("cyclic dependencies between converters: " + ((ConverterProvider)pair.getFirst()).getId() + " and " + ((ConverterProvider)pair.getSecond()).getId());
        }
        final Comparator comparator = builder.comparator();
        Collections.sort(runners, new Comparator<ConversionRunner>(){

            @Override
            public int compare(ConversionRunner o1, ConversionRunner o2) {
                return comparator.compare(o1.getProvider(), o2.getProvider());
            }
        });
        return runners;
    }

    public static void saveConversionResult(String projectPath) {
        try {
            ConversionServiceImpl.saveConversionResult(new ConversionContextImpl(projectPath));
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
        }
    }

    private static void saveConversionResult(ConversionContextImpl context) {
        CachedConversionResult conversionResult = new CachedConversionResult();
        for (ConverterProvider provider : (ConverterProvider[])ConverterProvider.EP_NAME.getExtensions()) {
            conversionResult.myAppliedConverters.add(provider.getId());
        }
        conversionResult.myProjectFilesTimestamps = ConversionServiceImpl.getProjectFilesMap(context);
        File infoFile = ConversionServiceImpl.getConversionInfoFile(context.getProjectFile());
        FileUtil.createParentDirs((File)infoFile);
        try {
            JDOMUtil.writeDocument((Document)new Document(XmlSerializer.serialize((Object)conversionResult)), (File)infoFile, (String)SystemProperties.getLineSeparator());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static CachedConversionResult loadCachedConversionResult(File projectFile) {
        CachedConversionResult cachedConversionResult;
        File infoFile;
        try {
            infoFile = ConversionServiceImpl.getConversionInfoFile(projectFile);
            if (!infoFile.exists()) {
                cachedConversionResult = new CachedConversionResult();
                if (cachedConversionResult != null) return cachedConversionResult;
                throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionServiceImpl.loadCachedConversionResult must not return null");
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            cachedConversionResult = new CachedConversionResult();
            if (cachedConversionResult == null) throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionServiceImpl.loadCachedConversionResult must not return null");
            return cachedConversionResult;
        }
        {
            Document document = JDOMUtil.loadDocument((File)infoFile);
            CachedConversionResult result = (CachedConversionResult)XmlSerializer.deserialize((Document)document, CachedConversionResult.class);
            cachedConversionResult = result != null ? result : new CachedConversionResult();
            if (cachedConversionResult == null) throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionServiceImpl.loadCachedConversionResult must not return null");
        }
        return cachedConversionResult;
    }

    private static File getConversionInfoFile(@NotNull File projectFile) {
        if (projectFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/conversion/impl/ConversionServiceImpl.getConversionInfoFile must not be null");
        }
        String dirName = PathUtil.suggestFileName((String)(projectFile.getName() + Integer.toHexString(projectFile.getAbsolutePath().hashCode())));
        return new File(PathManager.getSystemPath() + File.separator + "conversion" + File.separator + dirName + ".xml");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public ConversionResult convertModule(@NotNull Project project, @NotNull File moduleFile) {
        ConversionResultImpl conversionResultImpl;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/conversion/impl/ConversionServiceImpl.convertModule must not be null");
        }
        if (moduleFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/conversion/impl/ConversionServiceImpl.convertModule must not be null");
        }
        IProjectStore stateStore = ((ProjectImpl)project).getStateStore();
        String projectPath = FileUtil.toSystemDependentName((String)stateStore.getLocation());
        if (!ConversionServiceImpl.isConversionNeeded(projectPath, moduleFile)) {
            conversionResultImpl = ConversionResultImpl.CONVERSION_NOT_NEEDED;
            if (conversionResultImpl == null) throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionServiceImpl.convertModule must not return null");
            return conversionResultImpl;
        }
        int res = Messages.showYesNoDialog((Project)project, (String)IdeBundle.message((String)"message.module.file.has.an.older.format.do.you.want.to.convert.it", (Object[])new Object[0]), (String)IdeBundle.message((String)"dialog.title.convert.module", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (res != 0) {
            conversionResultImpl = ConversionResultImpl.CONVERSION_CANCELED;
            if (conversionResultImpl == null) throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionServiceImpl.convertModule must not return null");
            return conversionResultImpl;
        }
        if (!moduleFile.canWrite()) {
            Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"error.message.cannot.modify.file.0", (Object[])new Object[]{moduleFile.getAbsolutePath()}), (String)IdeBundle.message((String)"dialog.title.convert.module", (Object[])new Object[0]));
            conversionResultImpl = ConversionResultImpl.ERROR_OCCURRED;
            if (conversionResultImpl == null) throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionServiceImpl.convertModule must not return null");
            return conversionResultImpl;
        }
        try {
            ConversionContextImpl context = new ConversionContextImpl(projectPath);
            List<ConversionRunner> runners = ConversionServiceImpl.createConversionRunners(context, Collections.<String>emptySet());
            File backupFile = ProjectConversionUtil.backupFile(moduleFile);
            for (ConversionRunner runner : runners) {
                if (!runner.isModuleConversionNeeded(moduleFile)) continue;
                runner.convertModule(moduleFile);
            }
            context.saveFiles(Collections.singletonList(moduleFile));
            Messages.showInfoMessage((Project)project, (String)IdeBundle.message((String)"message.your.module.was.succesfully.converted.br.old.version.was.saved.to.0", (Object[])new Object[]{backupFile.getAbsolutePath()}), (String)IdeBundle.message((String)"dialog.title.convert.module", (Object[])new Object[0]));
            conversionResultImpl = new ConversionResultImpl(runners);
            if (conversionResultImpl == null) throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionServiceImpl.convertModule must not return null");
            return conversionResultImpl;
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.cannot.load.project", (Object[])new Object[]{e.getMessage()}), (String)"Cannot Convert Module");
            conversionResultImpl = ConversionResultImpl.ERROR_OCCURRED;
            if (conversionResultImpl == null) throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionServiceImpl.convertModule must not return null");
            return conversionResultImpl;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            conversionResultImpl = ConversionResultImpl.ERROR_OCCURRED;
            if (conversionResultImpl == null) throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionServiceImpl.convertModule must not return null");
            return conversionResultImpl;
        }
    }

    private static boolean isConversionNeeded(String projectPath, File moduleFile) {
        try {
            ConversionContextImpl context = new ConversionContextImpl(projectPath);
            List<ConversionRunner> runners = ConversionServiceImpl.createConversionRunners(context, Collections.<String>emptySet());
            for (ConversionRunner runner : runners) {
                if (!runner.isModuleConversionNeeded(moduleFile)) continue;
                return true;
            }
            return false;
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
            return false;
        }
    }

    private static class ConverterProvidersGraph
    implements GraphGenerator.SemiGraph<ConverterProvider> {
        private final ConverterProvider[] myProviders;

        public ConverterProvidersGraph(ConverterProvider[] providers) {
            this.myProviders = providers;
        }

        public Collection<ConverterProvider> getNodes() {
            return Arrays.asList(this.myProviders);
        }

        public Iterator<ConverterProvider> getIn(ConverterProvider n) {
            ArrayList<ConverterProvider> preceding = new ArrayList<ConverterProvider>();
            for (String id : n.getPrecedingConverterIds()) {
                for (ConverterProvider provider : this.myProviders) {
                    if (!provider.getId().equals(id)) continue;
                    preceding.add(provider);
                }
            }
            return preceding.iterator();
        }
    }

    @Tag(value="conversion")
    public static class CachedConversionResult {
        @Tag(value="applied-converters")
        @AbstractCollection(surroundWithTag=false, elementTag="converter", elementValueAttribute="id")
        public Set<String> myAppliedConverters = new HashSet<String>();
        @Tag(value="project-files")
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, entryTagName="file", keyAttributeName="path", valueAttributeName="timestamp")
        public Map<String, Long> myProjectFilesTimestamps = new HashMap<String, Long>();
    }
}

