/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.make;

import com.intellij.compiler.SymbolTable;
import com.intellij.compiler.classParsing.ConstantValue;
import com.intellij.compiler.classParsing.GenericMethodSignature;
import com.intellij.compiler.classParsing.MethodInfo;
import com.intellij.compiler.classParsing.SignatureParsingException;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.compiler.make.CacheUtils;
import com.intellij.compiler.make.ChangeDescription;
import com.intellij.compiler.make.MakeUtil;
import com.intellij.util.cls.ClsUtil;
import java.util.Arrays;

class MethodChangeDescription
extends ChangeDescription {
    public final boolean returnTypeDescriptorChanged;
    public final boolean returnTypeGenericSignatureChanged;
    public final boolean paramsGenericSignatureChanged;
    public final boolean throwsListChanged;
    public final boolean flagsChanged;
    public final boolean staticPropertyChanged;
    public final boolean accessRestricted;
    public final boolean becameAbstract;
    public final boolean removedAnnotationDefault;

    public MethodChangeDescription(MethodInfo oldMethod, MethodInfo newMethod, SymbolTable symbolTable) throws CacheCorruptedException {
        String oldRtDescriptor = oldMethod.getReturnTypeDescriptor(symbolTable);
        String newRtDescriptor = newMethod.getReturnTypeDescriptor(symbolTable);
        this.returnTypeDescriptorChanged = !oldRtDescriptor.equals(newRtDescriptor);
        int oldGenericSignature = oldMethod.getGenericSignature();
        int newGenericSignature = newMethod.getGenericSignature();
        if (oldGenericSignature == newGenericSignature) {
            this.returnTypeGenericSignatureChanged = false;
            this.paramsGenericSignatureChanged = false;
        } else if (oldGenericSignature != -1 && newGenericSignature != -1) {
            try {
                GenericMethodSignature _oldGenericMethodSignature = GenericMethodSignature.parse(symbolTable.getSymbol(oldGenericSignature));
                GenericMethodSignature _newGenericMethodSignature = GenericMethodSignature.parse(symbolTable.getSymbol(newGenericSignature));
                this.returnTypeGenericSignatureChanged = !_oldGenericMethodSignature.getReturnTypeSignature().equals(_newGenericMethodSignature.getReturnTypeSignature());
                this.paramsGenericSignatureChanged = !_oldGenericMethodSignature.getFormalTypeParams().equals(_newGenericMethodSignature.getFormalTypeParams()) || !Arrays.equals(_oldGenericMethodSignature.getParamSignatures(), _newGenericMethodSignature.getParamSignatures());
            }
            catch (SignatureParsingException e) {
                throw new CacheCorruptedException(e);
            }
        } else {
            this.returnTypeGenericSignatureChanged = true;
            this.paramsGenericSignatureChanged = true;
        }
        this.throwsListChanged = !CacheUtils.areArraysContentsEqual(oldMethod.getThrownExceptions(), newMethod.getThrownExceptions());
        int oldFlags = oldMethod.getFlags();
        int newFlags = newMethod.getFlags();
        this.flagsChanged = oldFlags != newFlags;
        this.staticPropertyChanged = ClsUtil.isStatic((int)oldFlags) && !ClsUtil.isStatic((int)newFlags) || !ClsUtil.isStatic((int)oldFlags) && ClsUtil.isStatic((int)newFlags);
        this.accessRestricted = MakeUtil.isMoreAccessible(oldFlags, newFlags);
        this.becameAbstract = !ClsUtil.isAbstract((int)oldFlags) && ClsUtil.isAbstract((int)newFlags);
        ConstantValue oldDefault = oldMethod.getAnnotationDefault();
        ConstantValue newDefault = newMethod.getAnnotationDefault();
        this.removedAnnotationDefault = oldDefault != null && !ConstantValue.EMPTY_CONSTANT_VALUE.equals(oldDefault) && (newDefault == null || ConstantValue.EMPTY_CONSTANT_VALUE.equals(newDefault));
    }

    @Override
    public boolean isChanged() {
        return this.returnTypeDescriptorChanged || this.throwsListChanged || this.flagsChanged || this.returnTypeGenericSignatureChanged || this.paramsGenericSignatureChanged || this.removedAnnotationDefault;
    }
}

