/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.make;

import com.intellij.compiler.SymbolTable;
import com.intellij.compiler.classParsing.AnnotationConstantValue;
import com.intellij.compiler.classParsing.AnnotationNameValuePair;
import com.intellij.compiler.classParsing.ConstantValue;
import com.intellij.compiler.classParsing.ConstantValueArray;
import com.intellij.compiler.classParsing.EnumConstantValue;
import com.intellij.compiler.make.Cache;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.cls.ClsUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class MakeUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.make.MakeUtil");

    private MakeUtil() {
    }

    public static VirtualFile getSourceRoot(CompileContext context, Module module, VirtualFile file) {
        VirtualFile[] sourceRoots;
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        VirtualFile root = fileIndex.getSourceRootForFile(file);
        if (root != null) {
            return root;
        }
        for (VirtualFile sourceRoot : sourceRoots = context.getSourceRoots(module)) {
            if (fileIndex.isInSourceContent(sourceRoot) || !VfsUtil.isAncestor((VirtualFile)sourceRoot, (VirtualFile)file, (boolean)false)) continue;
            return sourceRoot;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String normalizeClassName(String qName) {
        int index = qName.indexOf(36);
        if (index >= 0) {
            qName = qName.substring(0, index);
        }
        if (SystemInfo.isFileSystemCaseSensitive) {
            return qName;
        }
        int dotIndex = qName.lastIndexOf(46);
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append(qName);
            for (int idx = 0; idx < dotIndex; ++idx) {
                builder.setCharAt(idx, Character.toLowerCase(builder.charAt(idx)));
            }
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    public static boolean isAnonymous(String name) {
        int index = name.lastIndexOf(36);
        if (index >= 0 && ++index < name.length()) {
            try {
                Integer.parseInt(name.substring(index));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isMoreAccessible(int flags1, int flags2) {
        if (ClsUtil.isPrivate((int)flags2)) {
            return ClsUtil.isPackageLocal((int)flags1) || ClsUtil.isProtected((int)flags1) || ClsUtil.isPublic((int)flags1);
        }
        if (ClsUtil.isPackageLocal((int)flags2)) {
            return ClsUtil.isProtected((int)flags1) || ClsUtil.isPublic((int)flags1);
        }
        if (ClsUtil.isProtected((int)flags2)) {
            return ClsUtil.isPublic((int)flags1);
        }
        return false;
    }

    @Nullable
    public static String relativeClassPathToQName(String relativePath, char separator) {
        if (!relativePath.endsWith(".class")) {
            return null;
        }
        int start = 0;
        int end = relativePath.length() - ".class".length();
        if (relativePath.startsWith(String.valueOf(separator))) {
            ++start;
        }
        return start <= end ? relativePath.substring(start, end).replace(separator, '.') : null;
    }

    @NonNls
    public static String parseObjectType(String descriptor, int fromIndex) {
        int semicolonIndex = descriptor.indexOf(59, fromIndex);
        if (descriptor.charAt(fromIndex) == 'L' && semicolonIndex > fromIndex) {
            return descriptor.substring(fromIndex + 1, semicolonIndex).replace('/', '.');
        }
        if (descriptor.charAt(fromIndex) == '[' && descriptor.length() - fromIndex > 0) {
            return MakeUtil.parseObjectType(descriptor, fromIndex + 1);
        }
        return null;
    }

    public static boolean isPrimitiveType(String descriptor) {
        return "V".equals(descriptor) || "B".equals(descriptor) || "C".equals(descriptor) || "D".equals(descriptor) || "F".equals(descriptor) || "I".equals(descriptor) || "J".equals(descriptor) || "S".equals(descriptor) || "Z".equals(descriptor);
    }

    public static boolean isArrayType(String descriptor) {
        return StringUtil.startsWithChar((CharSequence)descriptor, (char)'[');
    }

    public static String getComponentType(String descriptor) {
        if (!MakeUtil.isArrayType(descriptor)) {
            return null;
        }
        return descriptor.substring(1);
    }

    public static String createRelativePathToSource(String qualifiedName, String srcName) {
        int index = (qualifiedName = MakeUtil.normalizeClassName(qualifiedName)).lastIndexOf(46);
        if (index >= 0) {
            srcName = qualifiedName.substring(0, index).replace('.', '/') + "/" + srcName;
        }
        return srcName;
    }

    public static boolean isInterface(int flags) {
        return (0x200 & flags) != 0;
    }

    public static int getAnnotationTargets(Cache cache, int annotationQName, SymbolTable symbolTable) throws CacheCorruptedException {
        AnnotationConstantValue targetAnnotation = MakeUtil.findAnnotation("java.lang.annotation.Target", cache.getRuntimeVisibleAnnotations(annotationQName), symbolTable);
        if (targetAnnotation == null) {
            return 255;
        }
        AnnotationNameValuePair[] memberValues = targetAnnotation.getMemberValues();
        ConstantValueArray value = (ConstantValueArray)memberValues[0].getValue();
        ConstantValue[] targets = value.getValue();
        int annotationTargets = 0;
        for (ConstantValue target : targets) {
            if (!(target instanceof EnumConstantValue)) continue;
            String constantName = symbolTable.getSymbol(((EnumConstantValue)target).getConstantName());
            if ("TYPE".equals(constantName)) {
                annotationTargets |= 1;
            }
            if ("FIELD".equals(constantName)) {
                annotationTargets |= 2;
            }
            if ("METHOD".equals(constantName)) {
                annotationTargets |= 4;
            }
            if ("PARAMETER".equals(constantName)) {
                annotationTargets |= 8;
            }
            if ("CONSTRUCTOR".equals(constantName)) {
                annotationTargets |= 0x10;
            }
            if ("LOCAL_VARIABLE".equals(constantName)) {
                annotationTargets |= 0x20;
            }
            if ("ANNOTATION_TYPE".equals(constantName)) {
                annotationTargets |= 0x40;
            }
            if (!"PACKAGE".equals(constantName)) continue;
            annotationTargets |= 0x80;
        }
        return annotationTargets;
    }

    public static int getAnnotationRetentionPolicy(int annotationQName, Cache cache, SymbolTable symbolTable) throws CacheCorruptedException {
        AnnotationConstantValue retentionPolicyAnnotation = MakeUtil.findAnnotation("java.lang.annotation.Retention", cache.getRuntimeVisibleAnnotations(annotationQName), symbolTable);
        if (retentionPolicyAnnotation == null) {
            return 2;
        }
        AnnotationNameValuePair[] memberValues = retentionPolicyAnnotation.getMemberValues();
        EnumConstantValue value = (EnumConstantValue)memberValues[0].getValue();
        String constantName = symbolTable.getSymbol(value.getConstantName());
        if ("SOURCE".equals(constantName)) {
            return 1;
        }
        if ("CLASS".equals(constantName)) {
            return 2;
        }
        if ("RUNTIME".equals(constantName)) {
            return 4;
        }
        LOG.error("Unknown retention policy: " + constantName);
        return -1;
    }

    public static AnnotationConstantValue findAnnotation(@NonNls String annotationQName, AnnotationConstantValue[] annotations, SymbolTable symbolTable) throws CacheCorruptedException {
        for (AnnotationConstantValue annotation : annotations) {
            if (!annotationQName.equals(symbolTable.getSymbol(annotation.getAnnotationQName()))) continue;
            return annotation;
        }
        return null;
    }

    public static String getModuleOutputDirPath(final Module module) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                String url = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputUrl();
                if (url == null) {
                    return null;
                }
                return VfsUtil.urlToPath((String)url);
            }
        });
    }
}

