/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.api;

import com.intellij.compiler.impl.javaCompiler.api.CompAPIDriver;
import com.intellij.compiler.impl.javaCompiler.api.JavaIoFile;
import com.intellij.compiler.impl.javaCompiler.api.JavaVirtualByIoFile;
import com.intellij.compiler.impl.javaCompiler.api.JavaVirtualFile;
import com.intellij.compiler.impl.javaCompiler.api.Output;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DefaultFileManager;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

class MyFileManager
extends DefaultFileManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.javaCompiler.api.MyFileManager");
    private final String myOutputDir;
    private final CompAPIDriver myCompAPIDriver;

    MyFileManager(CompAPIDriver compAPIDriver, String outputDir) {
        super(new Context(), false, null);
        this.myCompAPIDriver = compAPIDriver;
        this.myOutputDir = outputDir;
    }

    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        int size = ((Collection)files).size();
        ArrayList<JavaVirtualByIoFile> result = new ArrayList<JavaVirtualByIoFile>(size);
        for (File file : files) {
            JavaVirtualByIoFile fileObject = new JavaVirtualByIoFile(file, JavaFileObject.Kind.SOURCE);
            result.add(fileObject);
        }
        return result;
    }

    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject fileObject) {
        URI uri = MyFileManager.toURI(this.myOutputDir, name);
        return new Output(uri, this.myCompAPIDriver);
    }

    static URI createUri(String url) {
        return URI.create(url.replaceAll(" ", "%20"));
    }

    private static URI toURI(String outputDir, String name) {
        return MyFileManager.createUri("file:///" + outputDir.replace('\\', '/') + "/" + name.replace('.', '/') + JavaFileObject.Kind.CLASS.extension);
    }

    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        List<JavaFileObject> ret;
        if (recurse) {
            return super.list(location, packageName, kinds, recurse);
        }
        Iterable path = this.getLocation(location);
        if (path == null) {
            return Collections.emptyList();
        }
        String subdirectory = packageName.replace('.', '/');
        SmartList results = null;
        for (File directory : path) {
            VirtualFile virtualFile;
            VirtualFile dir = LocalFileSystem.getInstance().findFileByIoFile(directory);
            if (dir == null || !dir.isDirectory() && (dir = JarFileSystem.getInstance().getJarRootForLocalFile(dir)) == null || (virtualFile = StringUtil.isEmptyOrSpaces((String)subdirectory) ? dir : dir.findFileByRelativePath(subdirectory)) == null || !virtualFile.isDirectory()) continue;
            for (VirtualFile child : virtualFile.getChildren()) {
                JavaFileObject.Kind kind = this.getKind("." + child.getExtension());
                if (!kinds.contains((Object)kind)) continue;
                if (results == null) {
                    results = new SmartList();
                }
                if (kind == JavaFileObject.Kind.SOURCE && child.getFileSystem() instanceof JarFileSystem) continue;
                SimpleJavaFileObject fileObject = kind == JavaFileObject.Kind.CLASS && child.getFileSystem() == LocalFileSystem.getInstance() ? new JavaIoFile(new File(child.getPath()), kind) : new JavaVirtualFile(child, kind);
                results.add(fileObject);
            }
        }
        List<JavaFileObject> list = ret = results == null ? Collections.emptyList() : results;
        if (LOG.isDebugEnabled()) {
            Collection c = (Collection)super.list(location, packageName, kinds, recurse);
            HashSet sup = new HashSet(c);
            assert (sup.size() == c.size());
            assert (new HashSet(c).equals(sup));
            THashSet s = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<JavaFileObject>(){

                public int computeHashCode(JavaFileObject object) {
                    return object.getName().hashCode();
                }

                public boolean equals(JavaFileObject o1, JavaFileObject o2) {
                    return o1.getKind() == o2.getKind() && o1.toUri().equals(o2.toUri());
                }
            });
            s.addAll(ret);
            s.removeAll(sup);
            if (ret.size() != sup.size()) assert (false) : "our implementation differs from javac'";
        }
        return ret;
    }

    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        return FileUtil.getNameWithoutExtension((String)new File(file.getName()).getName());
    }
}

