/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.ProjectTopics;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerIOUtil;
import com.intellij.compiler.impl.SourceUrlClassNamePair;
import com.intellij.compiler.make.MakeUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.DummyCompileContext;
import com.intellij.openapi.compiler.IntermediateOutputCompiler;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntLongHashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import gnu.trove.TIntProcedure;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TranslatingCompilerFilesMonitor
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.TranslatingCompilerFilesMonitor");
    @NonNls
    private static final String PATHS_TO_DELETE_FILENAME = "paths_to_delete.dat";
    private static final String OUTPUT_ROOTS_FILENAME = "output_roots.dat";
    private static final FileAttribute ourSourceFileAttribute = new FileAttribute("_make_source_file_info_", 3);
    private static final FileAttribute ourOutputFileAttribute = new FileAttribute("_make_output_file_info_", 3);
    private final TIntObjectHashMap<TIntHashSet> mySourcesToRecompile = new TIntObjectHashMap();
    private PersistentHashMap<Integer, TIntObjectHashMap<Pair<Integer, Integer>>> myOutputRootsStorage;
    private final TIntObjectHashMap<Map<String, SourceUrlClassNamePair>> myOutputsToDelete = new TIntObjectHashMap();
    private final SLRUCache<Project, File> myGeneratedDataPaths = new SLRUCache<Project, File>(8, 8){

        @NotNull
        public File createValue(final Project project) {
            Disposer.register((Disposable)project, (Disposable)new Disposable(){

                public void dispose() {
                    TranslatingCompilerFilesMonitor.this.myGeneratedDataPaths.remove((Object)project);
                }
            });
            File file = CompilerPaths.getGeneratedDataDirectory((Project)project);
            if (file == null) {
                throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$1.createValue must not return null");
            }
            return file;
        }
    };
    private final SLRUCache<Integer, TIntObjectHashMap<Pair<Integer, Integer>>> myProjectOutputRoots = new SLRUCache<Integer, TIntObjectHashMap<Pair<Integer, Integer>>>(2, 2){

        protected void onDropFromCache(Integer key, TIntObjectHashMap<Pair<Integer, Integer>> value) {
            try {
                TranslatingCompilerFilesMonitor.this.myOutputRootsStorage.put((Object)key, value);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }

        @NotNull
        public TIntObjectHashMap<Pair<Integer, Integer>> createValue(Integer key) {
            TIntObjectHashMap map = null;
            try {
                TranslatingCompilerFilesMonitor.this.ensureOutputStorageInitialized();
                map = (TIntObjectHashMap)TranslatingCompilerFilesMonitor.this.myOutputRootsStorage.get((Object)key);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            TIntObjectHashMap tIntObjectHashMap = map != null ? map : new TIntObjectHashMap();
            if (tIntObjectHashMap == null) {
                throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$2.createValue must not return null");
            }
            return tIntObjectHashMap;
        }
    };
    private final ProjectManager myProjectManager;
    private final TIntHashSet myInitInProgress = new TIntHashSet();
    private final Object myInitializationLock = new Object();

    public TranslatingCompilerFilesMonitor(VirtualFileManager vfsManager, ProjectManager projectManager, Application application) {
        this.myProjectManager = projectManager;
        projectManager.addProjectManagerListener((ProjectManagerListener)new MyProjectManagerListener());
        vfsManager.addVirtualFileListener((VirtualFileListener)new MyVfsListener(), (Disposable)application);
    }

    public static TranslatingCompilerFilesMonitor getInstance() {
        return (TranslatingCompilerFilesMonitor)ApplicationManager.getApplication().getComponent(TranslatingCompilerFilesMonitor.class);
    }

    @Nullable
    public static VirtualFile getSourceFileByOutput(VirtualFile outputFile) {
        String path;
        OutputFileInfo outputFileInfo = TranslatingCompilerFilesMonitor.loadOutputInfo(outputFile);
        if (outputFileInfo != null && (path = outputFileInfo.getSourceFilePath()) != null) {
            return LocalFileSystem.getInstance().findFileByPath(path);
        }
        return null;
    }

    public boolean isScheduledForRecompilation(Project project, VirtualFile file) {
        TIntHashSet pathsToRecompile = (TIntHashSet)this.mySourcesToRecompile.get(TranslatingCompilerFilesMonitor.getProjectId(project));
        if (pathsToRecompile == null || pathsToRecompile.isEmpty()) {
            return false;
        }
        int fileId = TranslatingCompilerFilesMonitor.getFileId(file);
        return pathsToRecompile.contains(fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectFiles(CompileContext context, TranslatingCompiler compiler, Iterator<VirtualFile> scopeSrcIterator, boolean forceCompile, boolean isRebuild, Collection<VirtualFile> toCompile, Collection<Trinity<File, String, Boolean>> toDelete) {
        Project project = context.getProject();
        int projectId = TranslatingCompilerFilesMonitor.getProjectId(project);
        CompilerConfiguration configuration = CompilerConfiguration.getInstance((Project)project);
        boolean _forceCompile = forceCompile || isRebuild;
        HashSet<VirtualFile> selectedForRecompilation = new HashSet<VirtualFile>();
        Object object = this.mySourcesToRecompile;
        synchronized (object) {
            TIntHashSet pathsToRecompile = (TIntHashSet)this.mySourcesToRecompile.get(projectId);
            if (_forceCompile || pathsToRecompile != null && !pathsToRecompile.isEmpty()) {
                while (scopeSrcIterator.hasNext()) {
                    VirtualFile file = scopeSrcIterator.next();
                    if (!file.isValid()) continue;
                    int fileId = TranslatingCompilerFilesMonitor.getFileId(file);
                    if (_forceCompile) {
                        if (!compiler.isCompilableFile(file, context) || configuration.isExcludedFromCompilation(file)) continue;
                        toCompile.add(file);
                        selectedForRecompilation.add(file);
                        if (pathsToRecompile != null && pathsToRecompile.contains(fileId)) continue;
                        this.addSourceForRecompilation(projectId, file, null);
                        continue;
                    }
                    if (!pathsToRecompile.contains(fileId) || !compiler.isCompilableFile(file, context) || configuration.isExcludedFromCompilation(file)) continue;
                    toCompile.add(file);
                    selectedForRecompilation.add(file);
                }
            }
        }
        if (!isRebuild) {
            object = this.myOutputsToDelete;
            synchronized (object) {
                Map outputsToDelete = (Map)this.myOutputsToDelete.get(projectId);
                if (outputsToDelete != null) {
                    VirtualFileManager vfm = VirtualFileManager.getInstance();
                    LocalFileSystem lfs = LocalFileSystem.getInstance();
                    ArrayList<String> zombieEntries = new ArrayList<String>();
                    for (String outputPath : outputsToDelete.keySet()) {
                        boolean sourcePresent;
                        SourceUrlClassNamePair classNamePair = (SourceUrlClassNamePair)outputsToDelete.get(outputPath);
                        String sourceUrl = classNamePair.getSourceUrl();
                        VirtualFile srcFile = vfm.findFileByUrl(sourceUrl);
                        boolean bl = sourcePresent = srcFile != null;
                        if (sourcePresent && (!compiler.isCompilableFile(srcFile, context) || !selectedForRecompilation.contains(srcFile))) continue;
                        if (lfs.findFileByPath(outputPath) != null) {
                            File file = new File(outputPath);
                            toDelete.add((Trinity<File, String, Boolean>)new Trinity((Object)file, (Object)classNamePair.getClassName(), (Object)sourcePresent));
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("Found file to delete: " + file);
                            continue;
                        }
                        zombieEntries.add(outputPath);
                    }
                    for (String path : zombieEntries) {
                        this.unmarkOutputPathForDeletion(path);
                    }
                }
            }
        }
    }

    private static int getFileId(VirtualFile file) {
        return FileBasedIndex.getFileId(file);
    }

    private static VirtualFile findFileById(int id) {
        return IndexInfrastructure.findFileById((PersistentFS)ManagingFS.getInstance(), id);
    }

    public void update(final CompileContext context, final String outputRoot, final Collection<TranslatingCompiler.OutputItem> successfullyCompiled, final VirtualFile[] filesToRecompile) throws IOException {
        Project project = context.getProject();
        final int projectId = TranslatingCompilerFilesMonitor.getProjectId(project);
        if (successfullyCompiled.size() > 0) {
            final LocalFileSystem lfs = LocalFileSystem.getInstance();
            final IOException[] exceptions = new IOException[]{null};
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        HashMap<VirtualFile, SourceFileInfo> compiledSources = new HashMap<VirtualFile, SourceFileInfo>();
                        HashSet<VirtualFile> forceRecompile = new HashSet<VirtualFile>();
                        for (TranslatingCompiler.OutputItem item : successfullyCompiled) {
                            String outputPath;
                            VirtualFile sourceFile = item.getSourceFile();
                            boolean isSourceValid = sourceFile.isValid();
                            SourceFileInfo srcInfo = (SourceFileInfo)compiledSources.get(sourceFile);
                            if (isSourceValid && srcInfo == null) {
                                srcInfo = TranslatingCompilerFilesMonitor.loadSourceInfo(sourceFile);
                                if (srcInfo != null) {
                                    srcInfo.clearPaths(projectId);
                                } else {
                                    srcInfo = new SourceFileInfo();
                                }
                                compiledSources.put(sourceFile, srcInfo);
                            }
                            if ((outputPath = item.getOutputPath()) == null) continue;
                            VirtualFile outputFile = lfs.findFileByPath(outputPath);
                            assert (outputRoot != null);
                            if (outputFile != null) {
                                if (sourceFile.equals(outputFile)) continue;
                                String className = MakeUtil.relativeClassPathToQName(outputPath.substring(outputRoot.length()), '/');
                                if (isSourceValid) {
                                    srcInfo.addOutputPath(projectId, outputPath);
                                    TranslatingCompilerFilesMonitor.saveOutputInfo(outputFile, new OutputFileInfo(sourceFile.getPath(), className));
                                    continue;
                                }
                                TranslatingCompilerFilesMonitor.this.markOutputPathForDeletion(projectId, outputPath, className, sourceFile.getUrl());
                                continue;
                            }
                            LOG.warn("TranslatingCompilerFilesMonitor.update():  Virtual file was not found for \"" + outputPath + "\"");
                            if (!isSourceValid) continue;
                            forceRecompile.add(sourceFile);
                        }
                        long compilationStartStamp = ((CompileContextEx)context).getStartCompilationStamp();
                        for (Map.Entry entry : compiledSources.entrySet()) {
                            SourceFileInfo info = (SourceFileInfo)entry.getValue();
                            VirtualFile file = (VirtualFile)entry.getKey();
                            long fileStamp = file.getTimeStamp();
                            info.updateTimestamp(projectId, fileStamp);
                            TranslatingCompilerFilesMonitor.saveSourceInfo(file, info);
                            TranslatingCompilerFilesMonitor.this.removeSourceForRecompilation(projectId, Math.abs(TranslatingCompilerFilesMonitor.getFileId(file)));
                            if ((fileStamp <= compilationStartStamp || ((CompileContextEx)context).isGenerated(file)) && !forceRecompile.contains(file)) continue;
                            TranslatingCompilerFilesMonitor.this.addSourceForRecompilation(projectId, file, info);
                        }
                    }
                    catch (IOException e) {
                        exceptions[0] = e;
                    }
                }
            });
            if (exceptions[0] != null) {
                throw exceptions[0];
            }
        }
        if (filesToRecompile.length > 0) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    for (VirtualFile file : filesToRecompile) {
                        if (!file.isValid()) continue;
                        TranslatingCompilerFilesMonitor.this.addSourceForRecompilation(projectId, file, null);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOutputRootsLayout(Project project) {
        TIntObjectHashMap<Pair<Integer, Integer>> map = this.buildOutputRootsLayout(project);
        SLRUCache<Integer, TIntObjectHashMap<Pair<Integer, Integer>>> sLRUCache = this.myProjectOutputRoots;
        synchronized (sLRUCache) {
            this.myProjectOutputRoots.put((Object)TranslatingCompilerFilesMonitor.getProjectId(project), map);
        }
    }

    @NotNull
    public String getComponentName() {
        if ("TranslatingCompilerFilesMonitor" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/TranslatingCompilerFilesMonitor.getComponentName must not return null");
        }
        return "TranslatingCompilerFilesMonitor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initComponent() {
        File file = new File(CompilerPaths.getCompilerSystemDirectory(), PATHS_TO_DELETE_FILENAME);
        try {
            DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            try {
                int projectsCount = is.readInt();
                TIntObjectHashMap<Map<String, SourceUrlClassNamePair>> tIntObjectHashMap = this.myOutputsToDelete;
                synchronized (tIntObjectHashMap) {
                    for (int idx = 0; idx < projectsCount; ++idx) {
                        int projectId = is.readInt();
                        int size = is.readInt();
                        if (size <= 0) continue;
                        HashMap<String, SourceUrlClassNamePair> map = new HashMap<String, SourceUrlClassNamePair>();
                        this.myOutputsToDelete.put(projectId, map);
                        for (int i = 0; i < size; ++i) {
                            String outputPath = FileUtil.toSystemIndependentName((String)CompilerIOUtil.readString(is));
                            String srcUrl = CompilerIOUtil.readString(is);
                            String className = CompilerIOUtil.readString(is);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("INIT path to delete: " + outputPath);
                            }
                            map.put(outputPath, new SourceUrlClassNamePair(srcUrl, className));
                        }
                    }
                }
            }
            finally {
                is.close();
            }
        }
        catch (FileNotFoundException ignored) {
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.myOutputsToDelete.clear();
            FileUtil.delete((File)file);
        }
        this.ensureOutputStorageInitialized();
    }

    private void ensureOutputStorageInitialized() {
        if (this.myOutputRootsStorage != null) {
            return;
        }
        File rootsFile = new File(CompilerPaths.getCompilerSystemDirectory(), OUTPUT_ROOTS_FILENAME);
        try {
            this.initOutputRootsFile(rootsFile);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            FileUtil.delete((File)rootsFile);
            try {
                this.initOutputRootsFile(rootsFile);
            }
            catch (IOException e1) {
                LOG.error((Throwable)e1);
            }
        }
    }

    private TIntObjectHashMap<Pair<Integer, Integer>> buildOutputRootsLayout(Project project) {
        TIntObjectHashMap map = new TIntObjectHashMap();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            CompilerModuleExtension manager = CompilerModuleExtension.getInstance((Module)module);
            if (manager == null) continue;
            VirtualFile output = manager.getCompilerOutputPath();
            int first = output != null ? Math.abs(TranslatingCompilerFilesMonitor.getFileId(output)) : -1;
            VirtualFile testsOutput = manager.getCompilerOutputPathForTests();
            int second = testsOutput != null ? Math.abs(TranslatingCompilerFilesMonitor.getFileId(testsOutput)) : -1;
            map.put(TranslatingCompilerFilesMonitor.getModuleId(module), (Object)new Pair((Object)first, (Object)second));
        }
        return map;
    }

    private void initOutputRootsFile(File rootsFile) throws IOException {
        this.myOutputRootsStorage = new PersistentHashMap(rootsFile, (KeyDescriptor)new EnumeratorIntegerDescriptor(), (DataExternalizer)new DataExternalizer<TIntObjectHashMap<Pair<Integer, Integer>>>(){

            public void save(DataOutput out, TIntObjectHashMap<Pair<Integer, Integer>> value) throws IOException {
                TIntObjectIterator it = value.iterator();
                while (it.hasNext()) {
                    it.advance();
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)it.key());
                    Pair pair = (Pair)it.value();
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)((Integer)pair.first));
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)((Integer)pair.second));
                }
            }

            public TIntObjectHashMap<Pair<Integer, Integer>> read(DataInput in) throws IOException {
                DataInputStream _in = (DataInputStream)in;
                TIntObjectHashMap map = new TIntObjectHashMap();
                while (_in.available() > 0) {
                    int key = DataInputOutputUtil.readINT((DataInput)_in);
                    int first = DataInputOutputUtil.readINT((DataInput)_in);
                    int second = DataInputOutputUtil.readINT((DataInput)_in);
                    map.put(key, (Object)new Pair((Object)first, (Object)second));
                }
                return map;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeComponent() {
        File file = new File(CompilerPaths.getCompilerSystemDirectory(), PATHS_TO_DELETE_FILENAME);
        try {
            TIntObjectHashMap<Map<String, SourceUrlClassNamePair>> tIntObjectHashMap;
            FileUtil.createParentDirs((File)file);
            DataOutputStream os = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                tIntObjectHashMap = this.myOutputsToDelete;
                synchronized (tIntObjectHashMap) {
                    int[] keys = this.myOutputsToDelete.keys();
                    os.writeInt(keys.length);
                    for (int projectId : keys) {
                        Map projectOutputs = (Map)this.myOutputsToDelete.get(projectId);
                        os.writeInt(projectId);
                        if (projectOutputs != null) {
                            os.writeInt(projectOutputs.size());
                            for (Map.Entry entry : projectOutputs.entrySet()) {
                                CompilerIOUtil.writeString((String)entry.getKey(), os);
                                SourceUrlClassNamePair pair = (SourceUrlClassNamePair)entry.getValue();
                                CompilerIOUtil.writeString(pair.getSourceUrl(), os);
                                CompilerIOUtil.writeString(pair.getClassName(), os);
                            }
                            continue;
                        }
                        os.writeInt(0);
                    }
                }
            }
            finally {
                os.close();
                tIntObjectHashMap = this.myProjectOutputRoots;
                synchronized (tIntObjectHashMap) {
                    this.myProjectOutputRoots.clear();
                }
                this.myOutputRootsStorage.close();
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static SourceFileInfo loadSourceInfo(VirtualFile file) {
        block7: {
            SourceFileInfo sourceFileInfo;
            DataInputStream is = ourSourceFileAttribute.readAttribute(file);
            if (is == null) break block7;
            try {
                sourceFileInfo = new SourceFileInfo(is);
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IOException) {
                        LOG.info((Throwable)e);
                        break block7;
                    }
                    throw e;
                }
                catch (IOException ignored) {
                    LOG.info((Throwable)ignored);
                }
            }
            is.close();
            return sourceFileInfo;
        }
        return null;
    }

    public static void removeSourceInfo(VirtualFile file) {
        TranslatingCompilerFilesMonitor.saveSourceInfo(file, new SourceFileInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveSourceInfo(VirtualFile file, SourceFileInfo descriptor) {
        DataOutputStream out = ourSourceFileAttribute.writeAttribute(file);
        try {
            try {
                descriptor.save(out);
            }
            finally {
                out.close();
            }
        }
        catch (IOException ignored) {
            LOG.info((Throwable)ignored);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static OutputFileInfo loadOutputInfo(VirtualFile file) {
        block7: {
            OutputFileInfo outputFileInfo;
            DataInputStream is = ourOutputFileAttribute.readAttribute(file);
            if (is == null) break block7;
            try {
                outputFileInfo = new OutputFileInfo(is);
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IOException) {
                        LOG.info((Throwable)e);
                        break block7;
                    }
                    throw e;
                }
                catch (IOException ignored) {
                    LOG.info((Throwable)ignored);
                }
            }
            is.close();
            return outputFileInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveOutputInfo(VirtualFile file, OutputFileInfo descriptor) {
        DataOutputStream out = ourOutputFileAttribute.writeAttribute(file);
        try {
            try {
                descriptor.save(out);
            }
            finally {
                out.close();
            }
        }
        catch (IOException ignored) {
            LOG.info((Throwable)ignored);
        }
    }

    private static int getProjectId(Project project) {
        try {
            return FSRecords.getNames().enumerate((Object)project.getLocationHash());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return -1;
        }
    }

    private static int getModuleId(Module module) {
        try {
            return FSRecords.getNames().enumerate((Object)module.getName());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return -1;
        }
    }

    private static void processRecursively(VirtualFile file, boolean dbOnly, FileProcessor processor) {
        if (file.getFileSystem() instanceof LocalFileSystem) {
            if (file.isDirectory()) {
                if (dbOnly) {
                    for (VirtualFile child : ((NewVirtualFile)file).getInDbChildren()) {
                        if (NullVirtualFile.INSTANCE == child) continue;
                        TranslatingCompilerFilesMonitor.processRecursively(child, true, processor);
                    }
                } else {
                    for (VirtualFile child : file.getChildren()) {
                        TranslatingCompilerFilesMonitor.processRecursively(child, false, processor);
                    }
                }
            } else {
                processor.execute(file);
            }
        }
    }

    public void scanSourceContent(Project project, Collection<VirtualFile> roots, int totalRootCount, boolean isNewRoots) {
        if (roots.size() == 0) {
            return;
        }
        final int projectId = TranslatingCompilerFilesMonitor.getProjectId(project);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        int processed = 0;
        for (VirtualFile srcRoot : roots) {
            if (indicator != null) {
                indicator.setText2(srcRoot.getPresentableUrl());
                indicator.setFraction((double)(++processed) / (double)totalRootCount);
            }
            if (isNewRoots) {
                fileIndex.iterateContentUnderDirectory(srcRoot, new ContentIterator(){

                    public boolean processFile(VirtualFile file) {
                        SourceFileInfo srcInfo;
                        if (!(file.isDirectory() || TranslatingCompilerFilesMonitor.this.isMarkedForRecompilation(projectId, TranslatingCompilerFilesMonitor.getFileId(file)) || (srcInfo = TranslatingCompilerFilesMonitor.loadSourceInfo(file)) != null && srcInfo.getTimestamp(projectId) == file.getTimeStamp())) {
                            TranslatingCompilerFilesMonitor.this.addSourceForRecompilation(projectId, file, srcInfo);
                        }
                        return true;
                    }
                });
                continue;
            }
            final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            new Object(){

                void processFile(VirtualFile file) {
                    if (fileTypeManager.isFileIgnored(file.getName())) {
                        return;
                    }
                    int fileId = TranslatingCompilerFilesMonitor.getFileId(file);
                    if (fileId > 0) {
                        SourceFileInfo srcInfo;
                        if (file.isDirectory()) {
                            for (VirtualFile child : file.getChildren()) {
                                this.processFile(child);
                            }
                        } else if (!TranslatingCompilerFilesMonitor.this.isMarkedForRecompilation(projectId, fileId) && (srcInfo = TranslatingCompilerFilesMonitor.loadSourceInfo(file)) != null) {
                            TranslatingCompilerFilesMonitor.this.addSourceForRecompilation(projectId, file, srcInfo);
                        }
                    }
                }
            }.processFile(srcRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureInitializationCompleted(Project project) {
        int id = TranslatingCompilerFilesMonitor.getProjectId(project);
        Object object = this.myInitializationLock;
        synchronized (object) {
            while (this.myInitInProgress.contains(id) && project.isOpen() && !project.isDisposed()) {
                try {
                    this.myInitializationLock.wait();
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markOldOutputRoots(Project project, TIntObjectHashMap<Pair<Integer, Integer>> currentLayout) {
        int projectId = TranslatingCompilerFilesMonitor.getProjectId(project);
        TIntHashSet rootsToMark = new TIntHashSet();
        SLRUCache<Integer, TIntObjectHashMap<Pair<Integer, Integer>>> sLRUCache = this.myProjectOutputRoots;
        synchronized (sLRUCache) {
            TIntObjectHashMap oldLayout = (TIntObjectHashMap)this.myProjectOutputRoots.get((Object)projectId);
            TIntObjectIterator it = oldLayout.iterator();
            while (it.hasNext()) {
                it.advance();
                Pair currentRoots = (Pair)currentLayout.get(it.key());
                Pair oldRoots = (Pair)it.value();
                if (this.shouldMark((Integer)oldRoots.first, currentRoots != null ? (Integer)currentRoots.first : -1)) {
                    rootsToMark.add(((Integer)oldRoots.first).intValue());
                }
                if (!this.shouldMark((Integer)oldRoots.second, currentRoots != null ? (Integer)currentRoots.second : -1)) continue;
                rootsToMark.add(((Integer)oldRoots.second).intValue());
            }
        }
        for (int id : rootsToMark) {
            VirtualFile outputRoot = TranslatingCompilerFilesMonitor.findFileById(id);
            if (outputRoot == null) continue;
            this.processOldOutputRoot(projectId, outputRoot);
        }
    }

    private boolean shouldMark(Integer oldOutputRoot, Integer currentOutputRoot) {
        return oldOutputRoot != null && oldOutputRoot > 0 && !Comparing.equal((Object)oldOutputRoot, (Object)currentOutputRoot);
    }

    private void processOldOutputRoot(int projectId, VirtualFile outputRoot) {
        if (outputRoot.isDirectory()) {
            for (VirtualFile child : outputRoot.getChildren()) {
                this.processOldOutputRoot(projectId, child);
            }
        } else {
            OutputFileInfo outputInfo = TranslatingCompilerFilesMonitor.loadOutputInfo(outputRoot);
            if (outputInfo != null) {
                VirtualFile srcFile;
                String srcPath = outputInfo.getSourceFilePath();
                VirtualFile virtualFile = srcFile = srcPath != null ? LocalFileSystem.getInstance().findFileByPath(srcPath) : null;
                if (srcFile != null) {
                    this.addSourceForRecompilation(projectId, srcFile, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanSourcesForCompilableFiles(final Project project) {
        final int projectId = TranslatingCompilerFilesMonitor.getProjectId(project);
        Object object = this.myInitializationLock;
        synchronized (object) {
            this.myInitInProgress.add(projectId);
            this.myInitializationLock.notifyAll();
        }
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                new Task.Backgroundable(project, CompilerBundle.message((String)"compiler.initial.scanning.progress.text", (Object[])new Object[0]), false){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$8$1.run must not be null");
                        }
                        try {
                            if (project.isDisposed()) {
                                return;
                            }
                            IntermediateOutputCompiler[] compilers = (IntermediateOutputCompiler[])CompilerManager.getInstance((Project)project).getCompilers(IntermediateOutputCompiler.class);
                            HashSet<VirtualFile> intermediateRoots = new HashSet<VirtualFile>();
                            if (compilers.length > 0) {
                                Module[] modules = ModuleManager.getInstance((Project)project).getModules();
                                for (IntermediateOutputCompiler compiler : compilers) {
                                    for (Module module : modules) {
                                        VirtualFile testsOutputRoot;
                                        if (module.isDisposed()) continue;
                                        VirtualFile outputRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(CompilerPaths.getGenerationOutputPath((IntermediateOutputCompiler)compiler, (Module)module, (boolean)false));
                                        if (outputRoot != null) {
                                            intermediateRoots.add(outputRoot);
                                        }
                                        if ((testsOutputRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(CompilerPaths.getGenerationOutputPath((IntermediateOutputCompiler)compiler, (Module)module, (boolean)true))) == null) continue;
                                        intermediateRoots.add(testsOutputRoot);
                                    }
                                }
                            }
                            List<VirtualFile> projectRoots = Arrays.asList(ProjectRootManager.getInstance((Project)project).getContentSourceRoots());
                            int totalRootsCount = projectRoots.size() + intermediateRoots.size();
                            TranslatingCompilerFilesMonitor.this.scanSourceContent(project, projectRoots, totalRootsCount, true);
                            if (!intermediateRoots.isEmpty()) {
                                FileProcessor processor = new FileProcessor(){

                                    @Override
                                    public void execute(VirtualFile file) {
                                        SourceFileInfo srcInfo;
                                        if (!(TranslatingCompilerFilesMonitor.this.isMarkedForRecompilation(projectId, TranslatingCompilerFilesMonitor.getFileId(file)) || (srcInfo = TranslatingCompilerFilesMonitor.loadSourceInfo(file)) != null && srcInfo.getTimestamp(projectId) == file.getTimeStamp())) {
                                            TranslatingCompilerFilesMonitor.this.addSourceForRecompilation(projectId, file, srcInfo);
                                        }
                                    }
                                };
                                int processed = projectRoots.size();
                                for (VirtualFile root : intermediateRoots) {
                                    indicator.setText2(root.getPresentableUrl());
                                    indicator.setFraction((double)(++processed) / (double)totalRootsCount);
                                    TranslatingCompilerFilesMonitor.processRecursively(root, false, processor);
                                }
                            }
                            TranslatingCompilerFilesMonitor.this.markOldOutputRoots(project, (TIntObjectHashMap<Pair<Integer, Integer>>)TranslatingCompilerFilesMonitor.this.buildOutputRootsLayout(project));
                        }
                        finally {
                            Object object = TranslatingCompilerFilesMonitor.this.myInitializationLock;
                            synchronized (object) {
                                if (TranslatingCompilerFilesMonitor.this.myInitInProgress.remove(projectId)) {
                                    TranslatingCompilerFilesMonitor.this.myInitializationLock.notifyAll();
                                }
                            }
                        }
                    }
                }.queue();
            }
        });
    }

    private boolean belongsToIntermediateSources(VirtualFile file, Project project) {
        try {
            return FileUtil.isAncestor((File)((File)this.myGeneratedDataPaths.get((Object)project)), (File)new File(file.getPath()), (boolean)true);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSourceForRecompilation(int projectId, VirtualFile srcFile, @Nullable SourceFileInfo preloadedInfo) {
        boolean alreadyMarked;
        SourceFileInfo srcInfo = preloadedInfo != null ? preloadedInfo : TranslatingCompilerFilesMonitor.loadSourceInfo(srcFile);
        TIntObjectHashMap<TIntHashSet> tIntObjectHashMap = this.mySourcesToRecompile;
        synchronized (tIntObjectHashMap) {
            TIntHashSet set = (TIntHashSet)this.mySourcesToRecompile.get(projectId);
            if (set == null) {
                set = new TIntHashSet();
                this.mySourcesToRecompile.put(projectId, (Object)set);
            }
            boolean bl = alreadyMarked = !set.add(Math.abs(TranslatingCompilerFilesMonitor.getFileId(srcFile)));
            if (!alreadyMarked && LOG.isDebugEnabled()) {
                LOG.debug("Scheduled recompilation " + srcFile.getPresentableUrl());
            }
        }
        if (!alreadyMarked && srcInfo != null) {
            srcInfo.updateTimestamp(projectId, -1L);
            srcInfo.processOutputPaths(projectId, new ScheduleOutputsForDeletionProc(srcFile.getUrl()));
            TranslatingCompilerFilesMonitor.saveSourceInfo(srcFile, srcInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSourceForRecompilation(int projectId, int srcId) {
        TIntObjectHashMap<TIntHashSet> tIntObjectHashMap = this.mySourcesToRecompile;
        synchronized (tIntObjectHashMap) {
            TIntHashSet set = (TIntHashSet)this.mySourcesToRecompile.get(projectId);
            if (set != null) {
                set.remove(srcId);
                if (set.isEmpty()) {
                    this.mySourcesToRecompile.remove(projectId);
                }
            }
        }
    }

    public boolean isMarkedForCompilation(Project project, VirtualFile file) {
        return this.isMarkedForRecompilation(TranslatingCompilerFilesMonitor.getProjectId(project), TranslatingCompilerFilesMonitor.getFileId(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMarkedForRecompilation(int projectId, int srcId) {
        TIntObjectHashMap<TIntHashSet> tIntObjectHashMap = this.mySourcesToRecompile;
        synchronized (tIntObjectHashMap) {
            TIntHashSet set = (TIntHashSet)this.mySourcesToRecompile.get(projectId);
            return set != null && set.contains(srcId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markOutputPathForDeletion(int projectId, String outputPath, String classname, String srcUrl) {
        TIntObjectHashMap<Map<String, SourceUrlClassNamePair>> tIntObjectHashMap = this.myOutputsToDelete;
        synchronized (tIntObjectHashMap) {
            HashMap<String, SourceUrlClassNamePair> map = (HashMap<String, SourceUrlClassNamePair>)this.myOutputsToDelete.get(projectId);
            if (map == null) {
                map = new HashMap<String, SourceUrlClassNamePair>();
                this.myOutputsToDelete.put(projectId, map);
            }
            map.put(outputPath, new SourceUrlClassNamePair(srcUrl, classname));
            if (LOG.isDebugEnabled()) {
                LOG.debug("ADD path to delete: " + outputPath + "; source: " + srcUrl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unmarkOutputPathForDeletion(String outputPath) {
        TIntObjectHashMap<Map<String, SourceUrlClassNamePair>> tIntObjectHashMap = this.myOutputsToDelete;
        synchronized (tIntObjectHashMap) {
            for (int projectId : this.myOutputsToDelete.keys()) {
                SourceUrlClassNamePair val;
                Map map = (Map)this.myOutputsToDelete.get(projectId);
                if (map == null || (val = (SourceUrlClassNamePair)map.remove(outputPath)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("REMOVE path to delete: " + outputPath);
                }
                if (!map.isEmpty()) continue;
                this.myOutputsToDelete.remove(projectId);
            }
        }
    }

    private class ScheduleOutputsForDeletionProc
    implements Proc {
        private final String mySrcUrl;
        private final LocalFileSystem myFileSystem;

        private ScheduleOutputsForDeletionProc(String srcUrl) {
            this.mySrcUrl = srcUrl;
            this.myFileSystem = LocalFileSystem.getInstance();
        }

        @Override
        public boolean execute(int projectId, String outputPath) {
            VirtualFile outFile = this.myFileSystem.findFileByPath(outputPath);
            if (outFile != null) {
                OutputFileInfo outputInfo = TranslatingCompilerFilesMonitor.loadOutputInfo(outFile);
                String classname = outputInfo != null ? outputInfo.getClassName() : null;
                TranslatingCompilerFilesMonitor.this.markOutputPathForDeletion(projectId, outputPath, classname, this.mySrcUrl);
            }
            return true;
        }
    }

    private static interface Proc {
        public boolean execute(int var1, String var2);
    }

    private class MyVfsListener
    extends VirtualFileAdapter {
        private MyVfsListener() {
        }

        public void propertyChanged(VirtualFilePropertyEvent event) {
            if ("name".equals(event.getPropertyName())) {
                this.markDirtyIfSource(event.getFile());
            }
        }

        public void contentsChanged(VirtualFileEvent event) {
            this.markDirtyIfSource(event.getFile());
        }

        public void fileCreated(VirtualFileEvent event) {
            this.processNewFile(event.getFile());
        }

        public void fileCopied(VirtualFileCopyEvent event) {
            this.processNewFile(event.getFile());
        }

        public void fileMoved(VirtualFileMoveEvent event) {
            this.processNewFile(event.getFile());
        }

        public void beforeFileDeletion(VirtualFileEvent event) {
            VirtualFile eventFile = event.getFile();
            if (LOG.isDebugEnabled() && eventFile.isDirectory()) {
                LOG.debug("Processing file deletion: " + eventFile.getPresentableUrl());
            }
            TranslatingCompilerFilesMonitor.processRecursively(eventFile, true, new FileProcessor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute(VirtualFile file) {
                    String filePath = file.getPath();
                    try {
                        TIntHashSet projects;
                        SourceFileInfo srcInfo;
                        OutputFileInfo outputInfo = TranslatingCompilerFilesMonitor.loadOutputInfo(file);
                        if (outputInfo != null) {
                            SourceFileInfo srcInfo2;
                            VirtualFile srcFile;
                            String srcPath = outputInfo.getSourceFilePath();
                            VirtualFile virtualFile = srcFile = srcPath != null ? LocalFileSystem.getInstance().findFileByPath(srcPath) : null;
                            if (srcFile != null && (srcInfo2 = TranslatingCompilerFilesMonitor.loadSourceInfo(srcFile)) != null) {
                                for (int projectId : srcInfo2.getProjectIds().toArray()) {
                                    if (!srcInfo2.isAssociated(projectId, filePath)) continue;
                                    TranslatingCompilerFilesMonitor.this.addSourceForRecompilation(projectId, srcFile, srcInfo2);
                                }
                            }
                        }
                        if ((srcInfo = TranslatingCompilerFilesMonitor.loadSourceInfo(file)) != null && !(projects = srcInfo.getProjectIds()).isEmpty()) {
                            ScheduleOutputsForDeletionProc deletionProc = new ScheduleOutputsForDeletionProc(file.getUrl());
                            for (int projectId : projects.toArray()) {
                                srcInfo.processOutputPaths(projectId, deletionProc);
                                TranslatingCompilerFilesMonitor.this.removeSourceForRecompilation(projectId, TranslatingCompilerFilesMonitor.getFileId(file));
                            }
                        }
                    }
                    finally {
                        TranslatingCompilerFilesMonitor.this.unmarkOutputPathForDeletion(filePath);
                    }
                }
            });
        }

        public void beforeFileMovement(VirtualFileMoveEvent event) {
            this.markDirtyIfSource(event.getFile());
        }

        private void markDirtyIfSource(VirtualFile file) {
            TranslatingCompilerFilesMonitor.processRecursively(file, false, new FileProcessor(){

                @Override
                public void execute(VirtualFile file) {
                    SourceFileInfo srcInfo;
                    SourceFileInfo sourceFileInfo = srcInfo = file.isValid() ? TranslatingCompilerFilesMonitor.loadSourceInfo(file) : null;
                    if (srcInfo != null) {
                        for (int projectId : srcInfo.getProjectIds().toArray()) {
                            TranslatingCompilerFilesMonitor.this.addSourceForRecompilation(projectId, file, srcInfo);
                        }
                    } else {
                        MyVfsListener.this.processNewFile(file);
                    }
                }
            });
        }

        private void processNewFile(final VirtualFile file) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    for (Project project : TranslatingCompilerFilesMonitor.this.myProjectManager.getOpenProjects()) {
                        if (!project.isInitialized()) continue;
                        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
                        final int projectId = TranslatingCompilerFilesMonitor.getProjectId(project);
                        if (rootManager.getFileIndex().isInSourceContent(file)) {
                            final TranslatingCompiler[] translators = (TranslatingCompiler[])CompilerManager.getInstance((Project)project).getCompilers(TranslatingCompiler.class);
                            TranslatingCompilerFilesMonitor.processRecursively(file, false, new FileProcessor(){

                                @Override
                                public void execute(VirtualFile file) {
                                    if (this.isCompilable(file)) {
                                        TranslatingCompilerFilesMonitor.this.addSourceForRecompilation(projectId, file, null);
                                    }
                                }

                                boolean isCompilable(VirtualFile file) {
                                    for (TranslatingCompiler translator : translators) {
                                        if (!translator.isCompilableFile(file, (CompileContext)DummyCompileContext.getInstance())) continue;
                                        return true;
                                    }
                                    return false;
                                }
                            });
                            continue;
                        }
                        if (!TranslatingCompilerFilesMonitor.this.belongsToIntermediateSources(file, project)) continue;
                        TranslatingCompilerFilesMonitor.processRecursively(file, false, new FileProcessor(){

                            @Override
                            public void execute(VirtualFile file) {
                                TranslatingCompilerFilesMonitor.this.addSourceForRecompilation(projectId, file, null);
                            }
                        });
                    }
                }
            });
        }
    }

    private class MyProjectManagerListener
    extends ProjectManagerAdapter {
        final Map<Project, MessageBusConnection> myConnections = new HashMap<Project, MessageBusConnection>();

        private MyProjectManagerListener() {
        }

        public void projectOpened(final Project project) {
            MessageBusConnection conn = project.getMessageBus().connect();
            this.myConnections.put(project, conn);
            conn.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
                private VirtualFile[] myRootsBefore;

                public void beforeRootsChange(ModuleRootEvent event) {
                    this.myRootsBefore = ProjectRootManager.getInstance((Project)project).getContentSourceRoots();
                }

                public void rootsChanged(ModuleRootEvent event) {
                    VirtualFile[] rootsAfter = ProjectRootManager.getInstance((Project)project).getContentSourceRoots();
                    HashSet<VirtualFile> newRoots = new HashSet<VirtualFile>();
                    newRoots.addAll(Arrays.asList(rootsAfter));
                    if (this.myRootsBefore != null) {
                        newRoots.removeAll(Arrays.asList(this.myRootsBefore));
                    }
                    TranslatingCompilerFilesMonitor.this.scanSourceContent(project, newRoots, newRoots.size(), true);
                    HashSet<VirtualFile> oldRoots = new HashSet<VirtualFile>();
                    if (this.myRootsBefore != null) {
                        oldRoots.addAll(Arrays.asList(this.myRootsBefore));
                    }
                    if (!oldRoots.isEmpty()) {
                        oldRoots.removeAll(Arrays.asList(rootsAfter));
                    }
                    TranslatingCompilerFilesMonitor.this.scanSourceContent(project, oldRoots, oldRoots.size(), false);
                    this.myRootsBefore = null;
                    TranslatingCompilerFilesMonitor.this.markOldOutputRoots(project, (TIntObjectHashMap<Pair<Integer, Integer>>)TranslatingCompilerFilesMonitor.this.buildOutputRootsLayout(project));
                }
            });
            TranslatingCompilerFilesMonitor.this.scanSourcesForCompilableFiles(project);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void projectClosed(Project project) {
            int projectId = TranslatingCompilerFilesMonitor.getProjectId(project);
            Object object = TranslatingCompilerFilesMonitor.this.myInitializationLock;
            synchronized (object) {
                if (TranslatingCompilerFilesMonitor.this.myInitInProgress.remove(projectId)) {
                    TranslatingCompilerFilesMonitor.this.myInitializationLock.notifyAll();
                }
            }
            this.myConnections.remove(project).disconnect();
            object = TranslatingCompilerFilesMonitor.this.mySourcesToRecompile;
            synchronized (object) {
                TranslatingCompilerFilesMonitor.this.mySourcesToRecompile.remove(projectId);
            }
        }
    }

    private static interface FileProcessor {
        public void execute(VirtualFile var1);
    }

    private static class SourceFileInfo {
        private TIntLongHashMap myTimestamps;
        private TIntObjectHashMap<Serializable> myProjectToOutputPathMap;

        private SourceFileInfo() {
        }

        private SourceFileInfo(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$SourceFileInfo.<init> must not be null");
            }
            int projCount = in.readInt();
            for (int idx = 0; idx < projCount; ++idx) {
                int projectId = in.readInt();
                long stamp = in.readLong();
                this.updateTimestamp(projectId, stamp);
                int pathsCount = in.readInt();
                for (int i = 0; i < pathsCount; ++i) {
                    int path = in.readInt();
                    this.addOutputPath(projectId, path);
                }
            }
        }

        public void save(final @NotNull DataOutput out) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$SourceFileInfo.save must not be null");
            }
            int[] projects = this.getProjectIds().toArray();
            out.writeInt(projects.length);
            for (int projectId : projects) {
                Serializable value;
                out.writeInt(projectId);
                out.writeLong(this.getTimestamp(projectId));
                Serializable serializable = value = this.myProjectToOutputPathMap != null ? (Serializable)this.myProjectToOutputPathMap.get(projectId) : null;
                if (value instanceof Integer) {
                    out.writeInt(1);
                    out.writeInt((Integer)value);
                    continue;
                }
                if (value instanceof TIntHashSet) {
                    TIntHashSet set = (TIntHashSet)value;
                    out.writeInt(set.size());
                    final IOException[] ex = new IOException[]{null};
                    set.forEach(new TIntProcedure(){

                        public boolean execute(int value) {
                            try {
                                out.writeInt(value);
                                return true;
                            }
                            catch (IOException e) {
                                ex[0] = e;
                                return false;
                            }
                        }
                    });
                    if (ex[0] == null) continue;
                    throw ex[0];
                }
                out.writeInt(0);
            }
        }

        private void updateTimestamp(int projectId, long stamp) {
            if (stamp > 0L) {
                if (this.myTimestamps == null) {
                    this.myTimestamps = new TIntLongHashMap(1, 0.98f);
                }
                this.myTimestamps.put(projectId, stamp);
            } else if (this.myTimestamps != null) {
                this.myTimestamps.remove(projectId);
            }
        }

        TIntHashSet getProjectIds() {
            TIntHashSet result = new TIntHashSet();
            if (this.myTimestamps != null) {
                result.addAll(this.myTimestamps.keys());
            }
            if (this.myProjectToOutputPathMap != null) {
                result.addAll(this.myProjectToOutputPathMap.keys());
            }
            return result;
        }

        private void addOutputPath(int projectId, String outputPath) {
            try {
                this.addOutputPath(projectId, FSRecords.getNames().enumerate((Object)outputPath));
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }

        private void addOutputPath(int projectId, int outputPath) {
            if (this.myProjectToOutputPathMap == null) {
                this.myProjectToOutputPathMap = new TIntObjectHashMap(1, 0.98f);
                this.myProjectToOutputPathMap.put(projectId, (Object)outputPath);
            } else {
                Object val = this.myProjectToOutputPathMap.get(projectId);
                if (val == null) {
                    this.myProjectToOutputPathMap.put(projectId, (Object)outputPath);
                } else {
                    TIntHashSet set;
                    if (val instanceof Integer) {
                        set = new TIntHashSet();
                        set.add(((Integer)val).intValue());
                        this.myProjectToOutputPathMap.put(projectId, (Object)set);
                    } else {
                        assert (val instanceof TIntHashSet);
                        set = (TIntHashSet)val;
                    }
                    set.add(outputPath);
                }
            }
        }

        public void clearPaths(int projectId) {
            if (this.myProjectToOutputPathMap != null) {
                this.myProjectToOutputPathMap.remove(projectId);
            }
        }

        long getTimestamp(int projectId) {
            return this.myTimestamps == null ? -1L : this.myTimestamps.get(projectId);
        }

        void processOutputPaths(final int projectId, final Proc proc) {
            if (this.myProjectToOutputPathMap != null) {
                try {
                    final PersistentStringEnumerator symtable = FSRecords.getNames();
                    Object val = this.myProjectToOutputPathMap.get(projectId);
                    if (val instanceof Integer) {
                        proc.execute(projectId, (String)symtable.valueOf(((Integer)val).intValue()));
                    } else if (val instanceof TIntHashSet) {
                        ((TIntHashSet)val).forEach(new TIntProcedure(){

                            public boolean execute(int value) {
                                try {
                                    proc.execute(projectId, (String)symtable.valueOf(value));
                                    return true;
                                }
                                catch (IOException e) {
                                    LOG.info((Throwable)e);
                                    return false;
                                }
                            }
                        });
                    }
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }

        boolean isAssociated(int projectId, String outputPath) {
            if (this.myProjectToOutputPathMap != null) {
                try {
                    Object val = this.myProjectToOutputPathMap.get(projectId);
                    if (val instanceof Integer) {
                        return FileUtil.pathsEqual((String)outputPath, (String)((String)FSRecords.getNames().valueOf(((Integer)val).intValue())));
                    }
                    if (val instanceof TIntHashSet) {
                        int _outputPath = FSRecords.getNames().enumerate((Object)outputPath);
                        return ((TIntHashSet)val).contains(_outputPath);
                    }
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
            return false;
        }
    }

    private static class OutputFileInfo {
        private final int mySourcePath;
        private final int myClassName;

        OutputFileInfo(String sourcePath, @Nullable String className) throws IOException {
            PersistentStringEnumerator symtable = FSRecords.getNames();
            this.mySourcePath = symtable.enumerate((Object)sourcePath);
            this.myClassName = className != null ? symtable.enumerate((Object)className) : -1;
        }

        OutputFileInfo(DataInput in) throws IOException {
            this.mySourcePath = in.readInt();
            this.myClassName = in.readInt();
        }

        String getSourceFilePath() {
            try {
                return (String)FSRecords.getNames().valueOf(this.mySourcePath);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                return null;
            }
        }

        @Nullable
        public String getClassName() {
            try {
                return this.myClassName < 0 ? null : (String)FSRecords.getNames().valueOf(this.myClassName);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                return null;
            }
        }

        public void save(DataOutput out) throws IOException {
            out.writeInt(this.mySourcePath);
            out.writeInt(this.myClassName);
        }
    }
}

