/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classParsing;

import com.intellij.compiler.classParsing.AnnotationConstantValue;
import com.intellij.compiler.classParsing.AnnotationPrimitiveConstantValue;
import com.intellij.compiler.classParsing.ClassInfoConstantValue;
import com.intellij.compiler.classParsing.ConstantValue;
import com.intellij.compiler.classParsing.ConstantValueArray;
import com.intellij.compiler.classParsing.DoubleConstantValue;
import com.intellij.compiler.classParsing.EnumConstantValue;
import com.intellij.compiler.classParsing.FieldInfo;
import com.intellij.compiler.classParsing.FloatConstantValue;
import com.intellij.compiler.classParsing.IntegerConstantValue;
import com.intellij.compiler.classParsing.LongConstantValue;
import com.intellij.compiler.classParsing.MemberInfo;
import com.intellij.compiler.classParsing.MemberReferenceInfo;
import com.intellij.compiler.classParsing.MethodInfo;
import com.intellij.compiler.classParsing.ReferenceInfo;
import com.intellij.compiler.classParsing.StringConstantValue;
import com.intellij.openapi.diagnostic.Logger;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MemberInfoExternalizer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.classParsing.MemberInfoExternalizer");
    public static final byte FIELD_INFO_TAG = 1;
    public static final byte METHOD_INFO_TAG = 2;
    public static final byte DECLARATION_INFO_TAG = 9;
    public static final byte REFERENCE_INFO_TAG = 11;
    public static final byte MEMBER_REFERENCE_INFO_TAG = 12;
    public static final byte LONG_CONSTANT_TAG = 3;
    public static final byte FLOAT_CONSTANT_TAG = 4;
    public static final byte DOUBLE_CONSTANT_TAG = 5;
    public static final byte INTEGER_CONSTANT_TAG = 6;
    public static final byte STRING_CONSTANT_TAG = 7;
    public static final byte CONSTANT_TAG = 8;
    public static final byte ANNOTATION_CONSTANT_TAG = 13;
    public static final byte ANNOTATION_PRIMITIVE_CONSTANT_TAG = 14;
    public static final byte CONSTANT_VALUE_ARRAY_TAG = 15;
    public static final byte CLASS_CONSTANT_VALUE_TAG = 16;
    public static final byte ENUM_CONSTANT_VALUE_TAG = 17;

    public static MemberInfo loadMemberInfo(DataInput in) throws IOException {
        byte tag = in.readByte();
        if (tag == 2) {
            return new MethodInfo(in);
        }
        if (tag == 1) {
            return new FieldInfo(in);
        }
        LOG.error("Unknown member info");
        return null;
    }

    public static ReferenceInfo loadReferenceInfo(DataInput in) throws IOException {
        byte tag = in.readByte();
        if (tag == 11) {
            return new ReferenceInfo(in);
        }
        if (tag == 12) {
            return new MemberReferenceInfo(in);
        }
        LOG.error("Unknown declaration info tag: " + tag);
        return null;
    }

    public static ConstantValue loadConstantValue(DataInput in) throws IOException {
        byte tag = in.readByte();
        if (tag == 3) {
            return new LongConstantValue(in);
        }
        if (tag == 4) {
            return new FloatConstantValue(in);
        }
        if (tag == 5) {
            return new DoubleConstantValue(in);
        }
        if (tag == 6) {
            return new IntegerConstantValue(in);
        }
        if (tag == 7) {
            return new StringConstantValue(in);
        }
        if (tag == 8) {
            return ConstantValue.EMPTY_CONSTANT_VALUE;
        }
        if (tag == 13) {
            return new AnnotationConstantValue(in);
        }
        if (tag == 14) {
            return new AnnotationPrimitiveConstantValue(in);
        }
        if (tag == 15) {
            return new ConstantValueArray(in);
        }
        if (tag == 16) {
            return new ClassInfoConstantValue(in);
        }
        if (tag == 17) {
            return new EnumConstantValue(in);
        }
        LOG.error("Unknown constant value type " + tag);
        return null;
    }

    public static void saveMemberInfo(DataOutput out, MemberInfo info) throws IOException {
        if (info instanceof MethodInfo) {
            out.writeByte(2);
        } else if (info instanceof FieldInfo) {
            out.writeByte(1);
        } else {
            LOG.error("Unknown member info");
        }
        info.save(out);
    }

    public static void saveReferenceInfo(DataOutput out, ReferenceInfo info) throws IOException {
        if (info instanceof MemberReferenceInfo) {
            out.writeByte(12);
        } else {
            out.writeByte(11);
        }
        info.save(out);
    }

    public static void saveConstantValue(DataOutput out, ConstantValue value) throws IOException {
        if (value instanceof LongConstantValue) {
            out.writeByte(3);
        } else if (value instanceof FloatConstantValue) {
            out.writeByte(4);
        } else if (value instanceof DoubleConstantValue) {
            out.writeByte(5);
        } else if (value instanceof IntegerConstantValue) {
            out.writeByte(6);
        } else if (value instanceof StringConstantValue) {
            out.writeByte(7);
        } else if (value instanceof AnnotationConstantValue) {
            out.writeByte(13);
        } else if (value instanceof AnnotationPrimitiveConstantValue) {
            out.writeByte(14);
        } else if (value instanceof ConstantValueArray) {
            out.writeByte(15);
        } else if (value instanceof ClassInfoConstantValue) {
            out.writeByte(16);
        } else if (value instanceof EnumConstantValue) {
            out.writeByte(17);
        } else {
            out.writeByte(8);
        }
        if (value != null) {
            value.save(out);
        }
    }

    public static AnnotationConstantValue[] readAnnotationConstantValueArray1(DataInput in) throws IOException {
        int size = in.readInt();
        AnnotationConstantValue[] array = size > 0 ? new AnnotationConstantValue[size] : AnnotationConstantValue.EMPTY_ARRAY;
        for (int idx = 0; idx < size; ++idx) {
            array[idx] = (AnnotationConstantValue)MemberInfoExternalizer.loadConstantValue(in);
        }
        return array;
    }

    public static AnnotationConstantValue[][] readAnnotationConstantValueArray2(DataInput in) throws IOException {
        int size = in.readInt();
        AnnotationConstantValue[][] array = size > 0 ? new AnnotationConstantValue[size][] : AnnotationConstantValue.EMPTY_ARRAY_ARRAY;
        for (int idx = 0; idx < size; ++idx) {
            array[idx] = MemberInfoExternalizer.readAnnotationConstantValueArray1(in);
        }
        return array;
    }

    public static void writeConstantValueArray1(DataOutput writer, ConstantValue[] array) throws IOException {
        if (array != null && array.length > 0) {
            writer.writeInt(array.length);
            for (ConstantValue value : array) {
                MemberInfoExternalizer.saveConstantValue(writer, value);
            }
        } else {
            writer.writeInt(0);
        }
    }

    public static void writeConstantValueArray2(DataOutput writer, ConstantValue[][] array) throws IOException {
        if (array != null && array.length > 0) {
            writer.writeInt(array.length);
            for (ConstantValue[] aArray : array) {
                MemberInfoExternalizer.writeConstantValueArray1(writer, aArray);
            }
        } else {
            writer.writeInt(0);
        }
    }
}

