/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.ClassUtil;
import org.jetbrains.annotations.NonNls;
import org.objectweb.asm.ClassWriter;

public class PsiClassWriter
extends ClassWriter {
    private final Project myProject;

    public PsiClassWriter(Project project, boolean isJava6) {
        super(isJava6 ? 2 : 1);
        this.myProject = project;
    }

    public PsiClassWriter(Module module) {
        this(module.getProject(), PsiClassWriter.isJdk6(module));
    }

    private static boolean isJdk6(Module module) {
        Sdk projectJdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (projectJdk == null) {
            return false;
        }
        String versionString = projectJdk.getVersionString();
        return versionString.contains("1.6") || versionString.contains("6.0");
    }

    protected String getCommonSuperClass(final String type1, final String type2) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @NonNls
            public String compute() {
                PsiManager manager = PsiManager.getInstance((Project)PsiClassWriter.this.myProject);
                PsiClass c = ClassUtil.findPsiClassByJVMName((PsiManager)manager, (String)type1);
                if (c == null) {
                    return "java/lang/Object";
                }
                PsiClass d = ClassUtil.findPsiClassByJVMName((PsiManager)manager, (String)type2);
                if (d == null) {
                    return "java/lang/Object";
                }
                if (c.isInheritor(d, true)) {
                    return ClassUtil.getJVMClassName((PsiClass)d).replace('.', '/');
                }
                if (d.isInheritor(c, true)) {
                    return ClassUtil.getJVMClassName((PsiClass)c).replace('.', '/');
                }
                if (c.isInterface() || d.isInterface()) {
                    return "java/lang/Object";
                }
                while ((c = c.getSuperClass()) != null && !d.isInheritor(c, true)) {
                }
                if (c == null) {
                    return "java/lang/Object";
                }
                return ClassUtil.getJVMClassName((PsiClass)c).replace('.', '/');
            }
        });
    }
}

