/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.suspiciousNameCombination;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.BaseLocalInspectionTool;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.AddDeleteListPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousNameCombinationInspection
extends BaseLocalInspectionTool {
    private final List<String> myNameGroups = new ArrayList<String>();
    private final Map<String, String> myWordToGroupMap = new HashMap<String, String>();
    @NonNls
    private static final String ELEMENT_GROUPS = "group";
    @NonNls
    private static final String ATTRIBUTE_NAMES = "names";

    public SuspiciousNameCombinationInspection() {
        this.addNameGroup("x,width,left,right");
        this.addNameGroup("y,height,top,bottom");
    }

    private void clearNameGroups() {
        this.myNameGroups.clear();
        this.myWordToGroupMap.clear();
    }

    private void addNameGroup(@NonNls String group) {
        this.myNameGroups.add(group);
        List words = StringUtil.split((String)group, (String)",");
        for (String word : words) {
            this.myWordToGroupMap.put(word.trim().toLowerCase(), group);
        }
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"suspicious.name.combination.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SuspiciousNameCombination" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspection.getShortName must not return null");
        }
        return "SuspiciousNameCombination";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspection.buildVisitor must not be null");
        }
        MyVisitor myVisitor = new MyVisitor(holder);
        if (myVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspection.buildVisitor must not return null");
        }
        return myVisitor;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new MyOptionsPanel();
    }

    public void readSettings(Element node) throws InvalidDataException {
        this.clearNameGroups();
        for (Object o : node.getChildren(ELEMENT_GROUPS)) {
            Element e = (Element)o;
            this.addNameGroup(e.getAttributeValue(ATTRIBUTE_NAMES));
        }
    }

    public void writeSettings(Element node) throws WriteExternalException {
        for (String group : this.myNameGroups) {
            Element e = new Element(ELEMENT_GROUPS);
            node.addContent(e);
            e.setAttribute(ATTRIBUTE_NAMES, group);
        }
    }

    private class MyOptionsPanel
    extends AddDeleteListPanel {
        private JButton myEditButton;

        public MyOptionsPanel() {
            super(InspectionsBundle.message((String)"suspicious.name.combination.options.title", (Object[])new Object[0]), SuspiciousNameCombinationInspection.this.myNameGroups);
            this.myEditButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyOptionsPanel.this.editSelectedItem();
                }
            });
            this.myList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        MyOptionsPanel.this.editSelectedItem();
                    }
                }
            });
            this.myListModel.addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                    MyOptionsPanel.this.saveChanges();
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    MyOptionsPanel.this.saveChanges();
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                    MyOptionsPanel.this.saveChanges();
                }
            });
        }

        protected JButton[] createButtons() {
            this.myEditButton = new JButton(CommonBundle.message((String)"button.edit", (Object[])new Object[0]));
            return new JButton[]{this.myAddButton, this.myEditButton, this.myDeleteButton};
        }

        protected Object findItemToAdd() {
            return Messages.showInputDialog((Component)((Object)this), (String)InspectionsBundle.message((String)"suspicious.name.combination.options.prompt", (Object[])new Object[0]), (String)InspectionsBundle.message((String)"suspicious.name.combination.add.titile", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)"", null);
        }

        private void editSelectedItem() {
            int index = this.myList.getSelectedIndex();
            if (index >= 0) {
                String inputValue = (String)this.myListModel.get(index);
                String newValue = Messages.showInputDialog((Component)((Object)this), (String)InspectionsBundle.message((String)"suspicious.name.combination.options.prompt", (Object[])new Object[0]), (String)InspectionsBundle.message((String)"suspicious.name.combination.edit.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)inputValue, null);
                if (newValue != null) {
                    this.myListModel.set(index, newValue);
                }
            }
        }

        private void saveChanges() {
            SuspiciousNameCombinationInspection.this.clearNameGroups();
            for (int i = 0; i < this.myListModel.getSize(); ++i) {
                SuspiciousNameCombinationInspection.this.addNameGroup((String)this.myListModel.getElementAt(i));
            }
        }
    }

    private class MyVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myProblemsHolder;

        public MyVisitor(ProblemsHolder problemsHolder) {
            this.myProblemsHolder = problemsHolder;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
        }

        public void visitVariable(PsiVariable variable) {
            PsiExpression expr;
            if (variable.hasInitializer() && (expr = variable.getInitializer()) instanceof PsiReferenceExpression) {
                PsiReferenceExpression refExpr = (PsiReferenceExpression)expr;
                this.checkCombination((PsiElement)variable, variable.getName(), refExpr.getReferenceName(), "suspicious.name.assignment");
            }
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            PsiExpression lhs = expression.getLExpression();
            PsiExpression rhs = expression.getRExpression();
            if (lhs instanceof PsiReferenceExpression && rhs instanceof PsiReferenceExpression) {
                PsiReferenceExpression lhsExpr = (PsiReferenceExpression)lhs;
                PsiReferenceExpression rhsExpr = (PsiReferenceExpression)rhs;
                this.checkCombination((PsiElement)lhsExpr, lhsExpr.getReferenceName(), rhsExpr.getReferenceName(), "suspicious.name.assignment");
            }
        }

        public void visitCallExpression(PsiCallExpression expression) {
            PsiMethod psiMethod = expression.resolveMethod();
            PsiExpressionList argList = expression.getArgumentList();
            if (psiMethod != null && argList != null) {
                PsiExpression[] args = argList.getExpressions();
                PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                for (int i = 0; i < parameters.length && i < args.length; ++i) {
                    String refName;
                    if (!(args[i] instanceof PsiReferenceExpression) || this.findNameGroup(refName = ((PsiReferenceExpression)args[i]).getReferenceName()) == null) continue;
                    this.checkCombination((PsiElement)args[i], parameters[i].getName(), refName, "suspicious.name.parameter");
                }
            }
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiExpression returnValue = statement.getReturnValue();
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)returnValue, PsiMethod.class);
            if (returnValue instanceof PsiReferenceExpression && containingMethod != null) {
                String refName = ((PsiReferenceExpression)returnValue).getReferenceName();
                this.checkCombination((PsiElement)returnValue, containingMethod.getName(), refName, "suspicious.name.return");
            }
        }

        private void checkCombination(PsiElement location, @Nullable String name, @Nullable String referenceName, String key) {
            String nameGroup1 = this.findNameGroup(name);
            String nameGroup2 = this.findNameGroup(referenceName);
            if (nameGroup1 != null && nameGroup2 != null && !nameGroup1.equals(nameGroup2)) {
                this.myProblemsHolder.registerProblem(location, JavaErrorMessages.message(key, referenceName, name), new LocalQuickFix[0]);
            }
        }

        @Nullable
        private String findNameGroup(@Nullable String name) {
            if (name == null) {
                return null;
            }
            String[] words = NameUtil.splitNameIntoWords((String)name);
            String result = null;
            for (String word : words) {
                String group = (String)SuspiciousNameCombinationInspection.this.myWordToGroupMap.get(word.toLowerCase());
                if (group == null) continue;
                if (result == null) {
                    result = group;
                    continue;
                }
                if (result.equals(group)) continue;
                result = null;
                break;
            }
            return result;
        }
    }
}

