/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModuleImpl;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;

public class RefDirectoryImpl
extends RefElementImpl
implements RefDirectory {
    protected RefDirectoryImpl(PsiDirectory psiElement, RefManager refManager) {
        super(psiElement.getName(), (PsiElement)psiElement, refManager);
        RefModuleImpl refModule;
        RefElementImpl refElement;
        PsiDirectory parentDirectory = psiElement.getParentDirectory();
        if (parentDirectory != null && PsiManager.getInstance((Project)parentDirectory.getProject()).isInProject((PsiElement)parentDirectory) && (refElement = (RefElementImpl)refManager.getReference((PsiElement)parentDirectory)) != null) {
            refElement.add(this);
            return;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)psiElement);
        if (module != null && (refModule = (RefModuleImpl)refManager.getRefModule(module)) != null) {
            refModule.add(this);
            return;
        }
        ((RefProjectImpl)refManager.getRefProject()).add(this);
    }

    @Override
    public void accept(final RefVisitor visitor) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                visitor.visitDirectory((RefDirectory)RefDirectoryImpl.this);
            }
        });
    }

    @Override
    protected void initialize() {
        this.getRefManager().fireNodeInitialized(this);
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public String getExternalName() {
        PsiElement element = this.getElement();
        assert (element != null);
        return ((PsiDirectory)element).getVirtualFile().getPath();
    }
}

