/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.miscGenerics.GenericsInspectionToolBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RedundantTypeArgsInspection
extends GenericsInspectionToolBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.miscGenerics.RedundantTypeArgsInspection");
    private final LocalQuickFix myQuickFixAction = new MyQuickFixAction();

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.VERBOSE_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.redundant.type.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("RedundantTypeArguments" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection.getShortName must not return null");
        }
        return "RedundantTypeArguments";
    }

    @Override
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiMethod == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection.checkMethod must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection.checkMethod must not be null");
        }
        PsiCodeBlock body = psiMethod.getBody();
        if (body != null) {
            return this.getDescriptions((PsiElement)body, manager, isOnTheFly);
        }
        return null;
    }

    @Override
    public ProblemDescriptor[] getDescriptions(PsiElement place, final InspectionManager inspectionManager, boolean isOnTheFly) {
        final ArrayList problems = new ArrayList();
        place.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiType[] typeArguments = expression.getTypeArguments();
                if (typeArguments.length > 0) {
                    this.checkCallExpression((PsiJavaCodeReferenceElement)expression.getMethodExpression(), typeArguments, (PsiCallExpression)expression, inspectionManager, problems);
                }
            }

            public void visitNewExpression(PsiNewExpression expression) {
                PsiJavaCodeReferenceElement classReference;
                PsiType[] typeArguments = expression.getTypeArguments();
                if (typeArguments.length > 0 && (classReference = expression.getClassReference()) != null) {
                    this.checkCallExpression(classReference, typeArguments, (PsiCallExpression)expression, inspectionManager, problems);
                }
            }

            private void checkCallExpression(PsiJavaCodeReferenceElement reference, PsiType[] typeArguments, PsiCallExpression expression, InspectionManager inspectionManager2, List<ProblemDescriptor> problems2) {
                PsiMethod method;
                PsiTypeParameter[] typeParameters;
                PsiExpressionList argumentList = expression.getArgumentList();
                if (argumentList == null) {
                    return;
                }
                JavaResolveResult resolveResult = reference.advancedResolve(false);
                PsiElement element = resolveResult.getElement();
                if (element instanceof PsiMethod && resolveResult.isValidResult() && (typeParameters = (method = (PsiMethod)element).getTypeParameters()).length == typeArguments.length) {
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)expression.getProject()).getResolveHelper();
                    for (int i = 0; i < typeParameters.length; ++i) {
                        PsiTypeParameter typeParameter = typeParameters[i];
                        PsiType inferedType = resolveHelper.inferTypeForMethodTypeParameter(typeParameter, parameters, argumentList.getExpressions(), resolveResult.getSubstitutor(), (PsiElement)expression, false);
                        if (typeArguments[i].equals(inferedType)) continue;
                        return;
                    }
                    PsiCallExpression copy = (PsiCallExpression)expression.copy();
                    try {
                        copy.getTypeArgumentList().delete();
                        if (copy.resolveMethod() != element) {
                            return;
                        }
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                        return;
                    }
                    ProblemDescriptor descriptor = inspectionManager2.createProblemDescriptor((PsiElement)expression.getTypeArgumentList(), InspectionsBundle.message((String)"inspection.redundant.type.problem.descriptor", (Object[])new Object[0]), RedundantTypeArgsInspection.this.myQuickFixAction, ProblemHighlightType.LIKE_UNUSED_SYMBOL, false);
                    problems2.add(descriptor);
                }
            }
        });
        if (problems.isEmpty()) {
            return null;
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private static class MyQuickFixAction
    implements LocalQuickFix {
        private MyQuickFixAction() {
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.type.remove.quickfix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction.getName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction.applyFix must not be null");
            }
            PsiReferenceParameterList typeArgumentList = (PsiReferenceParameterList)descriptor.getPsiElement();
            try {
                PsiMethodCallExpression expr = (PsiMethodCallExpression)JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionFromText("foo()", null);
                typeArgumentList.replace((PsiElement)expr.getTypeArgumentList());
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction.getFamilyName must not return null");
            }
            return string;
        }
    }
}

