/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditInspectionToolsSettingsInSuppressedPlaceIntention
implements IntentionAction {
    private String myId;
    private String myDisplayName;

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"edit.options.of.reporter.inspection.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/EditInspectionToolsSettingsInSuppressedPlaceIntention.getFamilyName must not return null");
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = InspectionsBundle.message((String)"edit.inspection.options", (Object[])new Object[]{this.myDisplayName});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/EditInspectionToolsSettingsInSuppressedPlaceIntention.getText must not return null");
        }
        return string;
    }

    @Nullable
    private static String getSuppressedId(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        for (PsiElement element = file.findElementAt(offset); element != null && !(element instanceof PsiFile); element = element.getParent()) {
            for (InspectionExtensionsFactory factory : (InspectionExtensionsFactory[])Extensions.getExtensions((ExtensionPointName)InspectionExtensionsFactory.EP_NAME)) {
                String suppressedIds = factory.getSuppressedInspectionIdsIn(element);
                if (suppressedIds == null) continue;
                String text = element.getText();
                List ids = StringUtil.split((String)suppressedIds, (String)",");
                for (String id : ids) {
                    int idOffset;
                    int i = text.indexOf(id);
                    if (i == -1 || !TextRange.from((int)(idOffset = element.getTextRange().getStartOffset() + i), (int)id.length()).contains(offset)) continue;
                    return id;
                }
            }
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/EditInspectionToolsSettingsInSuppressedPlaceIntention.isAvailable must not be null");
        }
        this.myId = EditInspectionToolsSettingsInSuppressedPlaceIntention.getSuppressedId(editor, file);
        if (this.myId != null) {
            InspectionProfileEntry tool = this.getTool(project, file);
            if (tool == null) {
                return false;
            }
            this.myDisplayName = tool.getDisplayName();
        }
        return this.myId != null;
    }

    @Nullable
    private InspectionProfileEntry getTool(Project project, PsiFile file) {
        InspectionProjectProfileManager projectProfileManager = InspectionProjectProfileManager.getInstance(project);
        InspectionProfileImpl inspectionProfile = (InspectionProfileImpl)projectProfileManager.getInspectionProfile();
        return inspectionProfile.getToolById(this.myId, (PsiElement)file);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/EditInspectionToolsSettingsInSuppressedPlaceIntention.invoke must not be null");
        }
        InspectionProfileEntry tool = this.getTool(project, file);
        if (tool == null) {
            return;
        }
        InspectionProjectProfileManager projectProfileManager = InspectionProjectProfileManager.getInstance(project);
        InspectionProfileImpl inspectionProfile = (InspectionProfileImpl)projectProfileManager.getInspectionProfile();
        EditInspectionToolsSettingsAction.editToolSettings(project, inspectionProfile, false, tool.getShortName());
    }

    public boolean startInWriteAction() {
        return false;
    }
}

