/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.equalsAndHashcode;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.MethodSignatureUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualsAndHashcode
extends BaseJavaLocalInspectionTool {
    private PsiMethod myHashCode;
    private PsiMethod myEquals;
    private JavaPsiFacade myPsiFacade;
    private final AtomicBoolean myInitialized = new AtomicBoolean();

    public void projectOpened(Project project) {
        this.myPsiFacade = JavaPsiFacade.getInstance((Project)project);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Object object;
        PsiClass psiObjectClass;
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcode.buildVisitor must not be null");
        }
        if (!this.myInitialized.getAndSet(true) && (psiObjectClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            @Nullable
            public PsiClass compute() {
                return EqualsAndHashcode.this.myPsiFacade.findClass("java.lang.Object");
            }
        })) != null) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = psiObjectClass.getMethods()) {
                String name = method.getName();
                if ("equals".equals(name)) {
                    this.myEquals = method;
                    continue;
                }
                if (!"hashCode".equals(name)) continue;
                this.myHashCode = method;
            }
        }
        if (this.myEquals == null || this.myHashCode == null || !this.myEquals.isValid() || !this.myHashCode.isValid()) {
            object = new PsiElementVisitor(){};
            if (object == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcode.buildVisitor must not return null");
            return object;
        }
        object = new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                super.visitClass(aClass);
                boolean[] hasEquals = new boolean[]{false};
                boolean[] hasHashCode = new boolean[]{false};
                EqualsAndHashcode.this.processClass(aClass, hasEquals, hasHashCode);
                if (hasEquals[0] != hasHashCode[0]) {
                    PsiIdentifier identifier = aClass.getNameIdentifier();
                    holder.registerProblem((PsiElement)(identifier != null ? identifier : aClass), hasEquals[0] ? InspectionsBundle.message((String)"inspection.equals.hashcode.only.one.defined.problem.descriptor", (Object[])new Object[]{"<code>equals()</code>", "<code>hashCode()</code>"}) : InspectionsBundle.message((String)"inspection.equals.hashcode.only.one.defined.problem.descriptor", (Object[])new Object[]{"<code>hashCode()</code>", "<code>equals()</code>"}), (LocalQuickFix[])null);
                }
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }
        };
        if (object != null) return object;
        throw new IllegalStateException("@NotNull method com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcode.buildVisitor must not return null");
    }

    private void processClass(PsiClass aClass, boolean[] hasEquals, boolean[] hasHashCode) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = aClass.getMethods()) {
            if (MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)this.myEquals)) {
                hasEquals[0] = true;
                continue;
            }
            if (!MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)this.myHashCode)) continue;
            hasHashCode[0] = true;
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.equals.hashcode.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcode.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcode.getGroupDisplayName must not return null");
        }
        return "";
    }

    @NotNull
    public String getShortName() {
        if ("EqualsAndHashcode" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcode.getShortName must not return null");
        }
        return "EqualsAndHashcode";
    }

    public void projectClosed(Project project) {
        this.myEquals = null;
        this.myHashCode = null;
        this.myPsiFacade = null;
    }
}

