/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DeprecationInspection
extends BaseJavaLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "Deprecation";
    @NonNls
    public static final String ID = "deprecation";
    public static final String DISPLAY_NAME = HighlightInfoType.DEPRECATION_DISPLAY_NAME;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/deprecation/DeprecationInspection.buildVisitor must not be null");
        }
        DeprecationElementVisitor deprecationElementVisitor = new DeprecationElementVisitor(holder);
        if (deprecationElementVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/deprecation/DeprecationInspection.buildVisitor must not return null");
        }
        return deprecationElementVisitor;
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/deprecation/DeprecationInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/deprecation/DeprecationInspection.getGroupDisplayName must not return null");
        }
        return "";
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/deprecation/DeprecationInspection.getShortName must not return null");
        }
        return SHORT_NAME;
    }

    @NotNull
    @NonNls
    public String getID() {
        if (ID == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/deprecation/DeprecationInspection.getID must not return null");
        }
        return ID;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    static void checkMethodOverridesDeprecated(MethodSignatureBackedByPsiMethod methodSignature, List<MethodSignatureBackedByPsiMethod> superMethodSignatures, ProblemsHolder holder) {
        PsiMethod method = methodSignature.getMethod();
        PsiIdentifier methodName = method.getNameIdentifier();
        for (MethodSignatureBackedByPsiMethod superMethodSignature : superMethodSignatures) {
            PsiMethod superMethod = superMethodSignature.getMethod();
            PsiClass aClass = superMethod.getContainingClass();
            if (aClass == null || !aClass.isDeprecated() && superMethod.hasModifierProperty("abstract") || !superMethod.isDeprecated()) continue;
            String description = JavaErrorMessages.message("overrides.deprecated.method", HighlightMessageUtil.getSymbolName((PsiElement)aClass, PsiSubstitutor.EMPTY));
            holder.registerProblem((PsiElement)methodName, description, ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
        }
    }

    static void checkDeprecated(PsiElement refElement, PsiElement elementToHighlight, ProblemsHolder holder) {
        if (!(refElement instanceof PsiDocCommentOwner)) {
            return;
        }
        if (!((PsiDocCommentOwner)refElement).isDeprecated()) {
            return;
        }
        String description = JavaErrorMessages.message("deprecated.symbol", HighlightMessageUtil.getSymbolName(refElement, PsiSubstitutor.EMPTY));
        holder.registerProblem(elementToHighlight, description, ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
    }

    private static class DeprecationElementVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        public DeprecationElementVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            JavaResolveResult result = reference.advancedResolve(true);
            PsiElement resolved = result.getElement();
            DeprecationInspection.checkDeprecated(resolved, reference.getReferenceNameElement(), this.myHolder);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
        }

        public void visitNewExpression(PsiNewExpression expression) {
            PsiType type = expression.getType();
            PsiExpressionList list = expression.getArgumentList();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type).resolveGenerics();
            PsiClass aClass = typeResult.getElement();
            if (aClass == null) {
                return;
            }
            if (aClass instanceof PsiAnonymousClass && (aClass = (typeResult = ((PsiClassType)(type = ((PsiAnonymousClass)aClass).getBaseClassType())).resolveGenerics()).getElement()) == null) {
                return;
            }
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)expression.getProject()).getResolveHelper();
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length > 0 && list != null) {
                PsiMethod constructor;
                JavaResolveResult[] results = resolveHelper.multiResolveConstructor((PsiClassType)type, list, (PsiElement)list);
                MethodCandidateInfo result = null;
                if (results.length == 1) {
                    result = (MethodCandidateInfo)results[0];
                }
                PsiMethod psiMethod = constructor = result == null ? null : result.getElement();
                if (constructor != null && expression.getClassReference() != null) {
                    DeprecationInspection.checkDeprecated((PsiElement)constructor, (PsiElement)expression.getClassReference(), this.myHolder);
                }
            }
        }

        public void visitMethod(PsiMethod method) {
            MethodSignatureBackedByPsiMethod methodSignature = MethodSignatureBackedByPsiMethod.create((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            if (!method.isConstructor()) {
                List superMethodSignatures = method.findSuperMethodSignaturesIncludingStatic(true);
                DeprecationInspection.checkMethodOverridesDeprecated(methodSignature, superMethodSignatures, this.myHolder);
            }
        }
    }
}

