/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.deadCode.DeadHTMLComposer;
import com.intellij.codeInspection.deadCode.RefUnreachableFilter;
import com.intellij.codeInspection.deadCode.UnreferencedFilter;
import com.intellij.codeInspection.deadCode.UnusedCodeExtension;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerImpl;
import com.intellij.codeInspection.ex.FilteringInspectionTool;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.EntryPointsNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.util.RefFilter;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.ui.SeparatorFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.intellij.util.text.CharArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedDeclarationInspection
extends FilteringInspectionTool {
    public boolean ADD_MAINS_TO_ENTRIES = true;
    public boolean ADD_APPLET_TO_ENTRIES = true;
    public boolean ADD_SERVLET_TO_ENTRIES = true;
    public boolean ADD_NONJAVA_TO_ENTRIES = true;
    public JDOMExternalizableStringList ADDITIONAL_ANNOTATIONS = new JDOMExternalizableStringList();
    @NonNls
    private static final String[] ADDITIONAL_ANNOS = new String[]{"javax.ws.rs.*"};
    private HashSet<RefElement> myProcessedSuspicious = null;
    private int myPhase;
    private final QuickFixAction[] myQuickFixActions;
    public static final String DISPLAY_NAME = InspectionsBundle.message((String)"inspection.dead.code.display.name", (Object[])new Object[0]);
    private WeakUnreferencedFilter myFilter;
    private DeadHTMLComposer myComposer;
    @NonNls
    public static final String SHORT_NAME = "UnusedDeclaration";
    private static final String COMMENT_OUT_QUICK_FIX = InspectionsBundle.message((String)"inspection.dead.code.comment.quickfix", (Object[])new Object[0]);
    private static final String DELETE_QUICK_FIX = InspectionsBundle.message((String)"inspection.dead.code.safe.delete.quickfix", (Object[])new Object[0]);
    @NonNls
    private static final String DELETE = "delete";
    @NonNls
    private static final String COMMENT = "comment";
    @NonNls
    private static final String[] HINTS = new String[]{"comment", "delete"};
    public final UnusedCodeExtension[] myExtensions;

    public UnusedDeclarationInspection() {
        this.ADDITIONAL_ANNOTATIONS.addAll(Arrays.asList(ADDITIONAL_ANNOS));
        this.myQuickFixActions = new QuickFixAction[]{new PermanentDeleteAction(), new CommentOutBin(), new MoveToEntries()};
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.deadCode");
        UnusedCodeExtension[] deadCodeAddins = (UnusedCodeExtension[])point.getExtensions();
        Arrays.sort(deadCodeAddins, new Comparator<UnusedCodeExtension>(){

            @Override
            public int compare(UnusedCodeExtension o1, UnusedCodeExtension o2) {
                return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
            }
        });
        this.myExtensions = deadCodeAddins;
    }

    @Override
    public void initialize(@NotNull GlobalInspectionContextImpl context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/deadCode/UnusedDeclarationInspection.initialize must not be null");
        }
        super.initialize(context);
        ((EntryPointsManagerImpl)this.getEntryPointsManager()).setAddNonJavaEntries(this.ADD_NONJAVA_TO_ENTRIES);
    }

    public JComponent createOptionsPanel() {
        JPanel scrollPane = new JPanel(new BorderLayout());
        scrollPane.add((Component)SeparatorFactory.createSeparator((String)"Entry points", null), "North");
        scrollPane.add((Component)new OptionsPanel(), "Center");
        return scrollPane;
    }

    private boolean isAddMainsEnabled() {
        return this.ADD_MAINS_TO_ENTRIES;
    }

    private boolean isAddAppletEnabled() {
        return this.ADD_APPLET_TO_ENTRIES;
    }

    private boolean isAddServletEnabled() {
        return this.ADD_SERVLET_TO_ENTRIES;
    }

    private boolean isAddNonJavaUsedEnabled() {
        return this.ADD_NONJAVA_TO_ENTRIES;
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/deadCode/UnusedDeclarationInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/deadCode/UnusedDeclarationInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/deadCode/UnusedDeclarationInspection.getShortName must not return null");
        }
        return SHORT_NAME;
    }

    public void readSettings(Element node) throws InvalidDataException {
        super.readSettings(node);
        for (UnusedCodeExtension extension : this.myExtensions) {
            extension.readExternal(node);
        }
    }

    public void writeSettings(Element node) throws WriteExternalException {
        super.writeSettings(node);
        for (UnusedCodeExtension extension : this.myExtensions) {
            extension.writeExternal(node);
        }
    }

    private static boolean isSerializationImplicitlyUsedField(PsiField field) {
        String name = field.getName();
        if (!"serialVersionUID".equals(name) && !"serialPersistentFields".equals(name)) {
            return false;
        }
        if (!field.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = field.getContainingClass();
        return aClass == null || UnusedDeclarationInspection.isSerializable(aClass);
    }

    private static boolean isWriteObjectMethod(PsiMethod method) {
        String name = method.getName();
        if (!"writeObject".equals(name)) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != 1) {
            return false;
        }
        if (!parameters[0].getType().equalsToText("java.io.ObjectOutputStream")) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return aClass == null || UnusedDeclarationInspection.isSerializable(aClass);
    }

    private static boolean isReadObjectMethod(PsiMethod method) {
        String name = method.getName();
        if (!"readObject".equals(name)) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != 1) {
            return false;
        }
        if (!parameters[0].getType().equalsToText("java.io.ObjectInputStream")) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return aClass == null || UnusedDeclarationInspection.isSerializable(aClass);
    }

    private static boolean isWriteReplaceMethod(PsiMethod method) {
        String name = method.getName();
        if (!"writeReplace".equals(name)) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != 0) {
            return false;
        }
        if (!method.getReturnType().equalsToText("java.lang.Object")) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return aClass == null || UnusedDeclarationInspection.isSerializable(aClass);
    }

    private static boolean isReadResolveMethod(PsiMethod method) {
        String name = method.getName();
        if (!"readResolve".equals(name)) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != 0) {
            return false;
        }
        if (!method.getReturnType().equalsToText("java.lang.Object")) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return aClass == null || UnusedDeclarationInspection.isSerializable(aClass);
    }

    private static boolean isSerializable(PsiClass aClass) {
        PsiClass serializableClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.io.Serializable", aClass.getResolveScope());
        return serializableClass != null && aClass.isInheritor(serializableClass, true);
    }

    @Override
    public void runInspection(final AnalysisScope scope, InspectionManager manager) {
        this.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(RefEntity refEntity) {
                if (refEntity instanceof RefJavaElement) {
                    RefElementImpl refElement = (RefElementImpl)refEntity;
                    PsiElement element = refElement.getElement();
                    if (element == null) {
                        return;
                    }
                    boolean isSuppressed = refElement.isSuppressed(UnusedDeclarationInspection.this.getShortName());
                    if (!UnusedDeclarationInspection.this.getContext().isToCheckMember(element, (InspectionTool)UnusedDeclarationInspection.this) || isSuppressed) {
                        if (isSuppressed || !scope.contains(element)) {
                            UnusedDeclarationInspection.this.getEntryPointsManager().addEntryPoint((RefElement)refElement, false);
                        }
                        return;
                    }
                    if (!refElement.isSuspicious()) {
                        return;
                    }
                    refElement.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitElement(RefEntity elem) {
                            RefElement element;
                            if (elem instanceof RefElement && UnusedDeclarationInspection.this.isEntryPoint(element = (RefElement)elem)) {
                                UnusedDeclarationInspection.this.getEntryPointsManager().addEntryPoint(element, false);
                            }
                        }

                        public void visitMethod(RefMethod method) {
                            if (UnusedDeclarationInspection.this.isAddMainsEnabled() && method.isAppMain()) {
                                UnusedDeclarationInspection.this.getEntryPointsManager().addEntryPoint((RefElement)method, false);
                            } else {
                                super.visitMethod(method);
                            }
                        }

                        public void visitClass(RefClass aClass) {
                            PsiClass psiClass = aClass.getElement();
                            if (UnusedDeclarationInspection.this.isAddAppletEnabled() && aClass.isApplet() || UnusedDeclarationInspection.this.isAddServletEnabled() && aClass.isServlet()) {
                                UnusedDeclarationInspection.this.getEntryPointsManager().addEntryPoint((RefElement)aClass, false);
                            } else if (psiClass.isAnnotationType()) {
                                PsiMethod[] psiMethods;
                                UnusedDeclarationInspection.this.getEntryPointsManager().addEntryPoint((RefElement)aClass, false);
                                for (PsiMethod psiMethod : psiMethods = psiClass.getMethods()) {
                                    UnusedDeclarationInspection.this.getEntryPointsManager().addEntryPoint(UnusedDeclarationInspection.this.getRefManager().getReference((PsiElement)psiMethod), false);
                                }
                            } else if (psiClass.isEnum()) {
                                UnusedDeclarationInspection.this.getEntryPointsManager().addEntryPoint((RefElement)aClass, false);
                            } else {
                                super.visitClass(aClass);
                            }
                        }
                    });
                }
            }
        });
        if (this.isAddNonJavaUsedEnabled()) {
            this.checkForReachables();
            ProgressManager.getInstance().runProcess(new Runnable(){

                @Override
                public void run() {
                    final StrictUnreferencedFilter filter = new StrictUnreferencedFilter(UnusedDeclarationInspection.this);
                    final PsiSearchHelper helper = PsiManager.getInstance((Project)UnusedDeclarationInspection.this.getRefManager().getProject()).getSearchHelper();
                    UnusedDeclarationInspection.this.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

                        public void visitElement(RefEntity refEntity) {
                            RefMethod refMethod;
                            if (refEntity instanceof RefClass && filter.accepts((RefJavaElement)((RefClass)refEntity))) {
                                this.findExternalClassReferences((RefClass)refEntity);
                            } else if (refEntity instanceof RefMethod && (refMethod = (RefMethod)refEntity).isConstructor() && filter.accepts((RefJavaElement)refMethod)) {
                                this.findExternalClassReferences(refMethod.getOwnerClass());
                            }
                        }

                        private void findExternalClassReferences(final RefClass refElement) {
                            PsiClass psiClass = refElement.getElement();
                            String qualifiedName = psiClass.getQualifiedName();
                            if (qualifiedName != null) {
                                helper.processUsagesInNonJavaFiles(qualifiedName, new PsiNonJavaFileReferenceProcessor(){

                                    public boolean process(PsiFile file, int startOffset, int endOffset) {
                                        UnusedDeclarationInspection.this.getEntryPointsManager().addEntryPoint((RefElement)refElement, false);
                                        return false;
                                    }
                                }, GlobalSearchScope.projectScope((Project)UnusedDeclarationInspection.this.getContext().getProject()));
                            }
                        }
                    });
                }
            }, null);
        }
        this.myProcessedSuspicious = new HashSet();
        this.myPhase = 1;
    }

    private boolean isEntryPoint(RefElement owner) {
        if (RefUtil.isEntryPoint((RefElement)owner)) {
            return true;
        }
        PsiElement element = owner.getElement();
        if (element instanceof PsiModifierListOwner && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (Collection)this.ADDITIONAL_ANNOTATIONS)) {
            return true;
        }
        for (UnusedCodeExtension extension : this.myExtensions) {
            if (!extension.isEntryPoint(owner)) continue;
            return true;
        }
        return false;
    }

    public boolean isEntryPoint(@NotNull PsiElement element) {
        ImplicitUsageProvider[] implicitUsageProviders;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/deadCode/UnusedDeclarationInspection.isEntryPoint must not be null");
        }
        Project project = element.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        if (element instanceof PsiMethod && this.isAddMainsEnabled() && PsiClassImplUtil.isMainMethod((PsiMethod)element)) {
            return true;
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            if (aClass.isAnnotationType()) {
                return true;
            }
            if (aClass.isEnum()) {
                return true;
            }
            PsiClass applet = psiFacade.findClass("java.applet.Applet", GlobalSearchScope.allScope((Project)project));
            if (this.isAddAppletEnabled() && applet != null && aClass.isInheritor(applet, true)) {
                return true;
            }
            PsiClass servlet = psiFacade.findClass("javax.servlet.Servlet", GlobalSearchScope.allScope((Project)project));
            if (this.isAddServletEnabled() && servlet != null && aClass.isInheritor(servlet, true)) {
                return true;
            }
            if (this.isAddMainsEnabled() && PsiMethodUtil.hasMainMethod((PsiClass)aClass)) {
                return true;
            }
        }
        if (element instanceof PsiModifierListOwner && AnnotationUtil.checkAnnotatedUsingPatterns((PsiModifierListOwner)((PsiModifierListOwner)element), (Collection)this.ADDITIONAL_ANNOTATIONS)) {
            return true;
        }
        for (UnusedCodeExtension extension : this.myExtensions) {
            if (!extension.isEntryPoint(element)) continue;
            return true;
        }
        for (ImplicitUsageProvider provider : implicitUsageProviders = (ImplicitUsageProvider[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME)) {
            if (!provider.isImplicitUsage(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean queryExternalUsagesRequests(InspectionManager manager) {
        this.checkForReachables();
        final RefUnreachableFilter filter = this.myPhase == 1 ? new StrictUnreferencedFilter(this) : new RefUnreachableFilter(this);
        final boolean[] requestAdded = new boolean[]{false};
        this.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(RefEntity refEntity) {
                if (!(refEntity instanceof RefJavaElement)) {
                    return;
                }
                if (refEntity instanceof RefClass && ((RefClass)refEntity).isAnonymous()) {
                    return;
                }
                RefJavaElement refElement = (RefJavaElement)refEntity;
                if (filter.accepts(refElement) && !UnusedDeclarationInspection.this.myProcessedSuspicious.contains(refElement)) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitField(final RefField refField) {
                            UnusedDeclarationInspection.this.myProcessedSuspicious.add(refField);
                            PsiField psiField = refField.getElement();
                            if (UnusedDeclarationInspection.isSerializationImplicitlyUsedField(psiField)) {
                                UnusedDeclarationInspection.this.getEntryPointsManager().addEntryPoint((RefElement)refField, false);
                            } else {
                                UnusedDeclarationInspection.this.getJavaContext().enqueueFieldUsagesProcessor(refField, new GlobalJavaInspectionContext.UsagesProcessor(){

                                    public boolean process(PsiReference psiReference) {
                                        UnusedDeclarationInspection.this.getEntryPointsManager().addEntryPoint((RefElement)refField, false);
                                        return false;
                                    }
                                });
                                requestAdded[0] = true;
                            }
                        }

                        public void visitMethod(RefMethod refMethod) {
                            UnusedDeclarationInspection.this.myProcessedSuspicious.add(refMethod);
                            if (refMethod instanceof RefImplicitConstructor) {
                                this.visitClass(refMethod.getOwnerClass());
                            } else {
                                PsiMethod psiMethod = (PsiMethod)refMethod.getElement();
                                if (UnusedDeclarationInspection.isSerializablePatternMethod(psiMethod)) {
                                    UnusedDeclarationInspection.this.getEntryPointsManager().addEntryPoint((RefElement)refMethod, false);
                                } else if (!refMethod.isExternalOverride() && !"private".equals(refMethod.getAccessModifier())) {
                                    for (RefMethod derivedMethod : refMethod.getDerivedMethods()) {
                                        UnusedDeclarationInspection.this.myProcessedSuspicious.add(derivedMethod);
                                    }
                                    UnusedDeclarationInspection.this.enqueueMethodUsages(refMethod);
                                    requestAdded[0] = true;
                                }
                            }
                        }

                        public void visitClass(final RefClass refClass) {
                            UnusedDeclarationInspection.this.myProcessedSuspicious.add(refClass);
                            if (!refClass.isAnonymous()) {
                                UnusedDeclarationInspection.this.getJavaContext().enqueueDerivedClassesProcessor(refClass, new GlobalJavaInspectionContext.DerivedClassesProcessor(){

                                    public boolean process(PsiClass inheritor) {
                                        UnusedDeclarationInspection.this.getEntryPointsManager().addEntryPoint((RefElement)refClass, false);
                                        return false;
                                    }
                                });
                                UnusedDeclarationInspection.this.getJavaContext().enqueueClassUsagesProcessor(refClass, new GlobalJavaInspectionContext.UsagesProcessor(){

                                    public boolean process(PsiReference psiReference) {
                                        UnusedDeclarationInspection.this.getEntryPointsManager().addEntryPoint((RefElement)refClass, false);
                                        return false;
                                    }
                                });
                                requestAdded[0] = true;
                            }
                        }
                    });
                }
            }
        });
        if (!requestAdded[0]) {
            if (this.myPhase == 2) {
                this.myProcessedSuspicious = null;
                return false;
            }
            this.myPhase = 2;
        }
        return true;
    }

    private static boolean isSerializablePatternMethod(PsiMethod psiMethod) {
        return UnusedDeclarationInspection.isReadObjectMethod(psiMethod) || UnusedDeclarationInspection.isWriteObjectMethod(psiMethod) || UnusedDeclarationInspection.isReadResolveMethod(psiMethod) || UnusedDeclarationInspection.isWriteReplaceMethod(psiMethod);
    }

    private void enqueueMethodUsages(final RefMethod refMethod) {
        if (refMethod.getSuperMethods().isEmpty()) {
            this.getJavaContext().enqueueMethodUsagesProcessor(refMethod, new GlobalJavaInspectionContext.UsagesProcessor(){

                public boolean process(PsiReference psiReference) {
                    UnusedDeclarationInspection.this.getEntryPointsManager().addEntryPoint((RefElement)refMethod, false);
                    return false;
                }
            });
        } else {
            for (RefMethod refSuper : refMethod.getSuperMethods()) {
                this.enqueueMethodUsages(refSuper);
            }
        }
    }

    public GlobalJavaInspectionContext getJavaContext() {
        return (GlobalJavaInspectionContext)this.getContext().getExtension(GlobalJavaInspectionContext.CONTEXT);
    }

    @Override
    public RefFilter getFilter() {
        if (this.myFilter == null) {
            this.myFilter = new WeakUnreferencedFilter(this);
        }
        return this.myFilter;
    }

    @Override
    public HTMLComposerImpl getComposer() {
        if (this.myComposer == null) {
            this.myComposer = new DeadHTMLComposer(this);
        }
        return this.myComposer;
    }

    @Override
    public void exportResults(final Element parentNode) {
        final WeakUnreferencedFilter filter = new WeakUnreferencedFilter(this);
        this.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(RefEntity refEntity) {
                if (!(refEntity instanceof RefJavaElement)) {
                    return;
                }
                if (!UnusedDeclarationInspection.this.getIgnoredRefElements().contains(refEntity) && filter.accepts((RefJavaElement)refEntity)) {
                    if (refEntity instanceof RefImplicitConstructor) {
                        refEntity = ((RefImplicitConstructor)refEntity).getOwnerClass();
                    }
                    Element element = refEntity.getRefManager().export(refEntity, parentNode, -1);
                    Element problemClassElement = new Element(InspectionsBundle.message((String)"inspection.export.results.problem.element.tag", (Object[])new Object[0]));
                    if (refEntity instanceof RefElement) {
                        RefElement refElement = (RefElement)refEntity;
                        HighlightSeverity severity = UnusedDeclarationInspection.this.getCurrentSeverity(refElement);
                        String attributeKey = UnusedDeclarationInspection.getTextAttributeKey(refElement.getElement().getProject(), severity, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
                        problemClassElement.setAttribute("severity", severity.myName);
                        problemClassElement.setAttribute("attribute_key", attributeKey);
                    }
                    problemClassElement.addContent(InspectionsBundle.message((String)"inspection.export.results.dead.code", (Object[])new Object[0]));
                    element.addContent(problemClassElement);
                    Element hintsElement = new Element("hints");
                    for (String hint : HINTS) {
                        Element hintElement = new Element("hint");
                        hintElement.setAttribute("value", hint);
                        hintsElement.addContent(hintElement);
                    }
                    element.addContent(hintsElement);
                    Element descriptionElement = new Element(InspectionsBundle.message((String)"inspection.export.results.description.tag", (Object[])new Object[0]));
                    StringBuffer buf = new StringBuffer();
                    DeadHTMLComposer.appendProblemSynopsis((RefElement)refEntity, buf);
                    descriptionElement.addContent(buf.toString());
                    element.addContent(descriptionElement);
                }
            }
        });
    }

    @Override
    public QuickFixAction[] getQuickFixes(RefEntity[] refElements) {
        return this.myQuickFixActions;
    }

    @Override
    @NotNull
    public JobDescriptor[] getJobDescriptors() {
        JobDescriptor[] jobDescriptorArray = new JobDescriptor[]{GlobalInspectionContextImpl.BUILD_GRAPH, GlobalInspectionContextImpl.FIND_EXTERNAL_USAGES};
        if (jobDescriptorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/deadCode/UnusedDeclarationInspection.getJobDescriptors must not return null");
        }
        return jobDescriptorArray;
    }

    private static void commentOutDead(PsiElement psiElement) {
        Document doc;
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile != null && (doc = PsiDocumentManager.getInstance((Project)psiElement.getProject()).getDocument(psiFile)) != null) {
            int line2;
            TextRange textRange = psiElement.getTextRange();
            SimpleDateFormat format = new SimpleDateFormat();
            String date = format.format(new Date());
            int startOffset = textRange.getStartOffset();
            CharSequence chars = doc.getCharsSequence();
            while (CharArrayUtil.regionMatches((CharSequence)chars, (int)startOffset, (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.comment", (Object[])new Object[0]))) {
                int line = doc.getLineNumber(startOffset) + 1;
                if (line >= doc.getLineCount()) continue;
                startOffset = doc.getLineStartOffset(line);
                startOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)startOffset, (String)" \t");
            }
            int endOffset = textRange.getEndOffset();
            int line1 = doc.getLineNumber(startOffset);
            if (line1 == (line2 = doc.getLineNumber(endOffset - 1))) {
                doc.insertString(startOffset, (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.date.comment", (Object[])new Object[]{date}));
            } else {
                for (int i = line1; i <= line2; ++i) {
                    doc.insertString(doc.getLineStartOffset(i), (CharSequence)"//");
                }
                doc.insertString(doc.getLineStartOffset(Math.min(line2 + 1, doc.getLineCount() - 1)), (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.stop.comment", (Object[])new Object[]{date}));
                doc.insertString(doc.getLineStartOffset(line1), (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.start.comment", (Object[])new Object[]{date}));
            }
        }
    }

    @Override
    @Nullable
    public IntentionAction findQuickFixes(CommonProblemDescriptor descriptor, String hint) {
        if (descriptor instanceof ProblemDescriptor) {
            if (DELETE.equals(hint)) {
                return new PermanentDeleteFix(((ProblemDescriptor)descriptor).getPsiElement());
            }
            if (COMMENT.equals(hint)) {
                return new CommentOutFix(((ProblemDescriptor)descriptor).getPsiElement());
            }
        }
        return null;
    }

    private void checkForReachables() {
        CodeScanner codeScanner = new CodeScanner();
        this.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(RefEntity refEntity) {
                if (refEntity instanceof RefJavaElement) {
                    RefJavaElementImpl refElement = (RefJavaElementImpl)refEntity;
                    PsiElement element = refElement.getElement();
                    if (element == null) {
                        return;
                    }
                    if (!UnusedDeclarationInspection.this.getContext().isToCheckMember(refElement, (InspectionTool)UnusedDeclarationInspection.this)) {
                        return;
                    }
                    refElement.setReachable(false);
                }
            }
        });
        for (RefElement entry : this.getEntryPointsManager().getEntryPoints()) {
            entry.accept((RefVisitor)codeScanner);
        }
        while (codeScanner.newlyInstantiatedClassesCount() != 0) {
            codeScanner.cleanInstantiatedClassesCount();
            codeScanner.processDelayedMethods();
        }
    }

    private EntryPointsManager getEntryPointsManager() {
        return ((GlobalJavaInspectionContext)this.getContext().getExtension(GlobalJavaInspectionContext.CONTEXT)).getEntryPointsManager(this.getContext().getRefManager());
    }

    @Override
    public void updateContent() {
        this.checkForReachables();
        super.updateContent();
    }

    @Override
    public InspectionNode createToolNode(InspectionRVContentProvider provider, InspectionTreeNode parentNode, boolean showStructure) {
        InspectionNode toolNode = super.createToolNode(provider, parentNode, showStructure);
        EntryPointsNode entryPointsNode = new EntryPointsNode(this);
        provider.appendToolNodeContent(entryPointsNode, toolNode, showStructure);
        return entryPointsNode;
    }

    private static class CodeScanner
    extends RefJavaVisitor {
        private final HashMap<RefClass, HashSet<RefMethod>> myClassIDtoMethods = new HashMap();
        private final HashSet<RefClass> myInstantiatedClasses = new HashSet();
        private int myInstantiatedClassesCount = 0;
        private final HashSet<RefMethod> myProcessedMethods = new HashSet();

        private CodeScanner() {
        }

        public void visitMethod(RefMethod method) {
            if (!this.myProcessedMethods.contains(method)) {
                if (method.isStatic() || method.isConstructor()) {
                    if (method.isConstructor()) {
                        this.addInstantiatedClass(method.getOwnerClass());
                    } else {
                        ((RefClassImpl)method.getOwnerClass()).setReachable(true);
                    }
                    this.myProcessedMethods.add(method);
                    this.makeContentReachable((RefJavaElementImpl)method);
                    this.makeClassInitializersReachable(method.getOwnerClass());
                } else {
                    if (this.isClassInstantiated(method.getOwnerClass())) {
                        this.myProcessedMethods.add(method);
                        this.makeContentReachable((RefJavaElementImpl)method);
                    } else {
                        this.addDelayedMethod(method);
                    }
                    for (RefMethod refSub : method.getDerivedMethods()) {
                        this.visitMethod(refSub);
                    }
                }
            }
        }

        public void visitClass(RefClass refClass) {
            boolean alreadyActive = refClass.isReachable();
            ((RefClassImpl)refClass).setReachable(true);
            if (!alreadyActive) {
                this.makeClassInitializersReachable(refClass);
            }
            this.addInstantiatedClass(refClass);
        }

        public void visitField(RefField field) {
            if (!field.isReachable()) {
                this.makeContentReachable((RefJavaElementImpl)field);
                this.makeClassInitializersReachable(field.getOwnerClass());
            }
        }

        private void addInstantiatedClass(RefClass refClass) {
            if (this.myInstantiatedClasses.add(refClass)) {
                ((RefClassImpl)refClass).setReachable(true);
                ++this.myInstantiatedClassesCount;
                List refMethods = refClass.getLibraryMethods();
                for (RefMethod refMethod : refMethods) {
                    refMethod.accept((RefVisitor)this);
                }
                for (RefClass baseClass : refClass.getBaseClasses()) {
                    this.addInstantiatedClass(baseClass);
                }
            }
        }

        private void makeContentReachable(RefJavaElementImpl refElement) {
            refElement.setReachable(true);
            for (RefElement refCallee : refElement.getOutReferences()) {
                refCallee.accept((RefVisitor)this);
            }
        }

        private void makeClassInitializersReachable(RefClass refClass) {
            for (RefElement refCallee : refClass.getOutReferences()) {
                refCallee.accept((RefVisitor)this);
            }
        }

        private void addDelayedMethod(RefMethod refMethod) {
            HashSet<RefMethod> methods = (HashSet<RefMethod>)this.myClassIDtoMethods.get((Object)refMethod.getOwnerClass());
            if (methods == null) {
                methods = new HashSet<RefMethod>();
                this.myClassIDtoMethods.put((Object)refMethod.getOwnerClass(), methods);
            }
            methods.add(refMethod);
        }

        private boolean isClassInstantiated(RefClass refClass) {
            return this.myInstantiatedClasses.contains(refClass);
        }

        private int newlyInstantiatedClassesCount() {
            return this.myInstantiatedClassesCount;
        }

        private void cleanInstantiatedClassesCount() {
            this.myInstantiatedClassesCount = 0;
        }

        private void processDelayedMethods() {
            RefClass[] instClasses;
            for (RefClass refClass : instClasses = this.myInstantiatedClasses.toArray(new RefClass[this.myInstantiatedClasses.size()])) {
                RefMethod[] arMethods;
                HashSet methods;
                if (!this.isClassInstantiated(refClass) || (methods = (HashSet)this.myClassIDtoMethods.get((Object)refClass)) == null) continue;
                for (RefMethod arMethod : arMethods = methods.toArray(new RefMethod[methods.size()])) {
                    arMethod.accept((RefVisitor)this);
                }
            }
        }
    }

    private class MoveToEntries
    extends QuickFixAction {
        private MoveToEntries() {
            super(InspectionsBundle.message((String)"inspection.dead.code.entry.point.quickfix", (Object[])new Object[0]), null, KeyStroke.getKeyStroke(155, 0), UnusedDeclarationInspection.this);
        }

        @Override
        protected boolean applyFix(RefElement[] refElements) {
            EntryPointsManager entryPointsManager = UnusedDeclarationInspection.this.getEntryPointsManager();
            for (RefElement refElement : refElements) {
                entryPointsManager.addEntryPoint(refElement, true);
            }
            return true;
        }
    }

    private static class CommentOutFix
    implements IntentionAction {
        private final PsiElement myElement;

        private CommentOutFix(PsiElement element) {
            this.myElement = element;
        }

        @NotNull
        public String getText() {
            String string = COMMENT_OUT_QUICK_FIX;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/deadCode/UnusedDeclarationInspection$CommentOutFix.getText must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/deadCode/UnusedDeclarationInspection$CommentOutFix.getFamilyName must not return null");
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/deadCode/UnusedDeclarationInspection$CommentOutFix.isAvailable must not be null");
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/deadCode/UnusedDeclarationInspection$CommentOutFix.invoke must not be null");
            }
            if (this.myElement != null && this.myElement.isValid()) {
                UnusedDeclarationInspection.commentOutDead(PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiModifierListOwner.class));
            }
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    private class CommentOutBin
    extends QuickFixAction {
        private CommentOutBin() {
            super(COMMENT_OUT_QUICK_FIX, null, KeyStroke.getKeyStroke(47, SystemInfo.isMac ? 4 : 2), UnusedDeclarationInspection.this);
        }

        @Override
        protected boolean applyFix(RefElement[] refElements) {
            if (!super.applyFix(refElements)) {
                return false;
            }
            ArrayList deletedRefs = new ArrayList(1);
            for (RefElement refElement : refElements) {
                PsiElement psiElement = refElement.getElement();
                if (psiElement == null || UnusedDeclarationInspection.this.myFilter.getElementProblemCount((RefJavaElement)refElement) == 0) continue;
                UnusedDeclarationInspection.commentOutDead(psiElement);
                refElement.getRefManager().removeRefElement(refElement, deletedRefs);
            }
            EntryPointsManager entryPointsManager = UnusedDeclarationInspection.this.getEntryPointsManager();
            for (RefElement refElement : deletedRefs) {
                entryPointsManager.removeEntryPoint(refElement);
            }
            return true;
        }
    }

    private static class PermanentDeleteFix
    implements IntentionAction {
        private final PsiElement myElement;

        private PermanentDeleteFix(PsiElement element) {
            this.myElement = element;
        }

        @NotNull
        public String getText() {
            String string = DELETE_QUICK_FIX;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/deadCode/UnusedDeclarationInspection$PermanentDeleteFix.getText must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/deadCode/UnusedDeclarationInspection$PermanentDeleteFix.getFamilyName must not return null");
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/deadCode/UnusedDeclarationInspection$PermanentDeleteFix.isAvailable must not be null");
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/deadCode/UnusedDeclarationInspection$PermanentDeleteFix.invoke must not be null");
            }
            if (this.myElement != null && this.myElement.isValid()) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SafeDeleteHandler.invoke(PermanentDeleteFix.this.myElement.getProject(), new PsiElement[]{PsiTreeUtil.getParentOfType((PsiElement)PermanentDeleteFix.this.myElement, PsiModifierListOwner.class)}, false);
                    }
                });
            }
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    private class PermanentDeleteAction
    extends QuickFixAction {
        private PermanentDeleteAction() {
            super(DELETE_QUICK_FIX, IconLoader.getIcon((String)"/actions/cancel.png"), KeyStroke.getKeyStroke(127, 0), UnusedDeclarationInspection.this);
        }

        @Override
        protected boolean applyFix(final RefElement[] refElements) {
            if (!super.applyFix(refElements)) {
                return false;
            }
            final ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
            for (RefElement refElement : refElements) {
                PsiElement psiElement = refElement.getElement();
                if (psiElement == null || UnusedDeclarationInspection.this.myFilter.getElementProblemCount((RefJavaElement)refElement) == 0) continue;
                psiElements.add(psiElement);
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    final Project project = UnusedDeclarationInspection.this.getContext().getProject();
                    SafeDeleteHandler.invoke(project, psiElements.toArray(new PsiElement[psiElements.size()]), false, new Runnable(){

                        @Override
                        public void run() {
                            QuickFixAction.removeElements(refElements, project, UnusedDeclarationInspection.this);
                        }
                    });
                }
            });
            return false;
        }
    }

    private static class WeakUnreferencedFilter
    extends UnreferencedFilter {
        private WeakUnreferencedFilter(InspectionTool tool) {
            super(tool);
        }

        @Override
        public int getElementProblemCount(RefJavaElement refElement) {
            int problemCount = super.getElementProblemCount(refElement);
            if (problemCount > -1) {
                return problemCount;
            }
            if (!((RefElementImpl)refElement).hasSuspiciousCallers() || ((RefJavaElementImpl)refElement).isSuspiciousRecursive()) {
                return 1;
            }
            return 0;
        }
    }

    private static class StrictUnreferencedFilter
    extends UnreferencedFilter {
        private StrictUnreferencedFilter(InspectionTool tool) {
            super(tool);
        }

        @Override
        public int getElementProblemCount(RefJavaElement refElement) {
            int problemCount = super.getElementProblemCount(refElement);
            if (problemCount > -1) {
                return problemCount;
            }
            return refElement.isReferenced() ? 0 : 1;
        }
    }

    private class OptionsPanel
    extends JPanel {
        private final JCheckBox myMainsCheckbox;
        private final JCheckBox myAppletToEntries;
        private final JCheckBox myServletToEntries;
        private final JCheckBox myNonJavaCheckbox;

        private OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.fill = 2;
            gc.anchor = 18;
            this.myMainsCheckbox = new JCheckBox(InspectionsBundle.message((String)"inspection.dead.code.option", (Object[])new Object[0]));
            this.myMainsCheckbox.setSelected(UnusedDeclarationInspection.this.ADD_MAINS_TO_ENTRIES);
            this.myMainsCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UnusedDeclarationInspection.this.ADD_MAINS_TO_ENTRIES = OptionsPanel.this.myMainsCheckbox.isSelected();
                }
            });
            gc.gridy = 0;
            this.add((Component)this.myMainsCheckbox, gc);
            this.myAppletToEntries = new JCheckBox(InspectionsBundle.message((String)"inspection.dead.code.option3", (Object[])new Object[0]));
            this.myAppletToEntries.setSelected(UnusedDeclarationInspection.this.ADD_APPLET_TO_ENTRIES);
            this.myAppletToEntries.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UnusedDeclarationInspection.this.ADD_APPLET_TO_ENTRIES = OptionsPanel.this.myAppletToEntries.isSelected();
                }
            });
            ++gc.gridy;
            this.add((Component)this.myAppletToEntries, gc);
            this.myServletToEntries = new JCheckBox(InspectionsBundle.message((String)"inspection.dead.code.option4", (Object[])new Object[0]));
            this.myServletToEntries.setSelected(UnusedDeclarationInspection.this.ADD_SERVLET_TO_ENTRIES);
            this.myServletToEntries.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UnusedDeclarationInspection.this.ADD_SERVLET_TO_ENTRIES = OptionsPanel.this.myServletToEntries.isSelected();
                }
            });
            ++gc.gridy;
            this.add((Component)this.myServletToEntries, gc);
            for (final UnusedCodeExtension extension : UnusedDeclarationInspection.this.myExtensions) {
                if (!extension.showUI()) continue;
                final JCheckBox extCheckbox = new JCheckBox(extension.getDisplayName());
                extCheckbox.setSelected(extension.isSelected());
                extCheckbox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        extension.setSelected(extCheckbox.isSelected());
                    }
                });
                ++gc.gridy;
                this.add((Component)extCheckbox, gc);
            }
            this.myNonJavaCheckbox = new JCheckBox(InspectionsBundle.message((String)"inspection.dead.code.option5", (Object[])new Object[0]));
            this.myNonJavaCheckbox.setSelected(UnusedDeclarationInspection.this.ADD_NONJAVA_TO_ENTRIES);
            this.myNonJavaCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UnusedDeclarationInspection.this.ADD_NONJAVA_TO_ENTRIES = OptionsPanel.this.myNonJavaCheckbox.isSelected();
                }
            });
            ++gc.gridy;
            this.add((Component)this.myNonJavaCheckbox, gc);
            JPanel listPanel = SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)UnusedDeclarationInspection.this.ADDITIONAL_ANNOTATIONS, InspectionsBundle.message((String)"inspections.dead.code.entry.points.annotations.list.title", (Object[])new Object[0]));
            ++gc.gridy;
            gc.weighty = 1.0;
            this.add((Component)listPanel, gc);
        }
    }
}

