/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaNotNullValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class DfaRelationValue
extends DfaValue {
    private DfaValue myLeftOperand;
    private DfaValue myRightOperand;
    private String myRelation;
    private boolean myIsNegated;

    private DfaRelationValue(DfaValueFactory factory) {
        super(factory);
    }

    private DfaRelationValue(DfaValue myLeftOperand, DfaValue myRightOperand, String myRelation, boolean myIsNegated, DfaValueFactory factory) {
        super(factory);
        this.myLeftOperand = myLeftOperand;
        this.myRightOperand = myRightOperand;
        this.myRelation = myRelation;
        this.myIsNegated = myIsNegated;
    }

    public DfaValue getLeftOperand() {
        return this.myLeftOperand;
    }

    public DfaValue getRightOperand() {
        return this.myRightOperand;
    }

    public boolean isNegated() {
        return this.myIsNegated;
    }

    @Override
    public DfaValue createNegated() {
        return this.myFactory.getRelationFactory().create(this.myLeftOperand, this.myRightOperand, this.myRelation, !this.myIsNegated);
    }

    private boolean hardEquals(DfaRelationValue rel) {
        return Comparing.equal((Object)rel.myLeftOperand, (Object)this.myLeftOperand) && Comparing.equal((Object)rel.myRightOperand, (Object)this.myRightOperand) && rel.myRelation.equals(this.myRelation) && rel.myIsNegated == this.myIsNegated;
    }

    @NonNls
    public String toString() {
        return (this.isNegated() ? "not " : "") + this.myLeftOperand + this.myRelation + this.myRightOperand;
    }

    public static class Factory {
        private final DfaRelationValue mySharedInstance;
        private final HashMap<String, ArrayList<DfaRelationValue>> myStringToObject;
        private final DfaValueFactory myFactory;

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
            this.mySharedInstance = new DfaRelationValue(factory);
            this.myStringToObject = new HashMap();
        }

        @Nullable
        public DfaRelationValue create(DfaValue dfaLeft, DfaValue dfaRight, @NonNls String relation, boolean negated) {
            if (dfaRight instanceof DfaTypeValue && !"instanceof".equals(relation)) {
                return null;
            }
            if ("+".equals(relation)) {
                return null;
            }
            if (dfaLeft instanceof DfaVariableValue || dfaLeft instanceof DfaBoxedValue || dfaLeft instanceof DfaUnboxedValue || dfaRight instanceof DfaVariableValue || dfaRight instanceof DfaBoxedValue || dfaRight instanceof DfaUnboxedValue) {
                if (!(dfaLeft instanceof DfaVariableValue || dfaLeft instanceof DfaBoxedValue || dfaLeft instanceof DfaUnboxedValue)) {
                    return this.create(dfaRight, dfaLeft, Factory.getSymmetricOperation(relation), negated);
                }
                return this.createCanonicalRelation(relation, negated, dfaLeft, dfaRight);
            }
            if (dfaLeft instanceof DfaNotNullValue && dfaRight instanceof DfaConstValue) {
                return this.createCanonicalRelation(relation, negated, dfaLeft, dfaRight);
            }
            if (dfaRight instanceof DfaNotNullValue && dfaLeft instanceof DfaConstValue) {
                return this.createCanonicalRelation(relation, negated, dfaRight, dfaLeft);
            }
            return null;
        }

        private DfaRelationValue createCanonicalRelation(String relation, boolean negated, DfaValue dfaLeft, DfaValue dfaRight) {
            if ("!=".equals(relation)) {
                relation = "==";
                negated = !negated;
            } else if ("<".equals(relation)) {
                relation = ">=";
                negated = !negated;
            } else if ("<=".equals(relation)) {
                relation = ">";
                negated = !negated;
            }
            this.mySharedInstance.myLeftOperand = dfaLeft;
            this.mySharedInstance.myRightOperand = dfaRight;
            this.mySharedInstance.myRelation = relation;
            this.mySharedInstance.myIsNegated = negated;
            String id = this.mySharedInstance.toString();
            ArrayList<DfaRelationValue> conditions = (ArrayList<DfaRelationValue>)this.myStringToObject.get((Object)id);
            if (conditions == null) {
                conditions = new ArrayList<DfaRelationValue>();
                this.myStringToObject.put((Object)id, conditions);
            } else {
                for (DfaRelationValue rel : conditions) {
                    if (!rel.hardEquals(this.mySharedInstance)) continue;
                    return rel;
                }
            }
            DfaRelationValue result = new DfaRelationValue(dfaLeft, dfaRight, relation, negated, this.myFactory);
            conditions.add(result);
            return result;
        }

        private static String getSymmetricOperation(String sign) {
            if ("<".equals(sign)) {
                return ">";
            }
            if (">=".equals(sign)) {
                return "<=";
            }
            if (">".equals(sign)) {
                return "<";
            }
            if ("<=".equals(sign)) {
                return ">=";
            }
            return sign;
        }
    }
}

