/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;

public class ControlFlow {
    private final ArrayList<Instruction> myInstructions = new ArrayList();
    private final HashMap<PsiElement, Integer> myElementToStartOffsetMap = new HashMap();
    private final HashMap<PsiElement, Integer> myElementToEndOffsetMap = new HashMap();
    private DfaVariableValue[] myFields;
    private final DfaValueFactory myFactory;

    public ControlFlow(DfaValueFactory factory) {
        this.myFactory = factory;
    }

    public Instruction[] getInstructions() {
        return this.myInstructions.toArray(new Instruction[this.myInstructions.size()]);
    }

    public int getInstructionCount() {
        return this.myInstructions.size();
    }

    public void startElement(PsiElement psiElement) {
        this.myElementToStartOffsetMap.put((Object)psiElement, (Object)this.myInstructions.size());
    }

    public void finishElement(PsiElement psiElement) {
        this.myElementToEndOffsetMap.put((Object)psiElement, (Object)this.myInstructions.size());
    }

    public void addInstruction(Instruction instruction) {
        instruction.setIndex(this.myInstructions.size());
        this.myInstructions.add(instruction);
    }

    public void removeVariable(PsiVariable variable) {
        DfaVariableValue var = this.myFactory.getVarFactory().create(variable, false);
        this.addInstruction(new FlushVariableInstruction(var));
    }

    public int getStartOffset(PsiElement element) {
        Integer value = (Integer)this.myElementToStartOffsetMap.get((Object)element);
        if (value == null) {
            return -1;
        }
        return value;
    }

    public int getEndOffset(PsiElement element) {
        Integer value = (Integer)this.myElementToEndOffsetMap.get((Object)element);
        if (value == null) {
            return -1;
        }
        return value;
    }

    public DfaVariableValue[] getFields() {
        return this.myFields;
    }

    public void setFields(DfaVariableValue[] fields) {
        this.myFields = fields;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        ArrayList<Instruction> instructions = this.myInstructions;
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            result.append(Integer.toString(i)).append(": ").append(instruction.toString());
            result.append("\n");
        }
        return result.toString();
    }
}

