/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class CleanupInspectionIntention
implements IntentionAction {
    private final LocalInspectionTool myTool;
    private final Class myQuickfixClass;

    public CleanupInspectionIntention(LocalInspectionTool tool, Class quickFixClass) {
        this.myTool = tool;
        this.myQuickfixClass = quickFixClass;
    }

    @NotNull
    public String getText() {
        String string = InspectionsBundle.message((String)"fix.all.inspection.problems.in.file", (Object[])new Object[]{this.myTool.getDisplayName()});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/actions/CleanupInspectionIntention.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/actions/CleanupInspectionIntention.getFamilyName must not return null");
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/actions/CleanupInspectionIntention.invoke must not be null");
        }
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{file.getVirtualFile()});
        if (status.hasReadonlyFiles()) {
            return;
        }
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManagerEx.getInstance((Project)project);
        GlobalInspectionContextImpl context = managerEx.createNewGlobalContext(false);
        LocalInspectionToolWrapper tool = new LocalInspectionToolWrapper(this.myTool);
        tool.initialize(context);
        ((RefManagerImpl)context.getRefManager()).inspectionReadActionStarted();
        tool.processFile(file, true, managerEx, true);
        ArrayList<CommonProblemDescriptor> descriptions = new ArrayList<CommonProblemDescriptor>(tool.getProblemDescriptors());
        Collections.sort(descriptions, new Comparator<CommonProblemDescriptor>(){

            @Override
            public int compare(CommonProblemDescriptor o1, CommonProblemDescriptor o2) {
                ProblemDescriptorImpl d1 = (ProblemDescriptorImpl)o1;
                ProblemDescriptorImpl d2 = (ProblemDescriptorImpl)o2;
                return d2.getTextRange().getStartOffset() - d1.getTextRange().getStartOffset();
            }
        });
        block0: for (CommonProblemDescriptor descriptor : descriptions) {
            QuickFix[] fixes = descriptor.getFixes();
            if (fixes == null || fixes.length <= 0) continue;
            for (QuickFix fix : fixes) {
                if (fix == null || !fix.getClass().isAssignableFrom(this.myQuickfixClass)) continue;
                PsiElement element = ((ProblemDescriptor)descriptor).getPsiElement();
                if (element == null || !element.isValid()) continue block0;
                fix.applyFix(project, descriptor);
                continue block0;
            }
        }
        ((RefManagerImpl)context.getRefManager()).inspectionReadActionFinished();
        context.cleanup(managerEx);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/actions/CleanupInspectionIntention.isAvailable must not be null");
        }
        return this.myQuickfixClass != null && this.myQuickfixClass != EmptyIntentionAction.class && !(this.myTool instanceof UnfairLocalInspectionTool);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

