/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.DefaultHighlightVisitor;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalInspectionUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SyntaxErrorInspection
extends GlobalInspectionTool {
    public boolean isGraphNeeded() {
        return false;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/SyntaxErrorInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    public void runInspection(AnalysisScope scope, InspectionManager manager, GlobalInspectionContext globalContext, ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        scope.accept((PsiElementVisitor)new MyPsiRecursiveElementVisitor(manager, globalContext, problemDescriptionsProcessor));
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("General" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/SyntaxErrorInspection.getGroupDisplayName must not return null");
        }
        return "General";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Syntax error" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/SyntaxErrorInspection.getDisplayName must not return null");
        }
        return "Syntax error";
    }

    @NotNull
    public String getShortName() {
        if ("SyntaxError" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/SyntaxErrorInspection.getShortName must not return null");
        }
        return "SyntaxError";
    }

    private static class MyPsiRecursiveElementVisitor
    extends PsiRecursiveElementVisitor
    implements PsiLanguageInjectionHost.InjectedPsiVisitor {
        private final InspectionManager manager;
        private final GlobalInspectionContext globalContext;
        private final ProblemDescriptionsProcessor problemDescriptionsProcessor;
        private final HighlightErrorFilter[] errorFilters;

        public MyPsiRecursiveElementVisitor(InspectionManager manager, GlobalInspectionContext globalContext, ProblemDescriptionsProcessor problemDescriptionsProcessor) {
            this.manager = manager;
            this.globalContext = globalContext;
            this.problemDescriptionsProcessor = problemDescriptionsProcessor;
            this.errorFilters = (HighlightErrorFilter[])Extensions.getExtensions(DefaultHighlightVisitor.FILTER_EP_NAME, (AreaInstance)manager.getProject());
        }

        public void visitElement(PsiElement element) {
            super.visitElement(element);
            if (element instanceof PsiLanguageInjectionHost) {
                ((PsiLanguageInjectionHost)element).processInjectedPsi((PsiLanguageInjectionHost.InjectedPsiVisitor)this);
            }
        }

        public void visitErrorElement(PsiErrorElement element) {
            ProblemDescriptor descriptor;
            super.visitErrorElement(element);
            for (HighlightErrorFilter errorFilter : this.errorFilters) {
                if (errorFilter.shouldHighlightErrorElement(element)) continue;
                return;
            }
            TextRange textRange = element.getTextRange();
            if (textRange.getLength() > 0) {
                descriptor = this.manager.createProblemDescriptor((PsiElement)element, GlobalInspectionUtil.createInspectionMessage(element.getErrorDescription()), ProblemHighlightType.ERROR, null, false, new LocalQuickFix[0]);
            } else {
                PsiErrorElement parent = element;
                while ((parent = parent.getParent()) != null) {
                    TextRange r = parent.getTextRange();
                    if (r == null) {
                        return;
                    }
                    if (r.getLength() <= 0) continue;
                    break;
                }
                if (parent == null) {
                    return;
                }
                int offset = element.getTextRange().getStartOffset() - parent.getTextRange().getStartOffset();
                descriptor = this.manager.createProblemDescriptor((PsiElement)parent, new TextRange(offset, offset + 1), GlobalInspectionUtil.createInspectionMessage(element.getErrorDescription()), ProblemHighlightType.ERROR, false, new LocalQuickFix[0]);
            }
            this.problemDescriptionsProcessor.addProblemElement((RefEntity)GlobalInspectionUtil.retrieveRefElement((PsiElement)element, this.globalContext), new CommonProblemDescriptor[]{descriptor});
        }

        public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
            if (injectedPsi == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/SyntaxErrorInspection$MyPsiRecursiveElementVisitor.visit must not be null");
            }
            if (places == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/SyntaxErrorInspection$MyPsiRecursiveElementVisitor.visit must not be null");
            }
            injectedPsi.acceptChildren((PsiElementVisitor)this);
        }
    }
}

