/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;

public class IterableComponentTypeMacro
implements Macro {
    public String getName() {
        return "iterableComponentType";
    }

    public String getDescription() {
        return CodeInsightBundle.message((String)"macro.iterable.component.type", (Object[])new Object[0]);
    }

    public String getDefaultValue() {
        return "a";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        PsiSubstitutor substitutor;
        PsiClass iterableClass;
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass aClass;
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/IterableComponentTypeMacro.calculateResult must not be null");
        }
        if (params.length != 1) {
            return null;
        }
        Result result = params[0].calculateResult(context);
        if (result == null) {
            return null;
        }
        Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiExpression expr = MacroUtil.resultToPsiExpression(result, context);
        if (expr == null) {
            return null;
        }
        PsiType type = expr.getType();
        if (type instanceof PsiArrayType) {
            return new PsiTypeResult(((PsiArrayType)type).getComponentType(), project);
        }
        if (type instanceof PsiClassType && (aClass = (resolveResult = ((PsiClassType)type).resolveGenerics()).getElement()) != null && (iterableClass = JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Iterable", aClass.getResolveScope())) != null && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)iterableClass, (PsiClass)aClass, (PsiSubstitutor)resolveResult.getSubstitutor())) != null) {
            PsiType parameterType = substitutor.substitute(iterableClass.getTypeParameters()[0]);
            if (parameterType instanceof PsiCapturedWildcardType) {
                parameterType = ((PsiCapturedWildcardType)parameterType).getWildcard();
            }
            if (parameterType != null) {
                if (parameterType instanceof PsiWildcardType) {
                    if (((PsiWildcardType)parameterType).isExtends()) {
                        return new PsiTypeResult(((PsiWildcardType)parameterType).getBound(), project);
                    }
                    return null;
                }
                return new PsiTypeResult(parameterType, project);
            }
        }
        return null;
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/IterableComponentTypeMacro.calculateQuickResult must not be null");
        }
        return this.calculateResult(params, context);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/IterableComponentTypeMacro.calculateLookupItems must not be null");
        }
        return LookupElement.EMPTY_ARRAY;
    }
}

