/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.InvokeActionResult;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.macro.TemplateCompletionProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BaseCompleteMacro
implements Macro {
    private final String myName;

    protected BaseCompleteMacro(@NonNls String name) {
        this.myName = name;
    }

    abstract CodeInsightActionHandler getCompletionHandler();

    public String getName() {
        return this.myName;
    }

    public String getDescription() {
        return this.myName + "()";
    }

    public String getDefaultValue() {
        return "a";
    }

    public final Result calculateResult(@NotNull Expression[] params, final ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/BaseCompleteMacro.calculateResult must not be null");
        }
        return new InvokeActionResult(new Runnable(){

            @Override
            public void run() {
                BaseCompleteMacro.this.invokeCompletion(context);
            }
        });
    }

    private void invokeCompletion(final ExpressionContext context) {
        final Project project = context.getProject();
        final Editor editor = context.getEditor();
        final PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        new WriteCommandAction.Simple(project, new PsiFile[]{psiFile}){

            public void run() {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            }
        }.execute();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.getCompletionHandler().invoke(project, editor, psiFile);
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        LookupManager lookupManager;
                        Lookup lookup;
                        if (!ApplicationManager.getApplication().isUnitTestMode()) {
                            BaseCompleteMacro.this.getCompletionHandler().invoke(project, editor, psiFile);
                        }
                        if ((lookup = (lookupManager = LookupManager.getInstance(project)).getActiveLookup()) != null) {
                            lookup.addLookupListener(new MyLookupListener(context));
                        } else {
                            TextRange range;
                            TemplateState templateState = TemplateManagerImpl.getTemplateState(editor);
                            if (templateState != null && (range = templateState.getCurrentVariableRange()) != null && range.getLength() > 0) {
                                templateState.nextTab();
                            }
                        }
                    }
                }, "", null);
            }
        });
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/BaseCompleteMacro.calculateQuickResult must not be null");
        }
        return null;
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/BaseCompleteMacro.calculateLookupItems must not be null");
        }
        return null;
    }

    private static class MyLookupListener
    extends LookupAdapter {
        private final ExpressionContext myContext;

        public MyLookupListener(@NotNull ExpressionContext context) {
            if (context == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/BaseCompleteMacro$MyLookupListener.<init> must not be null");
            }
            this.myContext = context;
        }

        @Override
        public void itemSelected(LookupEvent event) {
            TemplateState templateState;
            Editor editor;
            LookupElement item = event.getItem();
            if (item == null) {
                return;
            }
            boolean goNextTab = true;
            for (TemplateCompletionProcessor processor : (TemplateCompletionProcessor[])Extensions.getExtensions(TemplateCompletionProcessor.EP_NAME)) {
                if (processor.nextTabOnItemSelected(this.myContext, item)) continue;
                goNextTab = false;
                break;
            }
            if (goNextTab && (editor = this.myContext.getEditor()) != null && (templateState = TemplateManagerImpl.getTemplateState(editor)) != null) {
                templateState.nextTab();
            }
        }
    }
}

