/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.SurroundWithTemplateHandler;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ListTemplatesHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/impl/ListTemplatesHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/template/impl/ListTemplatesHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/template/impl/ListTemplatesHandler.invoke must not be null");
        }
        if (!file.isWritable()) {
            return;
        }
        EditorUtil.fillVirtualSpaceUntilCaret(editor);
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        int offset = editor.getCaretModel().getOffset();
        String prefix = ListTemplatesHandler.getPrefix(editor.getDocument(), offset);
        ArrayList<TemplateImpl> matchingTemplates = new ArrayList<TemplateImpl>();
        for (TemplateImpl template : SurroundWithTemplateHandler.getApplicableTemplates(editor, file, false)) {
            if (!template.getKey().startsWith(prefix)) continue;
            matchingTemplates.add(template);
        }
        if (matchingTemplates.size() == 0) {
            String text = prefix.length() == 0 ? CodeInsightBundle.message((String)"templates.no.defined", (Object[])new Object[0]) : CodeInsightBundle.message((String)"templates.no.defined.with.prefix", (Object[])new Object[]{prefix});
            HintManager.getInstance().showErrorHint(editor, text);
            return;
        }
        ListTemplatesHandler.showTemplatesLookup(project, editor, prefix, matchingTemplates);
    }

    public static void showTemplatesLookup(Project project, Editor editor, String prefix, List<TemplateImpl> matchingTemplates) {
        ArrayList<LookupItem<TemplateImpl>> array = new ArrayList<LookupItem<TemplateImpl>>();
        for (TemplateImpl template : matchingTemplates) {
            array.add(new LookupItem<TemplateImpl>(template, template.getKey()));
        }
        LookupElement[] items = array.toArray(new LookupElement[array.size()]);
        LookupImpl lookup = (LookupImpl)LookupManager.getInstance(project).createLookup(editor, items, prefix, LookupArranger.DEFAULT);
        lookup.addLookupListener(new MyLookupAdapter(project, editor, null));
        lookup.show();
    }

    private static String computePrefix(TemplateImpl template, String argument) {
        String key = template.getKey();
        if (argument == null) {
            return key;
        }
        if (key.length() > 0 && Character.isJavaIdentifierPart(key.charAt(key.length() - 1))) {
            return key + ' ' + argument;
        }
        return key + argument;
    }

    public static void showTemplatesLookup(Project project, Editor editor, Map<TemplateImpl, String> template2Argument) {
        ArrayList<LookupItem<TemplateImpl>> array = new ArrayList<LookupItem<TemplateImpl>>();
        for (TemplateImpl template : template2Argument.keySet()) {
            String argument = template2Argument.get(template);
            String prefix = ListTemplatesHandler.computePrefix(template, argument);
            LookupItem<TemplateImpl> item = new LookupItem<TemplateImpl>(template, prefix);
            item.setPrefixMatcher(new CamelHumpMatcher(prefix));
            array.add(item);
        }
        LookupElement[] items = array.toArray(new LookupElement[array.size()]);
        LookupImpl lookup = (LookupImpl)LookupManager.getInstance(project).createLookup(editor, items, null, LookupArranger.DEFAULT);
        lookup.addLookupListener(new MyLookupAdapter(project, editor, template2Argument));
        lookup.show();
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static String getPrefix(Document document, int offset) {
        char c;
        int start;
        CharSequence chars = document.getCharsSequence();
        for (start = offset; start != 0 && ListTemplatesHandler.isInPrefix(c = chars.charAt(start - 1)); --start) {
        }
        return ((Object)chars.subSequence(start, offset)).toString();
    }

    private static boolean isInPrefix(char c) {
        return Character.isJavaIdentifierPart(c) || c == '.';
    }

    private static class MyLookupAdapter
    extends LookupAdapter {
        private final Project myProject;
        private final Editor myEditor;
        private final Map<TemplateImpl, String> myTemplate2Argument;

        public MyLookupAdapter(Project project, Editor editor, Map<TemplateImpl, String> template2Argument) {
            this.myProject = project;
            this.myEditor = editor;
            this.myTemplate2Argument = template2Argument;
        }

        @Override
        public void itemSelected(LookupEvent event) {
            LookupElement item = event.getItem();
            if (item != null) {
                final TemplateImpl template = (TemplateImpl)item.getObject();
                final String argument = this.myTemplate2Argument != null ? this.myTemplate2Argument.get(template) : null;
                new WriteCommandAction(this.myProject, new PsiFile[0]){

                    protected void run(Result result) throws Throwable {
                        ((TemplateManagerImpl)TemplateManager.getInstance(MyLookupAdapter.this.myProject)).startTemplateWithPrefix(MyLookupAdapter.this.myEditor, template, null, argument);
                    }
                }.execute();
            }
        }
    }
}

