/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.EditTemplateDialog;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class SaveAsTemplateAction
extends AnAction {
    @NonNls
    public static final String JAVA_LANG_PACKAGE_PREFIX = "java.lang";

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)LangDataKeys.PSI_FILE.getData(dataContext);
        Project project = file.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final TextRange selection = new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
        PsiElement current = file.findElementAt(selection.getStartOffset());
        int startOffset = selection.getStartOffset();
        while (current instanceof PsiWhiteSpace && (current = current.getNextSibling()) != null) {
            startOffset = current.getTextRange().getStartOffset();
        }
        if (startOffset >= selection.getEndOffset()) {
            startOffset = selection.getStartOffset();
        }
        final PsiElement[] psiElements = PsiTreeUtil.collectElements((PsiElement)file, (PsiElementFilter)new PsiElementFilter(){

            public boolean isAccepted(PsiElement element) {
                return selection.contains(element.getTextRange()) && element.getReferences().length > 0;
            }
        });
        final Document document = EditorFactory.getInstance().createDocument((CharSequence)editor.getDocument().getText().substring(startOffset, selection.getEndOffset()));
        final int offsetDelta = startOffset;
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        HashMap rangeToText = new HashMap();
                        for (PsiElement element : psiElements) {
                            for (PsiReference reference : element.getReferences()) {
                                if (reference instanceof PsiQualifiedReference && ((PsiQualifiedReference)reference).getQualifier() != null) continue;
                                String canonicalText = reference.getCanonicalText();
                                TextRange referenceRange = reference.getRangeInElement();
                                TextRange range = element.getTextRange().cutOut(referenceRange).shiftRight(-offsetDelta);
                                String oldText = range.substring(document.getText());
                                if (canonicalText.equals(oldText)) continue;
                                rangeToText.put(document.createRangeMarker(range), canonicalText);
                            }
                        }
                        for (Map.Entry entry : rangeToText.entrySet()) {
                            document.replaceString(((RangeMarker)entry.getKey()).getStartOffset(), ((RangeMarker)entry.getKey()).getEndOffset(), (CharSequence)entry.getValue());
                        }
                    }
                });
            }
        }, null, null);
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        TemplateImpl template = new TemplateImpl("", document.getText(), "user");
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFile(file.getVirtualFile());
        for (TemplateContextType contextType : (TemplateContextType[])Extensions.getExtensions(TemplateContextType.EP_NAME)) {
            template.getTemplateContext().setEnabled(contextType, contextType.isInContext(fileType));
        }
        String defaultShortcut = "";
        if (templateSettings.getDefaultShortcutChar() == '\n') {
            defaultShortcut = CodeInsightBundle.message((String)"template.shortcut.enter", (Object[])new Object[0]);
        }
        if (templateSettings.getDefaultShortcutChar() == '\t') {
            defaultShortcut = CodeInsightBundle.message((String)"template.shortcut.tab", (Object[])new Object[0]);
        }
        if (templateSettings.getDefaultShortcutChar() == ' ') {
            defaultShortcut = CodeInsightBundle.message((String)"template.shortcut.space", (Object[])new Object[0]);
        }
        Map<TemplateOptionalProcessor, Boolean> options = template.createOptions();
        Map<TemplateContextType, Boolean> context = template.createContext();
        EditTemplateDialog dialog = new EditTemplateDialog(editor.getComponent(), CodeInsightBundle.message((String)"dialog.edit.live.template.title", (Object[])new Object[0]), template, templateSettings.getTemplateGroups(), defaultShortcut, options, context);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        dialog.apply();
        template.applyOptions(options);
        template.applyContext(context);
        templateSettings.addTemplate(template);
        templateSettings.setLastSelectedTemplateKey(template.getKey());
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)LangDataKeys.PSI_FILE.getData(dataContext);
        if (file == null || editor == null) {
            e.getPresentation().setEnabled(false);
        } else {
            e.getPresentation().setEnabled(editor.getSelectionModel().hasSelection());
        }
    }
}

