/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.RecalculatableResult;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiTypeResult
implements RecalculatableResult {
    private final SmartTypePointer myTypePointer;
    private final JavaPsiFacade myFacade;

    public PsiTypeResult(@NotNull PsiType type, Project project) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/PsiTypeResult.<init> must not be null");
        }
        PsiType actualType = PsiUtil.convertAnonymousToBaseType((PsiType)type);
        this.myTypePointer = SmartTypePointerManager.getInstance((Project)project).createSmartTypePointer(actualType);
        this.myFacade = JavaPsiFacade.getInstance((Project)project);
    }

    public PsiType getType() {
        return this.myTypePointer.getType();
    }

    public boolean equalsToText(String text, PsiElement context) {
        if (text.length() == 0) {
            return false;
        }
        PsiType type = this.getType();
        if (text.equals(type.getCanonicalText())) {
            return true;
        }
        try {
            PsiTypeCastExpression cast = (PsiTypeCastExpression)this.myFacade.getElementFactory().createExpressionFromText("(" + text + ")a", context);
            PsiTypeElement castType = cast.getCastType();
            return castType != null && castType.getType().equals(type);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
    }

    public String toString() {
        return this.getType().getCanonicalText();
    }

    public void handleFocused(PsiFile psiFile, Document document, int segmentStart, int segmentEnd) {
        JavaTemplateUtil.updateTypeBindings(this.getType(), psiFile, document, segmentStart, segmentEnd);
    }

    @Override
    public void handleRecalc(PsiFile psiFile, Document document, int segmentStart, int segmentEnd) {
        JavaTemplateUtil.updateTypeBindings(this.getType(), psiFile, document, segmentStart, segmentEnd);
    }
}

