/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class FileTypeBasedContextType
extends TemplateContextType {
    private final LanguageFileType myFileType;

    protected FileTypeBasedContextType(@NotNull @NonNls String id, @NotNull String presentableName, @NotNull LanguageFileType fileType) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/FileTypeBasedContextType.<init> must not be null");
        }
        if (presentableName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/template/FileTypeBasedContextType.<init> must not be null");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/template/FileTypeBasedContextType.<init> must not be null");
        }
        super(id, presentableName);
        this.myFileType = fileType;
    }

    @Override
    public boolean isInContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/FileTypeBasedContextType.isInContext must not be null");
        }
        return this.isInContext(file.getFileType());
    }

    @Override
    public boolean isInContext(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/FileTypeBasedContextType.isInContext must not be null");
        }
        return fileType == this.myFileType;
    }

    @Override
    public SyntaxHighlighter createHighlighter() {
        return SyntaxHighlighter.PROVIDER.create((FileType)this.myFileType, null, null);
    }
}

