/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.searches.DefinitionsSearch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplementationSearcher {
    public PsiElement[] searchImplementations(Editor editor, PsiElement element, int offset) {
        TargetElementUtilBase targetElementUtil = TargetElementUtilBase.getInstance();
        boolean onRef = targetElementUtil.findTargetElement(editor, ImplementationSearcher.getFlags() & 0xFFFFFFFE, offset) == null;
        return this.searchImplementations(element, offset, onRef && targetElementUtil.includeSelfInGotoImplementation(element), onRef);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiElement[] searchImplementations(PsiElement element, int offset, boolean includeSelfAlways, boolean includeSelfIfNoOthers) {
        PsiElement[] psiElementArray;
        PsiElement[] psiElementArray2;
        if (element == null) {
            psiElementArray2 = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/navigation/ImplementationSearcher.searchImplementations must not return null");
            return psiElementArray2;
        }
        PsiElement[] elements = this.searchDefinitions(element);
        if (elements == null) {
            psiElementArray2 = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/navigation/ImplementationSearcher.searchImplementations must not return null");
            return psiElementArray2;
        }
        if (elements.length > 0) {
            if (!includeSelfAlways) {
                psiElementArray2 = this.filterElements(element, elements, offset);
                if (psiElementArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/navigation/ImplementationSearcher.searchImplementations must not return null");
                return psiElementArray2;
            } else {
                PsiElement[] all;
                if (element.getTextRange() != null) {
                    all = new PsiElement[elements.length + 1];
                    all[0] = element;
                    System.arraycopy(elements, 0, all, 1, elements.length);
                } else {
                    all = elements;
                }
                if ((psiElementArray2 = this.filterElements(element, all, offset)) == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/navigation/ImplementationSearcher.searchImplementations must not return null");
                return psiElementArray2;
            }
        }
        if ((includeSelfAlways || includeSelfIfNoOthers) && element.getTextRange() != null) {
            PsiElement[] psiElementArray3 = new PsiElement[1];
            psiElementArray = psiElementArray3;
            psiElementArray3[0] = element;
        } else {
            psiElementArray = psiElementArray2 = PsiElement.EMPTY_ARRAY;
        }
        if (psiElementArray != null) return psiElementArray2;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/navigation/ImplementationSearcher.searchImplementations must not return null");
    }

    @Nullable(value="For the case the search has been cancelled")
    protected PsiElement[] searchDefinitions(final PsiElement element) {
        final PsiElement[][] result = new PsiElement[1][];
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    result[0] = (PsiElement[])DefinitionsSearch.search((PsiElement)element).toArray((Object[])PsiElement.EMPTY_ARRAY);
                }
                catch (IndexNotReadyException e) {
                    DumbService.getInstance((Project)element.getProject()).showDumbModeNotification("Implementation information isn't available while indices are built");
                    result[0] = null;
                }
            }
        }, CodeInsightBundle.message((String)"searching.for.implementations", (Object[])new Object[0]), true, element.getProject())) {
            return null;
        }
        return result[0];
    }

    protected PsiElement[] filterElements(PsiElement element, PsiElement[] targetElements, int offset) {
        return targetElements;
    }

    public static int getFlags() {
        return TargetElementUtilBase.getInstance().getDefinitionSearchFlags();
    }
}

