/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SplitIfAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.SplitIfAction");

    public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement element) {
        boolean isOrExpression;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/SplitIfAction.isAvailable must not be null");
        }
        if (element == null) {
            return false;
        }
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (!(token.getParent() instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression expression = (PsiBinaryExpression)token.getParent();
        boolean isAndExpression = expression.getOperationSign().getTokenType() == JavaTokenType.ANDAND;
        boolean bl = isOrExpression = expression.getOperationSign().getTokenType() == JavaTokenType.OROR;
        if (!isAndExpression && !isOrExpression) {
            return false;
        }
        while (expression.getParent() instanceof PsiBinaryExpression) {
            if (isAndExpression && expression.getOperationSign().getTokenType() != JavaTokenType.ANDAND) {
                return false;
            }
            if (isOrExpression && expression.getOperationSign().getTokenType() != JavaTokenType.OROR) {
                return false;
            }
            expression = (PsiBinaryExpression)expression.getParent();
        }
        if (!(expression.getParent() instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)expression.getParent();
        if (!PsiTreeUtil.isAncestor((PsiElement)ifStatement.getCondition(), (PsiElement)expression, (boolean)false)) {
            return false;
        }
        if (ifStatement.getThenBranch() == null) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.split.if.text", (Object[])new Object[0]));
        return true;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.split.if.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/SplitIfAction.getFamilyName must not return null");
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/SplitIfAction.invoke must not be null");
        }
        try {
            if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
                return;
            }
            int offset = editor.getCaretModel().getOffset();
            PsiJavaToken token = (PsiJavaToken)file.findElementAt(offset);
            LOG.assertTrue(token.getTokenType() == JavaTokenType.ANDAND || token.getTokenType() == JavaTokenType.OROR);
            PsiBinaryExpression expression = (PsiBinaryExpression)token.getParent();
            PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiIfStatement.class);
            LOG.assertTrue(PsiTreeUtil.isAncestor((PsiElement)ifStatement.getCondition(), (PsiElement)expression, (boolean)false));
            if (token.getTokenType() == JavaTokenType.ANDAND) {
                SplitIfAction.doAndSplit(ifStatement, expression, editor);
            } else if (token.getTokenType() == JavaTokenType.OROR) {
                SplitIfAction.doOrSplit(ifStatement, expression, editor);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void doAndSplit(PsiIfStatement ifStatement, PsiBinaryExpression expression, Editor editor) throws IncorrectOperationException {
        PsiExpression lOperand = expression.getLOperand();
        PsiExpression rOperand = SplitIfAction.getROperand(expression);
        PsiManager psiManager = ifStatement.getManager();
        PsiIfStatement subIf = (PsiIfStatement)ifStatement.copy();
        subIf.getCondition().replace((PsiElement)rOperand);
        ifStatement.getCondition().replace((PsiElement)lOperand);
        if (ifStatement.getThenBranch() instanceof PsiBlockStatement) {
            PsiBlockStatement blockStmt = (PsiBlockStatement)JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createStatementFromText("{}", null);
            blockStmt = (PsiBlockStatement)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)blockStmt);
            blockStmt = (PsiBlockStatement)ifStatement.getThenBranch().replace((PsiElement)blockStmt);
            blockStmt.getCodeBlock().add((PsiElement)subIf);
        } else {
            ifStatement.getThenBranch().replace((PsiElement)subIf);
        }
        int offset1 = ifStatement.getCondition().getTextOffset();
        editor.getCaretModel().moveToOffset(offset1);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    private static PsiExpression getROperand(PsiBinaryExpression expression) throws IncorrectOperationException {
        PsiBinaryExpression e = expression;
        while (!(e.getParent() instanceof PsiIfStatement)) {
            e = e.getParent();
        }
        return JavaPsiFacade.getInstance((Project)expression.getProject()).getElementFactory().createExpressionFromText(e.getText().substring(expression.getROperand().getTextRange().getStartOffset() - e.getTextRange().getStartOffset()), e.getParent());
    }

    private static void doOrSplit(PsiIfStatement ifStatement, PsiBinaryExpression expression, Editor editor) throws IncorrectOperationException {
        PsiExpression lOperand = expression.getLOperand();
        PsiExpression rOperand = SplitIfAction.getROperand(expression);
        PsiIfStatement secondIf = (PsiIfStatement)ifStatement.copy();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch != null) {
            elseBranch = (PsiStatement)elseBranch.copy();
        }
        ifStatement.getCondition().replace((PsiElement)lOperand);
        secondIf.getCondition().replace((PsiElement)rOperand);
        ifStatement.setElseBranch((PsiStatement)secondIf);
        if (elseBranch != null) {
            secondIf.setElseBranch(elseBranch);
        }
        int offset1 = ifStatement.getCondition().getTextOffset();
        editor.getCaretModel().moveToOffset(offset1);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }
}

