/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveInitializerToConstructorAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction.getFamilyName must not return null");
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.move.initializer.to.constructor", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction.getText must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction.isAvailable must not be null");
        }
        if (element == null) {
            return false;
        }
        if (element instanceof PsiCompiledElement) {
            return false;
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class, (boolean)false, (Class[])new Class[]{PsiMember.class, PsiCodeBlock.class, PsiDocComment.class});
        if (field == null || field.hasModifierProperty("static")) {
            return false;
        }
        if (!field.hasInitializer()) {
            return false;
        }
        PsiClass psiClass = field.getContainingClass();
        return psiClass != null && !psiClass.isInterface() && !(psiClass instanceof PsiAnonymousClass) && !(psiClass instanceof JspClass);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        List<PsiMethod> constructorsToAddInitialization;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        assert (field != null);
        PsiClass aClass = field.getContainingClass();
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            IntentionAction addDefaultConstructorFix = QuickFixFactory.getInstance().createAddDefaultConstructorFix(aClass);
            addDefaultConstructorFix.invoke(project, editor, file);
            editor.getCaretModel().moveToOffset(offset);
            constructorsToAddInitialization = Arrays.asList(aClass.getConstructors());
        } else {
            constructorsToAddInitialization = new ArrayList<PsiMethod>(Arrays.asList(constructors));
            Iterator iterator = constructorsToAddInitialization.iterator();
            while (iterator.hasNext()) {
                PsiMethod ctr = (PsiMethod)iterator.next();
                List<PsiMethod> chained = HighlightControlFlowUtil.getChainedConstructors(ctr);
                if (chained == null) continue;
                iterator.remove();
            }
        }
        PsiExpressionStatement toMove = null;
        for (PsiMethod constructor : constructorsToAddInitialization) {
            PsiCodeBlock codeBlock = constructor.getBody();
            if (codeBlock == null) {
                CreateFromUsageUtils.setupMethodBody(constructor);
                codeBlock = constructor.getBody();
            }
            PsiExpressionStatement added = MoveInitializerToConstructorAction.addAssignment(codeBlock, field);
            if (toMove != null) continue;
            toMove = added;
        }
        field.getInitializer().delete();
        if (toMove != null) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)toMove.getExpression();
            PsiExpression expression = assignment.getRExpression();
            EditorColorsManager manager = EditorColorsManager.getInstance();
            TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            HighlightManager.getInstance((Project)project).addOccurrenceHighlights(editor, new PsiElement[]{expression}, attributes, false, null);
        }
    }

    private static PsiExpressionStatement addAssignment(@NotNull PsiCodeBlock codeBlock, @NotNull PsiField field) throws IncorrectOperationException {
        if (codeBlock == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction.addAssignment must not be null");
        }
        if (field == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/intention/impl/MoveInitializerToConstructorAction.addAssignment must not be null");
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)codeBlock.getProject()).getElementFactory();
        PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText(field.getName() + " = y;", (PsiElement)codeBlock);
        PsiAssignmentExpression expression = (PsiAssignmentExpression)statement.getExpression();
        PsiExpression initializer = field.getInitializer();
        if (initializer instanceof PsiArrayInitializerExpression) {
            PsiType type = initializer.getType();
            PsiNewExpression newExpression = (PsiNewExpression)factory.createExpressionFromText("new " + type.getCanonicalText() + "{}", (PsiElement)codeBlock);
            newExpression.getArrayInitializer().replace((PsiElement)initializer);
            initializer = newExpression;
        }
        expression.getRExpression().replace((PsiElement)initializer);
        PsiStatement[] statements = codeBlock.getStatements();
        PsiStatement anchor = null;
        for (PsiStatement blockStatement : statements) {
            if (blockStatement instanceof PsiExpressionStatement && HighlightUtil.isSuperOrThisMethodCall((PsiElement)((PsiExpressionStatement)blockStatement).getExpression()) || !MoveInitializerToConstructorAction.containsReference((PsiElement)blockStatement, field)) continue;
            anchor = blockStatement;
            break;
        }
        PsiElement newStatement = codeBlock.addBefore((PsiElement)statement, anchor);
        MoveInitializerToConstructorAction.replaceWithQualifiedReferences(newStatement, newStatement);
        return (PsiExpressionStatement)newStatement;
    }

    private static boolean containsReference(PsiElement element, final PsiField field) {
        final Ref result = new Ref((Object)Boolean.FALSE);
        element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                if (expression.resolve() == field) {
                    result.set((Object)Boolean.TRUE);
                }
                super.visitReferenceExpression(expression);
            }
        });
        return (Boolean)result.get();
    }

    private static void replaceWithQualifiedReferences(PsiElement expression, PsiElement root) throws IncorrectOperationException {
        PsiReference reference = expression.getReference();
        if (reference != null) {
            PsiElement resolved = reference.resolve();
            if (resolved instanceof PsiVariable && !(resolved instanceof PsiField) && !PsiTreeUtil.isAncestor((PsiElement)root, (PsiElement)resolved, (boolean)false)) {
                PsiVariable variable = (PsiVariable)resolved;
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)resolved.getProject()).getElementFactory();
                PsiExpression qualifiedExpr = factory.createExpressionFromText("this." + variable.getName(), expression);
                expression.replace((PsiElement)qualifiedExpr);
            }
        } else {
            for (PsiElement child : expression.getChildren()) {
                MoveInitializerToConstructorAction.replaceWithQualifiedReferences(child, root);
            }
        }
    }
}

