/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class MoveFieldAssignmentToInitializerAction
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/MoveFieldAssignmentToInitializerAction.getFamilyName must not return null");
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.move.field.assignment.to.declaration", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/MoveFieldAssignmentToInitializerAction.getText must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/MoveFieldAssignmentToInitializerAction.isAvailable must not be null");
        }
        PsiAssignmentExpression assignment = MoveFieldAssignmentToInitializerAction.getAssignmentUnderCaret(editor, file);
        if (assignment == null) {
            return false;
        }
        PsiField field = MoveFieldAssignmentToInitializerAction.getAssignedField(assignment);
        if (field == null || field.hasInitializer()) {
            return false;
        }
        PsiClass psiClass = field.getContainingClass();
        if (psiClass == null || psiClass.isInterface()) {
            return false;
        }
        if (psiClass.getContainingFile() != file) {
            return false;
        }
        PsiModifierListOwner ctrOrInitializer = MoveFieldAssignmentToInitializerAction.enclosingMethodOrClassInitializer(assignment, field);
        if (ctrOrInitializer == null) {
            return false;
        }
        if (ctrOrInitializer.hasModifierProperty("static") != field.hasModifierProperty("static")) {
            return false;
        }
        if (!MoveFieldAssignmentToInitializerAction.isValidAsFieldInitializer(assignment.getRExpression(), ctrOrInitializer)) {
            return false;
        }
        return MoveFieldAssignmentToInitializerAction.isInitializedWithSameExpression(field, assignment, new ArrayList<PsiAssignmentExpression>());
    }

    private static boolean isValidAsFieldInitializer(final PsiExpression initializer, final PsiModifierListOwner ctrOrInitializer) {
        if (initializer == null) {
            return false;
        }
        final Ref result = new Ref((Object)Boolean.TRUE);
        initializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiElement resolved = expression.resolve();
                if (resolved == null) {
                    return;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)ctrOrInitializer, (PsiElement)resolved, (boolean)false) && !PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)resolved, (boolean)false)) {
                    result.set((Object)Boolean.FALSE);
                }
            }
        });
        return (Boolean)result.get();
    }

    private static PsiModifierListOwner enclosingMethodOrClassInitializer(PsiAssignmentExpression assignment, PsiField field) {
        PsiElement parent;
        PsiAssignmentExpression parentOwner = assignment;
        do {
            if ((parentOwner = PsiTreeUtil.getParentOfType((PsiElement)parentOwner, PsiModifierListOwner.class, (boolean)true, (Class[])new Class[]{PsiMember.class})) != null) continue;
            return null;
        } while ((parent = parentOwner.getParent()) != field.getContainingClass());
        return (PsiModifierListOwner)parentOwner;
    }

    private static boolean isInitializedWithSameExpression(final PsiField field, final PsiAssignmentExpression assignment, final Collection<PsiAssignmentExpression> initializingAssignments) {
        final PsiExpression expression = assignment.getRExpression();
        final Ref result = new Ref((Object)Boolean.TRUE);
        final ArrayList totalUsages = new ArrayList();
        PsiClass containingClass = field.getContainingClass();
        assert (containingClass != null);
        containingClass.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){
            private PsiCodeBlock currentInitializingBlock;

            public void visitCodeBlock(PsiCodeBlock block) {
                PsiElement parent = block.getParent();
                if (parent instanceof PsiClassInitializer || parent instanceof PsiMethod && ((PsiMethod)parent).isConstructor()) {
                    this.currentInitializingBlock = block;
                    super.visitCodeBlock(block);
                    this.currentInitializingBlock = null;
                } else {
                    super.visitCodeBlock(block);
                }
            }

            public void visitReferenceExpression(PsiReferenceExpression reference) {
                if (!((Boolean)result.get()).booleanValue()) {
                    return;
                }
                super.visitReferenceExpression(reference);
                if (!PsiUtil.isOnAssignmentLeftHand((PsiExpression)reference)) {
                    return;
                }
                PsiElement resolved = reference.resolve();
                if (resolved != field) {
                    return;
                }
                PsiExpression rValue = ((PsiAssignmentExpression)reference.getParent()).getRExpression();
                if (this.currentInitializingBlock != null) {
                    if (rValue == null || !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)rValue, (PsiElement)expression)) {
                        result.set((Object)Boolean.FALSE);
                    }
                    initializingAssignments.add((PsiAssignmentExpression)reference.getParent());
                }
                totalUsages.add(assignment);
            }
        });
        if (totalUsages.size() == 1 && initializingAssignments.isEmpty()) {
            initializingAssignments.addAll(totalUsages);
            return true;
        }
        return (Boolean)result.get();
    }

    private static PsiField getAssignedField(PsiAssignmentExpression assignment) {
        PsiExpression lExpression = assignment.getLExpression();
        if (!(lExpression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement resolved = ((PsiReferenceExpression)lExpression).resolve();
        if (!(resolved instanceof PsiField)) {
            return null;
        }
        return (PsiField)resolved;
    }

    private static PsiAssignmentExpression getAssignmentUnderCaret(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null || element instanceof PsiCompiledElement) {
            return null;
        }
        return (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAssignmentExpression.class, (boolean)false, (Class[])new Class[]{PsiMember.class});
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/MoveFieldAssignmentToInitializerAction.invoke must not be null");
        }
        PsiAssignmentExpression assignment = MoveFieldAssignmentToInitializerAction.getAssignmentUnderCaret(editor, file);
        if (assignment == null) {
            return;
        }
        PsiField field = MoveFieldAssignmentToInitializerAction.getAssignedField(assignment);
        if (field == null) {
            return;
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        ArrayList<PsiAssignmentExpression> assignments = new ArrayList<PsiAssignmentExpression>();
        if (!MoveFieldAssignmentToInitializerAction.isInitializedWithSameExpression(field, assignment, assignments)) {
            return;
        }
        PsiExpression initializer = assignment.getRExpression();
        field.setInitializer(initializer);
        for (PsiAssignmentExpression assignmentExpression : assignments) {
            PsiElement statement = assignmentExpression.getParent();
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiIfStatement || parent instanceof PsiWhileStatement || parent instanceof PsiForStatement || parent instanceof PsiForeachStatement) {
                PsiStatement emptyStatement = JavaPsiFacade.getInstance((Project)file.getProject()).getElementFactory().createStatementFromText(";", statement);
                statement.replace((PsiElement)emptyStatement);
                continue;
            }
            statement.delete();
        }
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        HighlightManager.getInstance((Project)project).addOccurrenceHighlights(editor, new PsiElement[]{field.getInitializer()}, attributes, false, null);
    }
}

