/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.ui.DocumentAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;

class CreateFieldFromParameterDialog
extends DialogWrapper {
    private final Project myProject;
    private final String[] myNames;
    private final String myType;
    private final PsiClass myTargetClass;
    private final boolean myFieldMayBeFinal;
    private JComponent myNameField;
    private JCheckBox myCbFinal;
    @NonNls
    private static final String PROPERTY_NAME = "CREATE_FIELD_FROM_PARAMETER_DECLARE_FINAL";

    public CreateFieldFromParameterDialog(Project project, String[] names, String type, PsiClass targetClass, boolean fieldMayBeFinal) {
        super(project, true);
        this.myProject = project;
        this.myNames = names;
        this.myType = type;
        this.myTargetClass = targetClass;
        this.myFieldMayBeFinal = fieldMayBeFinal;
        this.setTitle(CodeInsightBundle.message((String)"dialog.create.field.from.parameter.title", (Object[])new Object[0]));
        this.init();
    }

    protected void doOKAction() {
        PsiField[] fields;
        if (this.myCbFinal.isEnabled()) {
            PropertiesComponent.getInstance().setValue(PROPERTY_NAME, "" + this.myCbFinal.isSelected());
        }
        for (PsiField field : fields = this.myTargetClass.getFields()) {
            if (!field.getName().equals(this.getEnteredName())) continue;
            int result = Messages.showOkCancelDialog((Component)this.getContentPane(), (String)CodeInsightBundle.message((String)"dialog.create.field.from.parameter.already.exists.text", (Object[])new Object[]{this.getEnteredName()}), (String)CodeInsightBundle.message((String)"dialog.create.field.from.parameter.already.exists.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (result == 0) {
                this.close(0);
                continue;
            }
            return;
        }
        this.close(0);
    }

    protected void init() {
        super.init();
        this.updateOkStatus();
    }

    public String getEnteredName() {
        if (this.myNameField instanceof JComboBox) {
            JComboBox combobox = (JComboBox)this.myNameField;
            return (String)combobox.getEditor().getItem();
        }
        return ((JTextField)this.myNameField).getText();
    }

    public boolean isDeclareFinal() {
        if (this.myCbFinal.isEnabled()) {
            return this.myCbFinal.isSelected();
        }
        return false;
    }

    protected JComponent createNorthPanel() {
        if (this.myNames.length > 1) {
            final ComboBox combobox = new ComboBox((Object[])this.myNames, 200);
            this.myNameField = combobox;
            combobox.setEditable(true);
            combobox.setSelectedIndex(0);
            combobox.setMaximumRowCount(8);
            combobox.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (combobox.isPopupVisible()) {
                        combobox.setPopupVisible(false);
                    } else {
                        CreateFieldFromParameterDialog.this.doCancelAction();
                    }
                }
            }, KeyStroke.getKeyStroke(27, 0), 1);
            combobox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CreateFieldFromParameterDialog.this.updateOkStatus();
                }
            });
            combobox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    CreateFieldFromParameterDialog.this.updateOkStatus();
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    CreateFieldFromParameterDialog.this.updateOkStatus();
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    CreateFieldFromParameterDialog.this.updateOkStatus();
                }
            });
        } else {
            JTextField field = new JTextField(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    return new Dimension(200, size.height);
                }
            };
            this.myNameField = field;
            field.setText(this.myNames[0]);
            field.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    CreateFieldFromParameterDialog.this.updateOkStatus();
                }
            });
        }
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 4, 4, 4);
        gbConstraints.anchor = 13;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 2;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        JLabel type = new JLabel(CodeInsightBundle.message((String)"dialog.create.field.from.parameter.field.type.label", (Object[])new Object[]{this.myType}));
        panel.add((Component)type, gbConstraints);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 1;
        JLabel namePrompt = new JLabel(CodeInsightBundle.message((String)"dialog.create.field.from.parameter.field.name.label", (Object[])new Object[0]));
        panel.add((Component)namePrompt, gbConstraints);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 1;
        panel.add((Component)this.myNameField, gbConstraints);
        return panel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 2;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.insets = new Insets(0, 0, 0, 0);
        this.myCbFinal = new JCheckBox(CodeInsightBundle.message((String)"dialog.create.field.from.parameter.declare.final.checkbox", (Object[])new Object[0]));
        if (this.myFieldMayBeFinal) {
            this.myCbFinal.setSelected(PropertiesComponent.getInstance().isTrueValue(PROPERTY_NAME));
        } else {
            this.myCbFinal.setSelected(false);
            this.myCbFinal.setEnabled(false);
        }
        ++gbConstraints.gridy;
        panel.add((Component)this.myCbFinal, gbConstraints);
        this.myCbFinal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateFieldFromParameterDialog.this.requestFocusInNameWindow();
                if (CreateFieldFromParameterDialog.this.myCbFinal.isEnabled()) {
                    // empty if block
                }
            }
        });
        return panel;
    }

    private void requestFocusInNameWindow() {
        if (this.myNameField instanceof JTextField) {
            this.myNameField.requestFocusInWindow();
        } else {
            ((JComboBox)this.myNameField).getEditor().getEditorComponent().requestFocusInWindow();
        }
    }

    private void updateOkStatus() {
        String text = this.getEnteredName();
        this.setOKActionEnabled(JavaPsiFacade.getInstance((Project)this.myProject).getNameHelper().isIdentifier(text));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }
}

