/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoComponent;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JLayeredPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterInfoController {
    private final Project myProject;
    private final Editor myEditor;
    private final String myParameterCloseChars;
    private final RangeMarker myLbraceMarker;
    private final LightweightHint myHint;
    private final ParameterInfoComponent myComponent;
    private final CaretListener myEditorCaretListener;
    private final DocumentListener myEditorDocumentListener;
    private final PropertyChangeListener myLookupListener;
    @NotNull
    private final ParameterInfoHandler<Object, Object> myHandler;
    private final ShowParameterInfoHandler.BestLocationPointProvider myProvider;
    private final Alarm myAlarm;
    private static final int DELAY = 200;
    private boolean myDisposed;
    private static final Key<ArrayList<ParameterInfoController>> ALL_CONTROLLERS_KEY = Key.create((String)"ParameterInfoController.ALL_CONTROLLERS_KEY");

    public static ParameterInfoController findControllerAtOffset(Editor editor, int offset) {
        ArrayList<ParameterInfoController> allControllers = ParameterInfoController.getAllControllers(editor);
        for (int i = 0; i < allControllers.size(); ++i) {
            ParameterInfoController controller = allControllers.get(i);
            if (controller.myLbraceMarker.getStartOffset() != offset) continue;
            if (controller.myHint.isVisible()) {
                return controller;
            }
            controller.dispose();
            --i;
        }
        return null;
    }

    public Object[] getSelectedElements() {
        ParameterInfoContext context = new ParameterInfoContext(){

            public Project getProject() {
                return ParameterInfoController.this.myProject;
            }

            public PsiFile getFile() {
                return ParameterInfoController.this.myComponent.getParameterOwner().getContainingFile();
            }

            public int getOffset() {
                return ParameterInfoController.this.myEditor.getCaretModel().getOffset();
            }

            @NotNull
            public Editor getEditor() {
                Editor editor = ParameterInfoController.this.myEditor;
                if (editor == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/codeInsight/hint/ParameterInfoController$1.getEditor must not return null");
                }
                return editor;
            }
        };
        if (!this.myHandler.tracksParameterIndex()) {
            return this.myHandler.getParametersForDocumentation(this.myComponent.getObjects()[0], context);
        }
        Object[] objects = this.myComponent.getObjects();
        int selectedParameterIndex = this.myComponent.getCurrentParameterIndex();
        ArrayList<Object> params = new ArrayList<Object>(objects.length);
        for (Object o : objects) {
            Object[] availableParams = this.myHandler.getParametersForDocumentation(o, context);
            if (availableParams == null || selectedParameterIndex >= availableParams.length || selectedParameterIndex < 0) continue;
            params.add(availableParams[selectedParameterIndex]);
        }
        return ArrayUtil.toObjectArray(params);
    }

    private static ArrayList<ParameterInfoController> getAllControllers(Editor editor) {
        ArrayList array = (ArrayList)editor.getUserData(ALL_CONTROLLERS_KEY);
        if (array == null) {
            array = new ArrayList();
            editor.putUserData(ALL_CONTROLLERS_KEY, array);
        }
        return array;
    }

    public static boolean isAlreadyShown(Editor editor, int lbraceOffset) {
        return ParameterInfoController.findControllerAtOffset(editor, lbraceOffset) != null;
    }

    public ParameterInfoController(Project project, Editor editor, int lbraceOffset, LightweightHint hint, @NotNull ParameterInfoHandler handler, ShowParameterInfoHandler.BestLocationPointProvider provider) {
        if (handler == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInsight/hint/ParameterInfoController.<init> must not be null");
        }
        this.myAlarm = new Alarm();
        this.myDisposed = false;
        this.myProject = project;
        this.myEditor = editor;
        this.myHandler = handler;
        this.myProvider = provider;
        this.myParameterCloseChars = handler.getParameterCloseChars();
        this.myLbraceMarker = editor.getDocument().createRangeMarker(lbraceOffset, lbraceOffset);
        this.myHint = hint;
        this.myComponent = (ParameterInfoComponent)this.myHint.getComponent();
        ArrayList<ParameterInfoController> allControllers = ParameterInfoController.getAllControllers(this.myEditor);
        allControllers.add(this);
        this.myEditorCaretListener = new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                if (!ParameterInfoController.this.myHandler.tracksParameterIndex()) {
                    ParameterInfoController.this.myAlarm.cancelAllRequests();
                    ParameterInfoController.this.addAlarmRequest();
                    return;
                }
                int oldOffset = e.getEditor().logicalPositionToOffset(e.getOldPosition());
                int newOffset = e.getEditor().logicalPositionToOffset(e.getNewPosition());
                if (newOffset <= ParameterInfoController.this.myLbraceMarker.getStartOffset()) {
                    ParameterInfoController.this.myAlarm.cancelAllRequests();
                    ParameterInfoController.this.addAlarmRequest();
                    return;
                }
                int offset1 = Math.min(oldOffset, newOffset);
                int offset2 = Math.max(oldOffset, newOffset);
                CharSequence chars = e.getEditor().getDocument().getCharsSequence();
                int offset = CharArrayUtil.shiftForwardUntil((CharSequence)chars, (int)offset1, (String)ParameterInfoController.this.myParameterCloseChars);
                if (offset < offset2) {
                    ParameterInfoController.this.myAlarm.cancelAllRequests();
                    ParameterInfoController.this.addAlarmRequest();
                } else if (ParameterInfoController.this.myAlarm.cancelAllRequests() > 0) {
                    ParameterInfoController.this.addAlarmRequest();
                }
            }
        };
        this.myEditor.getCaretModel().addCaretListener(this.myEditorCaretListener);
        this.myEditorDocumentListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                if (!ParameterInfoController.this.myHandler.tracksParameterIndex()) {
                    ParameterInfoController.this.myAlarm.cancelAllRequests();
                    ParameterInfoController.this.addAlarmRequest();
                    return;
                }
                CharSequence oldS = e.getOldFragment();
                if (CharArrayUtil.shiftForwardUntil((CharSequence)oldS, (int)0, (String)ParameterInfoController.this.myParameterCloseChars) < oldS.length()) {
                    ParameterInfoController.this.myAlarm.cancelAllRequests();
                    ParameterInfoController.this.addAlarmRequest();
                    return;
                }
                CharSequence newS = e.getNewFragment();
                if (CharArrayUtil.shiftForwardUntil((CharSequence)newS, (int)0, (String)ParameterInfoController.this.myParameterCloseChars) < newS.length()) {
                    ParameterInfoController.this.myAlarm.cancelAllRequests();
                    ParameterInfoController.this.addAlarmRequest();
                    return;
                }
                if (ParameterInfoController.this.myAlarm.cancelAllRequests() > 0) {
                    ParameterInfoController.this.addAlarmRequest();
                }
            }
        };
        this.myEditor.getDocument().addDocumentListener(this.myEditorDocumentListener);
        this.myLookupListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Lookup lookup;
                if ("activeLookup".equals(evt.getPropertyName()) && (lookup = (Lookup)evt.getNewValue()) != null) {
                    ParameterInfoController.this.adjustPositionForLookup(lookup);
                }
            }
        };
        LookupManager.getInstance(project).addPropertyChangeListener(this.myLookupListener);
        this.updateComponent();
    }

    private void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        ArrayList<ParameterInfoController> allControllers = ParameterInfoController.getAllControllers(this.myEditor);
        allControllers.remove(this);
        this.myEditor.getCaretModel().removeCaretListener(this.myEditorCaretListener);
        this.myEditor.getDocument().removeDocumentListener(this.myEditorDocumentListener);
        LookupManager.getInstance(this.myProject).removePropertyChangeListener(this.myLookupListener);
    }

    private void adjustPositionForLookup(Lookup lookup) {
        if (!this.myHint.isVisible()) {
            this.dispose();
            return;
        }
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        short constraint = lookup.isPositionedAboveCaret() ? (short)2 : 1;
        Point p = hintManager.getHintPosition(this.myHint, this.myEditor, constraint);
        Dimension hintSize = this.myHint.getComponent().getPreferredSize();
        JLayeredPane layeredPane = this.myEditor.getComponent().getRootPane().getLayeredPane();
        p.x = Math.min(p.x, layeredPane.getWidth() - hintSize.width);
        p.x = Math.max(p.x, 0);
        this.myHint.setBounds(p.x, p.y, hintSize.width, hintSize.height);
    }

    private void addAlarmRequest() {
        Runnable request = new Runnable(){

            @Override
            public void run() {
                if (!ParameterInfoController.this.myDisposed && !ParameterInfoController.this.myProject.isDisposed()) {
                    ParameterInfoController.this.updateComponent();
                }
            }
        };
        this.myAlarm.addRequest(request, 200, ModalityState.stateForComponent((Component)this.myEditor.getComponent()));
    }

    private void updateComponent() {
        if (!this.myHint.isVisible()) {
            this.dispose();
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        CharSequence chars = this.myEditor.getDocument().getCharsSequence();
        int offset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(this.myEditor.getCaretModel().getOffset() - 1), (String)" \t") + 1;
        MyUpdateParameterInfoContext context = new MyUpdateParameterInfoContext(offset, file);
        Object elementForUpdating = this.myHandler.findElementForUpdatingParameterInfo((UpdateParameterInfoContext)context);
        if (elementForUpdating != null) {
            this.myHandler.updateParameterInfo(elementForUpdating, (UpdateParameterInfoContext)context);
            if (this.myHint.isVisible() && this.myEditor.getComponent().getRootPane() != null) {
                this.myComponent.update();
                HintManagerImpl.adjustEditorHintPosition(this.myHint, this.myEditor, this.myProvider.getBestPointPosition(this.myHint, (PsiElement)elementForUpdating, offset));
            }
        } else {
            context.removeHint();
        }
    }

    public static void nextParameter(Editor editor, int lbraceOffset) {
        ParameterInfoController controller = ParameterInfoController.findControllerAtOffset(editor, lbraceOffset);
        if (controller != null) {
            controller.prevOrNextParameter(true, (ParameterInfoHandlerWithTabActionSupport)controller.myHandler);
        }
    }

    public static void prevParameter(Editor editor, int lbraceOffset) {
        ParameterInfoController parameterInfoController = ParameterInfoController.findControllerAtOffset(editor, lbraceOffset);
        if (parameterInfoController != null) {
            parameterInfoController.prevOrNextParameter(false, (ParameterInfoHandlerWithTabActionSupport)parameterInfoController.myHandler);
        }
    }

    private void prevOrNextParameter(boolean isNext, ParameterInfoHandlerWithTabActionSupport handler) {
        Object argList;
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        CharSequence chars = this.myEditor.getDocument().getCharsSequence();
        int offset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(this.myEditor.getCaretModel().getOffset() - 1), (String)" \t") + 1;
        int lbraceOffset = this.myLbraceMarker.getStartOffset();
        if (lbraceOffset < offset && (argList = ParameterInfoController.findArgumentList(file, offset, lbraceOffset)) != null) {
            int currentParameterIndex = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)argList.getNode(), (int)offset, (IElementType)handler.getActualParameterDelimiterType());
            PsiElement currentParameter = null;
            if (currentParameterIndex > 0 && !isNext) {
                currentParameter = handler.getActualParameters(argList)[currentParameterIndex - 1];
            } else if (currentParameterIndex < handler.getActualParameters(argList).length - 1 && isNext) {
                currentParameter = handler.getActualParameters(argList)[currentParameterIndex + 1];
            }
            if (currentParameter != null) {
                offset = currentParameter.getTextRange().getStartOffset();
                this.myEditor.getCaretModel().moveToOffset(offset);
                this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                this.myEditor.getSelectionModel().removeSelection();
                handler.updateParameterInfo(argList, (UpdateParameterInfoContext)new MyUpdateParameterInfoContext(offset, file));
            }
        }
    }

    @Nullable
    public static <E extends PsiElement> E findArgumentList(PsiFile file, int offset, int lbraceOffset) {
        if (file == null) {
            return null;
        }
        ParameterInfoHandler[] handlers = ShowParameterInfoHandler.getHandlers(PsiUtilBase.getLanguageAtOffset((PsiFile)file, (int)offset), file.getViewProvider().getBaseLanguage());
        if (handlers != null) {
            for (ParameterInfoHandler handler : handlers) {
                ParameterInfoHandlerWithTabActionSupport parameterInfoHandler2;
                PsiElement e;
                if (!(handler instanceof ParameterInfoHandlerWithTabActionSupport) || (e = ParameterInfoUtils.findArgumentList((PsiFile)file, (int)offset, (int)lbraceOffset, (ParameterInfoHandlerWithTabActionSupport)(parameterInfoHandler2 = (ParameterInfoHandlerWithTabActionSupport)handler))) == null) continue;
                return (E)e;
            }
        }
        return null;
    }

    private class MyUpdateParameterInfoContext
    implements UpdateParameterInfoContext {
        private final int myOffset;
        private final PsiFile myFile;

        public MyUpdateParameterInfoContext(int offset, PsiFile file) {
            this.myOffset = offset;
            this.myFile = file;
        }

        public int getParameterListStart() {
            return ParameterInfoController.this.myLbraceMarker.getStartOffset();
        }

        public int getOffset() {
            return this.myOffset;
        }

        public Project getProject() {
            return ParameterInfoController.this.myProject;
        }

        public PsiFile getFile() {
            return this.myFile;
        }

        @NotNull
        public Editor getEditor() {
            Editor editor = ParameterInfoController.this.myEditor;
            if (editor == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/hint/ParameterInfoController$MyUpdateParameterInfoContext.getEditor must not return null");
            }
            return editor;
        }

        public void removeHint() {
            ParameterInfoController.this.myHint.hide();
            ParameterInfoController.this.dispose();
        }

        public void setParameterOwner(PsiElement o) {
            ParameterInfoController.this.myComponent.setParameterOwner(o);
        }

        public PsiElement getParameterOwner() {
            return ParameterInfoController.this.myComponent.getParameterOwner();
        }

        public void setHighlightedParameter(Object method) {
            ParameterInfoController.this.myComponent.setHighlightedParameter(method);
        }

        public void setCurrentParameter(int index) {
            ParameterInfoController.this.myComponent.setCurrentParameterIndex(index);
        }

        public boolean isUIComponentEnabled(int index) {
            return ParameterInfoController.this.myComponent.isEnabled(index);
        }

        public void setUIComponentEnabled(int index, boolean b) {
            ParameterInfoController.this.myComponent.setEnabled(index, b);
        }

        public Object[] getObjectsToView() {
            return ParameterInfoController.this.myComponent.getObjects();
        }
    }
}

