/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.highlighting.HighlightOverridingMethodsHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiReferenceList;

public class HighlightOverridingMethodsHandlerFactory
implements HighlightUsagesHandlerFactory {
    @Override
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(Editor editor, PsiFile file) {
        int offset = TargetElementUtilBase.adjustOffset(editor.getDocument(), editor.getCaretModel().getOffset());
        PsiElement target = file.findElementAt(offset);
        if (target instanceof PsiKeyword && ("extends".equals(target.getText()) || "implements".equals(target.getText()))) {
            PsiElement parent = target.getParent();
            if (!(parent instanceof PsiReferenceList)) {
                return null;
            }
            PsiElement grand = parent.getParent();
            if (!(grand instanceof PsiClass)) {
                return null;
            }
            return new HighlightOverridingMethodsHandler(editor, file, target, (PsiClass)grand);
        }
        return null;
    }
}

