/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.PairedBraceMatcherAdapter;
import com.intellij.codeInsight.highlighting.XmlAwareBraceMatcher;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageBraceMatching;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BraceMatchingUtil {
    public static final int UNDEFINED_TOKEN_GROUP = -1;
    private static final HashMap<FileType, BraceMatcher> BRACE_MATCHERS = new HashMap();
    private static final Stack<IElementType> ourBraceStack = new Stack();
    private static final Stack<String> ourTagNameStack = new Stack();

    private BraceMatchingUtil() {
    }

    public static boolean isPairedBracesAllowedBeforeTypeInFileType(IElementType lbraceType, IElementType tokenType, FileType fileType) {
        try {
            return BraceMatchingUtil.getBraceMatcher(fileType, lbraceType).isPairedBracesAllowedBeforeType(lbraceType, tokenType);
        }
        catch (AbstractMethodError abstractMethodError) {
            return true;
        }
    }

    public static void registerBraceMatcher(FileType fileType, BraceMatcher braceMatcher) {
        BRACE_MATCHERS.put(fileType, braceMatcher);
    }

    public static synchronized boolean matchBrace(CharSequence fileText, FileType fileType, HighlighterIterator iterator, boolean forward) {
        return new MatchBraceContext(fileText, fileType, iterator, forward).doBraceMatch();
    }

    public static synchronized boolean matchBrace(CharSequence fileText, FileType fileType, HighlighterIterator iterator, boolean forward, boolean isStrict) {
        return new MatchBraceContext(fileText, fileType, iterator, forward, isStrict).doBraceMatch();
    }

    public static boolean findStructuralLeftBrace(FileType fileType, HighlighterIterator iterator, CharSequence fileText) {
        ourBraceStack.clear();
        ourTagNameStack.clear();
        BraceMatcher matcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        while (!iterator.atEnd()) {
            if (BraceMatchingUtil.isStructuralBraceToken(fileType, iterator, fileText)) {
                if (BraceMatchingUtil.isRBraceToken(iterator, fileText, fileType)) {
                    ourBraceStack.push(iterator.getTokenType());
                    ourTagNameStack.push(BraceMatchingUtil.getTagName(matcher, fileText, iterator));
                }
                if (BraceMatchingUtil.isLBraceToken(iterator, fileText, fileType)) {
                    if (ourBraceStack.isEmpty()) {
                        return true;
                    }
                    int group = matcher.getBraceTokenGroupId(iterator.getTokenType());
                    IElementType topTokenType = ourBraceStack.pop();
                    IElementType tokenType = iterator.getTokenType();
                    boolean isStrict = BraceMatchingUtil.isStrictTagMatching(matcher, fileType, group);
                    boolean isCaseSensitive = BraceMatchingUtil.areTagsCaseSensitive(matcher, fileType, group);
                    String topTagName = null;
                    String tagName = null;
                    if (isStrict) {
                        topTagName = ourTagNameStack.pop();
                        tagName = BraceMatchingUtil.getTagName(matcher, fileText, iterator);
                    }
                    if (!BraceMatchingUtil.isPairBraces(topTokenType, tokenType, fileType) || isStrict && !Comparing.equal((String)topTagName, (String)tagName, (boolean)isCaseSensitive)) {
                        return false;
                    }
                }
            }
            iterator.retreat();
        }
        return false;
    }

    public static boolean isStructuralBraceToken(FileType fileType, HighlighterIterator iterator, CharSequence text) {
        BraceMatcher matcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        return matcher.isStructuralBrace(iterator, text, fileType);
    }

    public static boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        return braceMatcher.isLBraceToken(iterator, fileText, fileType);
    }

    public static boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        return braceMatcher.isRBraceToken(iterator, fileText, fileType);
    }

    public static boolean isPairBraces(IElementType tokenType1, IElementType tokenType2, FileType fileType) {
        BraceMatcher matcher = BraceMatchingUtil.getBraceMatcher(fileType, tokenType1);
        return matcher.isPairBraces(tokenType1, tokenType2);
    }

    private static int getTokenGroup(IElementType tokenType, FileType fileType) {
        BraceMatcher matcher = BraceMatchingUtil.getBraceMatcher(fileType, tokenType);
        return matcher.getBraceTokenGroupId(tokenType);
    }

    public static int findLeftmostLParen(HighlighterIterator iterator, IElementType lparenTokenType, CharSequence fileText, FileType fileType) {
        int lastLbraceOffset = -1;
        Stack<IElementType> braceStack = new Stack<IElementType>();
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (BraceMatchingUtil.isLBraceToken(iterator, fileText, fileType)) {
                if (!braceStack.isEmpty()) {
                    IElementType topToken = (IElementType)braceStack.pop();
                    if (!BraceMatchingUtil.isPairBraces(tokenType, topToken, fileType)) {
                        break;
                    }
                } else {
                    if (tokenType != lparenTokenType) break;
                    lastLbraceOffset = iterator.getStart();
                }
            } else if (BraceMatchingUtil.isRBraceToken(iterator, fileText, fileType)) {
                braceStack.push(iterator.getTokenType());
            }
            iterator.retreat();
        }
        return lastLbraceOffset;
    }

    public static int findRightmostRParen(HighlighterIterator iterator, IElementType rparenTokenType, CharSequence fileText, FileType fileType) {
        int lastRbraceOffset = -1;
        Stack<IElementType> braceStack = new Stack<IElementType>();
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (BraceMatchingUtil.isRBraceToken(iterator, fileText, fileType)) {
                if (!braceStack.isEmpty()) {
                    IElementType topToken = (IElementType)braceStack.pop();
                    if (!BraceMatchingUtil.isPairBraces(tokenType, topToken, fileType)) {
                        break;
                    }
                } else {
                    if (tokenType != rparenTokenType) break;
                    lastRbraceOffset = iterator.getStart();
                }
            } else if (BraceMatchingUtil.isLBraceToken(iterator, fileText, fileType)) {
                braceStack.push(iterator.getTokenType());
            }
            iterator.advance();
        }
        return lastRbraceOffset;
    }

    @NotNull
    public static BraceMatcher getBraceMatcher(@NotNull FileType fileType, @NotNull HighlighterIterator iterator) {
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceMatchingUtil.getBraceMatcher must not be null");
        }
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceMatchingUtil.getBraceMatcher must not be null");
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator.getTokenType());
        if (braceMatcher == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/highlighting/BraceMatchingUtil.getBraceMatcher must not return null");
        }
        return braceMatcher;
    }

    @NotNull
    public static BraceMatcher getBraceMatcher(@NotNull FileType fileType, @NotNull IElementType type) {
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceMatchingUtil.getBraceMatcher must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceMatchingUtil.getBraceMatcher must not be null");
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, type.getLanguage());
        if (braceMatcher == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/highlighting/BraceMatchingUtil.getBraceMatcher must not return null");
        }
        return braceMatcher;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static BraceMatcher getBraceMatcher(FileType fileType, Language lang) {
        Language language;
        BraceMatcher braceMatcher;
        BraceMatcher byFileType = BraceMatchingUtil.getBraceMatcherByFileType(fileType);
        if (byFileType != null) {
            braceMatcher = byFileType;
            if (braceMatcher == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/highlighting/BraceMatchingUtil.getBraceMatcher must not return null");
            return braceMatcher;
        }
        PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(lang);
        if (matcher != null) {
            braceMatcher = new PairedBraceMatcherAdapter(matcher, lang);
            if (braceMatcher == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/highlighting/BraceMatchingUtil.getBraceMatcher must not return null");
            return braceMatcher;
        }
        if (fileType instanceof LanguageFileType && lang != (language = ((LanguageFileType)fileType).getLanguage())) {
            BraceMatcher braceMatcher2;
            FileType type1 = lang.getAssociatedFileType();
            if (type1 != null && (braceMatcher2 = BraceMatchingUtil.getBraceMatcherByFileType(type1)) != null) {
                braceMatcher = braceMatcher2;
                if (braceMatcher == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/highlighting/BraceMatchingUtil.getBraceMatcher must not return null");
                return braceMatcher;
            }
            matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(language);
            if (matcher != null) {
                braceMatcher = new PairedBraceMatcherAdapter(matcher, language);
                if (braceMatcher == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/highlighting/BraceMatchingUtil.getBraceMatcher must not return null");
                return braceMatcher;
            }
        }
        if ((braceMatcher = BraceMatcherHolder.ourDefaultBraceMatcher) != null) return braceMatcher;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/highlighting/BraceMatchingUtil.getBraceMatcher must not return null");
    }

    @Nullable
    private static BraceMatcher getBraceMatcherByFileType(FileType fileType) {
        BraceMatcher braceMatcher = BRACE_MATCHERS.get(fileType);
        if (braceMatcher != null) {
            return braceMatcher;
        }
        for (FileTypeExtensionPoint ext : (FileTypeExtensionPoint[])Extensions.getExtensions(BraceMatcher.EP_NAME)) {
            if (!fileType.getName().equals(ext.filetype)) continue;
            braceMatcher = (BraceMatcher)ext.getInstance();
            BRACE_MATCHERS.put(fileType, braceMatcher);
            return braceMatcher;
        }
        return null;
    }

    private static boolean isStrictTagMatching(BraceMatcher matcher, FileType fileType, int group) {
        return matcher instanceof XmlAwareBraceMatcher && ((XmlAwareBraceMatcher)matcher).isStrictTagMatching(fileType, group);
    }

    private static boolean areTagsCaseSensitive(BraceMatcher matcher, FileType fileType, int tokenGroup) {
        return matcher instanceof XmlAwareBraceMatcher && ((XmlAwareBraceMatcher)matcher).areTagsCaseSensitive(fileType, tokenGroup);
    }

    @Nullable
    private static String getTagName(BraceMatcher matcher, CharSequence fileText, HighlighterIterator iterator) {
        if (matcher instanceof XmlAwareBraceMatcher) {
            return ((XmlAwareBraceMatcher)matcher).getTagName(fileText, iterator);
        }
        return null;
    }

    private static class DefaultBraceMatcher
    implements BraceMatcher {
        private DefaultBraceMatcher() {
        }

        @Override
        public int getBraceTokenGroupId(IElementType tokenType) {
            return -1;
        }

        @Override
        public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
            return false;
        }

        @Override
        public boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
            return false;
        }

        @Override
        public boolean isPairBraces(IElementType tokenType, IElementType tokenType2) {
            return false;
        }

        @Override
        public boolean isStructuralBrace(HighlighterIterator iterator, CharSequence text, FileType fileType) {
            return false;
        }

        @Override
        public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
            if (type == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceMatchingUtil$DefaultBraceMatcher.getOppositeBraceTokenType must not be null");
            }
            return null;
        }

        @Override
        public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
            if (lbraceType == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/highlighting/BraceMatchingUtil$DefaultBraceMatcher.isPairedBracesAllowedBeforeType must not be null");
            }
            return true;
        }

        @Override
        public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
            return openingBraceOffset;
        }
    }

    private static class BraceMatcherHolder {
        private static final BraceMatcher ourDefaultBraceMatcher = new DefaultBraceMatcher();

        private BraceMatcherHolder() {
        }
    }

    private static class MatchBraceContext {
        CharSequence fileText;
        FileType fileType;
        HighlighterIterator iterator;
        boolean forward;
        IElementType brace1Token;
        int group;
        String brace1TagName;
        boolean isStrict;
        boolean isCaseSensitive;
        boolean isStructural;
        private BraceMatcher myMatcher;

        MatchBraceContext(CharSequence _fileText, FileType _fileType, HighlighterIterator _iterator, boolean _forward) {
            this.fileText = _fileText;
            this.fileType = _fileType;
            this.iterator = _iterator;
            this.forward = _forward;
            this.myMatcher = BraceMatchingUtil.getBraceMatcher(_fileType, _iterator);
            this.brace1Token = this.iterator.getTokenType();
            this.group = BraceMatchingUtil.getTokenGroup(this.brace1Token, this.fileType);
            this.brace1TagName = this.myMatcher == null ? null : BraceMatchingUtil.getTagName(this.myMatcher, this.fileText, this.iterator);
            this.isStrict = this.myMatcher != null && BraceMatchingUtil.isStrictTagMatching(this.myMatcher, this.fileType, this.group);
            this.isStructural = !this.isStrict && this.myMatcher != null && this.myMatcher.isStructuralBrace(this.iterator, this.fileText, this.fileType);
            this.isCaseSensitive = this.myMatcher != null && BraceMatchingUtil.areTagsCaseSensitive(this.myMatcher, this.fileType, this.group);
        }

        MatchBraceContext(CharSequence _fileText, FileType _fileType, HighlighterIterator _iterator, boolean _forward, boolean _strict) {
            this(_fileText, _fileType, _iterator, _forward);
            this.isStrict = _strict;
        }

        boolean doBraceMatch() {
            boolean matched;
            block9: {
                ourBraceStack.clear();
                ourTagNameStack.clear();
                ourBraceStack.push(this.brace1Token);
                if (this.isStrict) {
                    ourTagNameStack.push(this.brace1TagName);
                }
                matched = false;
                while (true) {
                    String tagName;
                    if (!this.forward) {
                        this.iterator.retreat();
                    } else {
                        this.iterator.advance();
                    }
                    if (this.iterator.atEnd()) break block9;
                    IElementType tokenType = this.iterator.getTokenType();
                    if (BraceMatchingUtil.getTokenGroup(tokenType, this.fileType) != this.group) continue;
                    String string = tagName = this.myMatcher == null ? null : BraceMatchingUtil.getTagName(this.myMatcher, this.fileText, this.iterator);
                    if (!this.isStrict && !Comparing.equal((String)this.brace1TagName, (String)tagName, (boolean)this.isCaseSensitive) || this.isStructural && (this.forward ? BraceMatchingUtil.isRBraceToken(this.iterator, this.fileText, this.fileType) && !BraceMatchingUtil.isPairBraces(this.brace1Token, tokenType, this.fileType) : BraceMatchingUtil.isLBraceToken(this.iterator, this.fileText, this.fileType) && !BraceMatchingUtil.isPairBraces(this.brace1Token, tokenType, this.fileType)) && !ourBraceStack.isEmpty() && this.myMatcher != null && !ourBraceStack.contains(this.myMatcher.getOppositeBraceTokenType(tokenType))) continue;
                    if (this.forward ? BraceMatchingUtil.isLBraceToken(this.iterator, this.fileText, this.fileType) : BraceMatchingUtil.isRBraceToken(this.iterator, this.fileText, this.fileType)) {
                        ourBraceStack.push(tokenType);
                        if (!this.isStrict) continue;
                        ourTagNameStack.push(tagName);
                        continue;
                    }
                    if (!(this.forward ? BraceMatchingUtil.isRBraceToken(this.iterator, this.fileText, this.fileType) : BraceMatchingUtil.isLBraceToken(this.iterator, this.fileText, this.fileType))) continue;
                    IElementType topTokenType = (IElementType)ourBraceStack.pop();
                    String topTagName = null;
                    if (this.isStrict) {
                        topTagName = (String)ourTagNameStack.pop();
                    }
                    if (!this.isStrict && this.myMatcher != null && ourBraceStack.contains(this.myMatcher.getOppositeBraceTokenType(tokenType))) {
                        while (!BraceMatchingUtil.isPairBraces(topTokenType, tokenType, this.fileType)) {
                            topTokenType = (IElementType)ourBraceStack.pop();
                        }
                    }
                    if (!BraceMatchingUtil.isPairBraces(topTokenType, tokenType, this.fileType) || this.isStrict && !Comparing.equal((String)topTagName, (String)tagName, (boolean)this.isCaseSensitive)) {
                        matched = false;
                        break block9;
                    }
                    if (ourBraceStack.isEmpty()) break;
                }
                matched = true;
            }
            return matched;
        }
    }
}

