/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.ide.highlighter.XmlLikeFileType;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateSurrounder
implements Surrounder {
    protected final TemplateImpl myTemplate;

    public TemplateSurrounder(TemplateImpl template) {
        this.myTemplate = template;
    }

    public String getTemplateDescription() {
        return this.myTemplate.getDescription();
    }

    public boolean isApplicableForFileType(FileType fileType) {
        TemplateContext templateContext = this.myTemplate.getTemplateContext();
        if (fileType instanceof XmlLikeFileType) {
            for (TemplateContextType contextType : (TemplateContextType[])Extensions.getExtensions(TemplateContextType.EP_NAME)) {
                if (!contextType.isInContext(fileType) || !templateContext.isEnabled(contextType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/generation/surroundWith/TemplateSurrounder.isApplicable must not be null");
        }
        FileType fileType = elements[0].getContainingFile().getFileType();
        return this.isApplicableForFileType(fileType);
    }

    @Nullable
    public TextRange surroundElements(final @NotNull Project project, final @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/generation/surroundWith/TemplateSurrounder.surroundElements must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/generation/surroundWith/TemplateSurrounder.surroundElements must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/generation/surroundWith/TemplateSurrounder.surroundElements must not be null");
        }
        boolean languageWithWSSignificant = this.isLanguageWithWSSignificant(elements[0]);
        int startOffset = languageWithWSSignificant ? editor.getSelectionModel().getSelectionStart() : elements[0].getTextRange().getStartOffset();
        int endOffset = languageWithWSSignificant ? editor.getSelectionModel().getSelectionEnd() : elements[elements.length - 1].getTextRange().getEndOffset();
        editor.getCaretModel().moveToOffset(startOffset);
        editor.getSelectionModel().setSelection(startOffset, endOffset);
        String text = editor.getDocument().getText().substring(startOffset, endOffset);
        if (!languageWithWSSignificant) {
            text = text.trim();
        }
        final String text1 = text;
        Runnable action = new Runnable(){

            @Override
            public void run() {
                TemplateManager.getInstance(project).startTemplate(editor, text1, TemplateSurrounder.this.myTemplate);
            }
        };
        if (languageWithWSSignificant) {
            PsiManager.getInstance((Project)project).performActionWithFormatterDisabled(action);
        } else {
            action.run();
        }
        return null;
    }

    private boolean isLanguageWithWSSignificant(PsiElement element) {
        return this.isLanguageWithWSSignificant(TemplateSurrounder.getLanguage(element)) || element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS;
    }

    protected boolean isLanguageWithWSSignificant(Language lang) {
        return lang == HTMLLanguage.INSTANCE || lang == XHTMLLanguage.INSTANCE;
    }

    private static Language getLanguage(PsiElement element) {
        Language lang = element.getLanguage();
        if (lang == XMLLanguage.INSTANCE) {
            lang = element.getParent().getLanguage();
        }
        return lang;
    }
}

